/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_minecraft.mixin;

import com.craisinlord.integrated_minecraft.IntegratedMinecraft;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.item.armor.ExtendedArmorMaterials;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ExtendedArmorMaterials.class})
public class ExtendedArmorMaterialsMixin {
    static {
        try {
            ExtendedArmorMaterials[] materialsToUpdate;
            for (ExtendedArmorMaterials material : materialsToUpdate = new ExtendedArmorMaterials[]{ExtendedArmorMaterials.PYROMANCER, ExtendedArmorMaterials.ARCHEVOKER, ExtendedArmorMaterials.CULTIST, ExtendedArmorMaterials.CRYOMANCER, ExtendedArmorMaterials.PRIEST, ExtendedArmorMaterials.SHADOWWALKER, ExtendedArmorMaterials.PLAGUED, ExtendedArmorMaterials.NETHERITE_BATTLEMAGE, ExtendedArmorMaterials.ELECTROMANCER}) {
                Map<Attribute, AttributeModifier> updatedAttributes = Map.of((Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("Max Mana", 75.0, AttributeModifier.Operation.ADDITION));
                Field attributesField = ExtendedArmorMaterials.class.getDeclaredField("additionalAttributes");
                attributesField.setAccessible(true);
                attributesField.set(material, updatedAttributes);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            IntegratedMinecraft.LOGGER.error("Integrated Minecraft: Error modifying armor materials: ", (Throwable)e);
        }
    }
}

