/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public enum FDMelons implements PlantDataEntry<FDMelons>
{
    HAMIMELON(2, 0.3f, true);

    private final BlockEntry<FDMelonBlock> melon;
    private final BlockEntry<StemBlock> stem;
    private final BlockEntry<AttachedStemBlock> attachedStem;
    private final ItemEntry<Item> slice;
    private final ItemEntry<ItemNameBlockItem> seed;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;

    private FDMelons(int food, float sat, boolean fast) {
        String name = this.name().toLowerCase(Locale.ROOT);
        this.configKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("fruitsdelight", name));
        this.placementKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("fruitsdelight", name));
        this.melon = ((BlockBuilder)FruitsDelight.REGISTRATE.block(name, p -> new FDMelonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50186_))).blockstate(this::buildMelonModel).loot(this::buildMelonLoot).tag(new TagKey[]{BlockTags.f_13046_, BlockTags.f_144280_, BlockTags.f_278398_}).item().build()).register();
        this.stem = FruitsDelight.REGISTRATE.block(name + "_stem", p -> new StemBlock(this.getMelonBlock(), this::getSeed, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50190_))).blockstate(this::buildStemModel).loot(this::buildStemLoot).tag(new TagKey[]{BlockTags.f_279534_, BlockTags.f_144280_, BlockTags.f_278398_}).register();
        this.attachedStem = FruitsDelight.REGISTRATE.block("attached_" + name + "_stem", p -> new AttachedStemBlock(this.getMelonBlock(), this::getSeed, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50188_))).blockstate(this::buildAttachedStemModel).loot(this::buildAttachedStemLoot).tag(new TagKey[]{BlockTags.f_279534_, BlockTags.f_144280_, BlockTags.f_278398_}).register();
        this.slice = FruitsDelight.REGISTRATE.item(name + "_slice", p -> new Item(p.m_41489_(FDMelons.food(food, sat, fast)))).register();
        this.seed = FruitsDelight.REGISTRATE.item(name + "_seeds", p -> new ItemNameBlockItem((Block)this.getStem(), p)).register();
    }

    public StemGrownBlock getMelonBlock() {
        return (StemGrownBlock)this.melon.get();
    }

    public StemBlock getStem() {
        return (StemBlock)this.stem.get();
    }

    public AttachedStemBlock getAttachedStem() {
        return (AttachedStemBlock)this.attachedStem.get();
    }

    public Item getSlice() {
        return (Item)this.slice.get();
    }

    public ItemNameBlockItem getSeed() {
        return (ItemNameBlockItem)this.seed.get();
    }

    @Override
    public void registerConfigs(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        FeatureUtils.m_254977_(ctx, this.configKey, (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(24, 5, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)this.getMelonBlock())), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_246848_(), BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_49992_})}))));
    }

    @Override
    public void registerPlacements(BootstapContext<PlacedFeature> ctx) {
        PlacementUtils.m_255206_(ctx, this.placementKey, (Holder)ctx.m_255420_(Registries.f_256911_).m_255043_(this.configKey), (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)64), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    @Override
    public void registerComposter() {
        ComposterBlock.f_51914_.put((Object)this.getSeed(), 0.3f);
        ComposterBlock.f_51914_.put((Object)this.getSlice(), 0.5f);
        ComposterBlock.f_51914_.put((Object)this.getMelonBlock().m_5456_(), 0.65f);
    }

    @Override
    public void genRecipe(RegistrateRecipeProvider pvd) {
        pvd.singleItem(DataIngredient.items((ItemLike)this.getSlice(), (ItemLike[])new Item[0]), RecipeCategory.MISC, this::getSeed, 1, 1);
        pvd.square(DataIngredient.items((ItemLike)this.getSlice(), (ItemLike[])new Item[0]), RecipeCategory.MISC, this::getMelonBlock, false);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getMelonBlock()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)this.getSlice(), (int)9, (int)1).build((Consumer)pvd, new ResourceLocation("fruitsdelight", this.getName() + "_cutting"));
    }

    private void buildMelonModel(DataGenContext<Block, FDMelonBlock> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.name().toLowerCase(Locale.ROOT);
        pvd.simpleBlock((Block)ctx.get(), (ModelFile)pvd.models().cubeColumn(ctx.getName(), pvd.modLoc("block/" + name + "_side"), pvd.modLoc("block/" + name + "_top")));
    }

    private void buildStemModel(DataGenContext<Block, StemBlock> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.name().toLowerCase(Locale.ROOT);
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(ctx.getName() + "_stage" + age, "block/stem_growth" + age)).texture("stem", pvd.modLoc("block/" + name + "_stem"))).renderType("cutout")).build();
        });
    }

    private void buildAttachedStemModel(DataGenContext<Block, AttachedStemBlock> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.name().toLowerCase(Locale.ROOT);
        pvd.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(ctx.getName(), "block/stem_fruit")).texture("stem", pvd.modLoc("block/" + name + "_stem"))).texture("upperstem", pvd.modLoc("block/" + name + "_attached"))).renderType("cutout"), 270);
    }

    private void buildMelonLoot(RegistrateBlockLootTables pvd, FDMelonBlock block) {
        pvd.m_247577_((Block)block, RegistrateBlockLootTables.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)this.getSlice()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165040_((int)9)))))));
    }

    private void buildStemLoot(RegistrateBlockLootTables pvd, StemBlock block) {
        pvd.m_247577_((Block)block, pvd.m_247642_((Block)block, (Item)this.getSeed()));
    }

    private void buildAttachedStemLoot(RegistrateBlockLootTables pvd, AttachedStemBlock block) {
        pvd.m_247577_((Block)block, pvd.m_246312_((Block)block, (Item)this.getSeed()));
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().m_38760_(food).m_38758_(sat);
        if (fast) {
            ans.m_38766_();
        }
        return ans.m_38767_();
    }

    private static int stemColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        int i = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
        return i << 21 | 255 - (i << 3) << 8 | i << 2;
    }

    private static int attachedColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        return 14731036;
    }

    public static void registerColor(RegisterColorHandlersEvent.Block event) {
        for (FDMelons melon : FDMelons.values()) {
            event.register(FDMelons::stemColor, new Block[]{melon.getStem()});
            event.register(FDMelons::attachedColor, new Block[]{melon.getAttachedStem()});
        }
    }

    public static void register() {
    }

    private class FDMelonBlock
    extends StemGrownBlock {
        public FDMelonBlock(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public StemBlock m_7161_() {
            return (StemBlock)FDMelons.this.stem.get();
        }

        public AttachedStemBlock m_7810_() {
            return (AttachedStemBlock)FDMelons.this.attachedStem.get();
        }
    }
}

