/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class BBCommonConfigs {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LEVEL1_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LEVEL2_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LEVEL3_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SECONDARY_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> TERTIARY_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> KEYS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TERTIARY_EFFECTS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PAYMENT_ITEM_RANGE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_BASE_BLOCK_AMPLIFIER;
    public static final ForgeConfigSpec.BooleanValue ENABLE_BEACON_BEAM_REDIRECTION;
    public static final ForgeConfigSpec.BooleanValue ENABLE_BEACON_BEAM_TRANSPARENCY;
    public static final ForgeConfigSpec.BooleanValue ENABLE_WATERLOGGING;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CONDUCT_REDSTONE;
    public static final ForgeConfigSpec.BooleanValue LOCK_BEACON;
    public static final ForgeConfigSpec.ConfigValue<Integer> HORIZONTAL_MOVE_LIMIT;

    static {
        BUILDER.push("Beacon Effects");
        ENABLE_TERTIARY_EFFECTS = BUILDER.comment("If false the beacon will not have a level 5 with the tertiary effects. Also, the GUI will change to fit the config. Keep in mind that the \"current payment\" will not be in the new GUI. DEFAULT: True").define("Enable Tertiary Effects", true);
        LEVEL1_EFFECTS = BUILDER.comment("This is a list that contains the effects that a beacon has when at level 1. I would recommend a maximum of three effects to prevent them from extending beyond the GUI. DEFAULT: \"minecraft:speed\", \"minecraft:jump_boost\"").defineList("Level 1 Effects", List.of("minecraft:speed", "minecraft:jump_boost"), entry -> entry instanceof String);
        LEVEL2_EFFECTS = BUILDER.comment("This is a list that contains the effects that a beacon has when at level 2. I would recommend a maximum of three effects to prevent them from extending beyond the GUI. DEFAULT: \"minecraft:haste\", \"better_beacons:long_reach\"").defineList("Level 2 Effects", List.of("minecraft:haste", "better_beacons:long_reach"), entry -> entry instanceof String);
        LEVEL3_EFFECTS = BUILDER.comment("This is a list that contains the effects that a beacon has when at level 3. I would recommend a maximum of three effects to prevent them from extending beyond the GUI. DEFAULT: \"minecraft:strength\", \"minecraft:resistance\"").defineList("Level 3 Effects", List.of("minecraft:strength", "minecraft:resistance"), entry -> entry instanceof String);
        SECONDARY_EFFECTS = BUILDER.comment("This is a list that contains the secondary effects that a beacon has when at level 4. I would recommend a maximum of four effects to prevent them from extending beyond the GUI. DEFAULT: \"minecraft:night_vision\", \"minecraft:regeneration\", \"minecraft:fire_resistance\"").defineList("Secondary Effects", List.of("minecraft:night_vision", "minecraft:regeneration", "minecraft:fire_resistance"), entry -> entry instanceof String);
        TERTIARY_EFFECTS = BUILDER.comment("This is a list that contains the tertiary effects that a beacon has when at level 5. I would recommend a maximum of two effects to prevent them from extending beyond the GUI. DEFAULT: \"better_beacons:phantom_bane\", \"better_beacons:patrol_nullifier\"").defineList("Tertiary Effects", List.of("better_beacons:phantom_bane", "better_beacons:patrol_nullifier"), entry -> entry instanceof String);
        BUILDER.pop();
        BUILDER.push("Payment Item Range && Block Amplifier");
        ENABLE_PAYMENT_ITEM_RANGE = BUILDER.comment("Sets if depending on the payment item used the range of the beacon will increase. DEFAULT: True").define("Enable Payment Item Range", true);
        ENABLE_BASE_BLOCK_AMPLIFIER = BUILDER.comment("Sets if depending on the base block used to build the beacon the primary effect amplifier (effect level) will increase. DEFAULT: True").define("Enable Base Block Amplifier", true);
        BUILDER.pop();
        BUILDER.push("Redirection && Transparency");
        ENABLE_BEACON_BEAM_REDIRECTION = BUILDER.comment("Sets if the beacon beam can be redirected. DEFAULT: True").define("Enable Beacon Beam Redirection", true);
        ENABLE_BEACON_BEAM_TRANSPARENCY = BUILDER.comment("Sets if the beacon beam can become transparent. DEFAULT: True").define("Enable Beacon Beam Transparency", true);
        HORIZONTAL_MOVE_LIMIT = BUILDER.comment("Sets the maximum amount of blocks that the beacon beam can extend while horizontal. DEFAULT: 64").define("Horizontal Move Limit", (Object)64);
        BUILDER.pop();
        BUILDER.push("Waterlogging && Redstone");
        ENABLE_WATERLOGGING = BUILDER.comment("Sets if the beacon can be waterlogged. DEFAULT: True").define("Enable Waterlogging", true);
        ENABLE_CONDUCT_REDSTONE = BUILDER.comment("Sets if the beacon can conduct redstone. DEFAULT: True").define("Enable Conduct Redstone", true);
        BUILDER.pop();
        BUILDER.push("Lock Beacon");
        LOCK_BEACON = BUILDER.comment("Sets if the beacon needs a special item (Key) to open it for the first time. DEFAULT: False").define("Lock Beacon", false);
        KEYS = BUILDER.comment("You can put in this list all items that can be used to unlock the beacon. Example: [\"minecraft:stick\", \"minecraft:bone\"]. DEFAULT: Nothing").defineList("Keys", List.of(), entry -> entry instanceof String);
        SPEC = BUILDER.build();
    }
}

