/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.util.easing;

import dev.obscuria.fragmentum.util.easing.EasingFunction;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.Mth;
import org.apache.commons.compress.utils.Lists;

public final class CubicCurve {
    private final List<Point> controlPoints = Lists.newArrayList();
    private final List<Point> points = Lists.newArrayList();
    private final int resolution;
    private boolean isDirty = true;

    public CubicCurve(int resolution) {
        this.resolution = Mth.m_14045_((int)resolution, (int)0, (int)100);
    }

    public CubicCurve addPoint(double x, double y) {
        return this.addPoint((float)x, (float)y);
    }

    public CubicCurve addPoint(float x, float y) {
        this.controlPoints.add(new Point(x, y));
        this.controlPoints.sort(Comparator.comparingDouble(it -> it.x));
        this.isDirty = true;
        return this;
    }

    public Point samplePoint(float x) {
        if (this.isDirty) {
            this.bake();
        }
        if (this.points.isEmpty()) {
            return Point.ZERO;
        }
        float index = Mth.m_14036_((float)(x * (float)(this.points.size() - 1)), (float)0.0f, (float)(this.points.size() - 1));
        return this.points.get((int)index);
    }

    public float sample(float x) {
        return this.samplePoint((float)x).y;
    }

    public EasingFunction toEasing() {
        return this::sample;
    }

    private void bake() {
        this.isDirty = false;
        this.points.clear();
        float res = 1.0f / (float)this.resolution;
        int segments = this.controlPoints.size() - 1;
        for (int i = 0; i < segments; ++i) {
            Point point = this.controlPoints.get(i);
            Point nextPoint = this.controlPoints.get(i + 1);
            float xDiff = nextPoint.x - point.x;
            float yDiff = nextPoint.y - point.y;
            for (float step = 0.0f; step <= 1.0f; step += res) {
                float x = point.x + step * xDiff;
                float y = point.y + step * step * (3.0f * yDiff - 2.0f * step * yDiff);
                this.points.add(new Point(x, y));
            }
        }
    }

    public record Point(float x, float y) {
        public static final Point ZERO = new Point(0.0f, 0.0f);
    }
}

