/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MusselBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty MUSSELS = IntegerProperty.m_61631_((String)"mussels", (int)1, (int)5);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)4.0);

    public MusselBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_).m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_56718_).m_60955_().m_60910_().m_60988_().m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)MUSSELS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
        }
        return SHAPE_UP;
    }

    public void m_213898_(BlockState state, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos connectedToPos = blockPos.m_121945_(direction.m_122424_());
        BlockState connectedState = serverLevel.m_8055_(connectedToPos);
        int mussels = (Integer)state.m_61143_((Property)MUSSELS);
        if (randomSource.m_188503_(20) == 0 && connectedState.m_204336_(ACTagRegistry.GROWS_MUSSELS)) {
            if (mussels >= 5) {
                BlockPos randomOffsetPos = connectedToPos.m_7918_(randomSource.m_188503_(6) - 3, randomSource.m_188503_(6) - 3, randomSource.m_188503_(6) - 3);
                BlockState randomOffsetState = serverLevel.m_8055_(randomOffsetPos);
                if (randomOffsetState.m_60713_(Blocks.f_49990_) || randomOffsetState.m_60713_((Block)this) && ((Boolean)randomOffsetState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                    ArrayList<Direction> possiblities = new ArrayList<Direction>();
                    for (Direction possible : Direction.values()) {
                        BlockPos check = randomOffsetPos.m_121945_(possible);
                        if (!serverLevel.m_8055_(check).m_60783_((BlockGetter)serverLevel, check, possible.m_122424_())) continue;
                        possiblities.add(possible.m_122424_());
                    }
                    Direction chosen = null;
                    if (!possiblities.isEmpty()) {
                        chosen = possiblities.size() <= 1 ? (Direction)possiblities.get(0) : (Direction)possiblities.get(randomSource.m_188503_(possiblities.size() - 1));
                    }
                    if (chosen != null) {
                        int taxicab = Mth.m_14045_((int)(6 - (int)Math.ceil(randomOffsetPos.m_203202_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()))), (int)1, (int)5);
                        int currentMussels = randomOffsetState.m_60713_((Block)this) ? (Integer)randomOffsetState.m_61143_((Property)MUSSELS) : 0;
                        int setMussels = Math.max(currentMussels, taxicab);
                        int musselCountOf = randomOffsetState.m_60713_((Block)this) ? Math.min((Integer)randomOffsetState.m_61143_((Property)MUSSELS) + 1, setMussels) : 1;
                        Direction musselDirectionOf = randomOffsetState.m_60713_((Block)this) ? (Direction)randomOffsetState.m_61143_((Property)FACING) : chosen;
                        serverLevel.m_46597_(randomOffsetPos, (BlockState)((BlockState)((BlockState)((Block)ACBlockRegistry.MUSSEL.get()).m_49966_().m_61124_((Property)FACING, (Comparable)musselDirectionOf)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)MUSSELS, (Comparable)Integer.valueOf(musselCountOf)));
                    }
                }
            } else {
                serverLevel.m_46597_(blockPos, (BlockState)state.m_61124_((Property)MUSSELS, (Comparable)Integer.valueOf(mussels + 1)));
            }
        }
    }

    protected void removeOneMussel(Level worldIn, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)MUSSELS);
        if (i <= 1) {
            worldIn.m_46961_(pos, false);
        } else {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSSELS, (Comparable)Integer.valueOf(i - 1)), 2);
            worldIn.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)MUSSELS, (Comparable)Integer.valueOf(Math.min(5, (Integer)blockstate.m_61143_((Property)MUSSELS) + 1)));
        }
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)MUSSELS) < 5 ? true : super.m_6864_(state, context);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{WATERLOGGED, FACING, MUSSELS});
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        this.removeOneMussel(worldIn, pos, state);
    }
}

