/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class BreadLoafBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)4);
    protected static final VoxelShape SHAPE_NS = Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)10.0, (double)15.0);
    protected static final VoxelShape SHAPE_WE = Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)10.0, (double)13.0);
    public final Supplier<Item> breadSlice;

    public BreadLoafBlock(BlockBehaviour.Properties properties, Supplier<Item> breadSlice) {
        super(properties);
        this.breadSlice = breadSlice;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getBreadSliceItem() {
        return new ItemStack((ItemLike)this.breadSlice.get());
    }

    public int getMaxBites() {
        return 5;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_NS : SHAPE_WE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                return InteractionResult.SUCCESS;
            }
            if (this.consumeBite(level, pos, state, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        if (heldStack.m_204117_(ModTags.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player player) {
        int bites;
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getBreadSliceItem();
        ItemStack sliceCopy = sliceStack.m_41777_();
        FoodProperties sliceFood = sliceStack.m_41720_().getFoodProperties(sliceStack, (LivingEntity)player);
        player.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
        ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)sliceCopy, (int)0, (ItemStack)ItemStack.f_41583_);
        if (sliceFood != null) {
            for (Pair pair : sliceFood.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Direction direction = player.m_6350_().m_122424_();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getBreadSliceItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BITES});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.m_61143_((Property)BITES);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

