/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.MapPosInfo;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.almostreliable.morejs.util.LevelUtils;
import com.almostreliable.morejs.util.ResourceOrTag;
import com.almostreliable.morejs.util.WeightedList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class TreasureMapTrade
extends TransformableTrade<TreasureMapTrade> {
    protected final MapPosInfo.Provider destinationPositionFunc;
    @Nullable
    protected Component displayName;
    protected MapDecoration.Type destinationType = MapDecoration.Type.RED_X;
    private boolean renderBiomePreviewMap = true;
    private byte mapViewScale = (byte)2;

    public TreasureMapTrade(TradeItem[] inputs, MapPosInfo.Provider destinationPositionFunc) {
        super(inputs);
        this.destinationPositionFunc = destinationPositionFunc;
    }

    public static TreasureMapTrade forStructure(TradeItem[] input, WeightedList<Object> entries) {
        WeightedList<ResourceOrTag> list = entries.map(o -> {
            if (o == null) {
                return null;
            }
            return ResourceOrTag.get(o.toString(), Registries.f_256944_);
        });
        MapPosInfo.Provider func = (level, entity) -> {
            ResourceOrTag roll = (ResourceOrTag)list.roll(level.f_46441_);
            BlockPos pos = LevelUtils.findStructure(entity.m_20183_(), level, roll, 100);
            if (pos == null) {
                return null;
            }
            return new MapPosInfo(pos, roll.getName());
        };
        return new TreasureMapTrade(input, func);
    }

    public static TreasureMapTrade forBiome(TradeItem[] input, WeightedList<Object> entries) {
        WeightedList<ResourceOrTag> list = entries.map(o -> {
            if (o == null) {
                return null;
            }
            return ResourceOrTag.get(o.toString(), Registries.f_256952_);
        });
        MapPosInfo.Provider func = (level, entity) -> {
            ResourceOrTag roll = (ResourceOrTag)list.roll(level.f_46441_);
            BlockPos pos = LevelUtils.findBiome(entity.m_20183_(), level, roll, 250);
            if (pos == null) {
                return null;
            }
            return new MapPosInfo(pos, roll.getName());
        };
        return new TreasureMapTrade(input, func);
    }

    public TreasureMapTrade displayName(Component name) {
        this.displayName = name;
        return this;
    }

    public TreasureMapTrade marker(MapDecoration.Type type) {
        this.destinationType = type;
        return this;
    }

    public TreasureMapTrade noPreview() {
        this.renderBiomePreviewMap = false;
        return this;
    }

    public TreasureMapTrade scale(byte scale) {
        this.mapViewScale = scale;
        return this;
    }

    @Override
    @Nullable
    public MerchantOffer createOffer(Entity trader, RandomSource random) {
        Level level = trader.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            MapPosInfo info = this.destinationPositionFunc.apply(level2, trader);
            if (info == null) {
                return null;
            }
            ItemStack map = MapItem.m_42886_((Level)level2, (int)info.pos().m_123341_(), (int)info.pos().m_123343_(), (byte)this.mapViewScale, (boolean)true, (boolean)true);
            if (this.renderBiomePreviewMap) {
                MapItem.m_42850_((ServerLevel)level2, (ItemStack)map);
            }
            MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)info.pos(), (String)"+", (MapDecoration.Type)this.destinationType);
            map.m_41714_(this.displayName == null ? info.name() : this.displayName);
            return this.createOffer(map, random);
        }
        return null;
    }
}

