/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.util;

import net.minecraft.client.Minecraft;

public class AnimUtils {
    public static float animPos(int currTick, float partialTicks, boolean countingUp, int animLength, float scaleFactor) {
        return (float)(countingUp ? Math.pow(((float)currTick + partialTicks) / (float)animLength, scaleFactor) : Math.pow(((float)currTick - partialTicks) / (float)animLength, scaleFactor));
    }

    public static int screenAnim(int tickStep, int tickLength, int start, int end) {
        return (int)AnimUtils.lerp(end, start, AnimUtils.easeIn(AnimUtils.percent(tickStep, tickLength)));
    }

    private static float lerp(float start, float end, float percent) {
        return start + (end - start) * percent;
    }

    private static float percent(int tickStep, int tickLength) {
        return ((float)tickStep - AnimUtils.partialTick()) / (float)tickLength;
    }

    private static float easeOut(float percent) {
        return AnimUtils.flip((float)Math.pow(AnimUtils.flip(percent), 2.0));
    }

    private static float easeIn(float percent) {
        return (float)Math.pow(percent, 2.0);
    }

    private static float flip(float percent) {
        return 1.0f - percent;
    }

    private static float partialTick() {
        return Minecraft.m_91087_().getPartialTick();
    }
}

