/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.teams;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.config.CommonConfigData;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class TeamUtil {
    private static final String teamSlug = "sedparties-";

    public static void createTeam(UUID party, UUID player) {
        TeamUtil.getScoreInfo(player, (sb, p) -> {
            if (TeamUtil.teamExists(sb, party)) {
                Parties.LOGGER.error("Party team already exists! Aborting...");
                return;
            }
            PlayerTeam pt = sb.m_83492_(teamSlug + party);
            TeamUtil.addTeamMember(party, player);
            pt.m_83353_((Component)Component.m_237113_((String)("Party #" + PartyAPI.getPartyCount())).m_130940_(ChatFormatting.DARK_AQUA));
            Parties.debug("Created new Team ({}) with Party ID {}", pt.m_83364_().getString(), party);
        });
    }

    public static void removeOldTeams(ServerScoreboard sb) {
        if (sb == null) {
            Parties.LOGGER.error("Couldn't clear teams as the team accessor was not initialized yet.");
            return;
        }
        sb.m_83491_().removeIf(team -> team.m_5758_().startsWith(teamSlug));
    }

    public static void addTeamMember(UUID party, UUID player) {
        TeamUtil.getScoreInfo(player, (sb, p) -> TeamUtil.getTeam(sb, party, t -> {
            sb.m_6546_(p.m_6302_(), t);
            Parties.debug("Added Player to Team ({})", t.m_83364_().getString());
        }));
    }

    public static void removeTeamMember(UUID party, UUID player) {
        TeamUtil.getScoreInfo(player, (sb, p) -> TeamUtil.getTeam(sb, party, t -> {
            sb.m_6519_(p.m_6302_(), t);
            Parties.debug("Removed Player from Team ({})", t.m_83364_().getString());
        }));
    }

    public static void removeTeam(UUID party, UUID player) {
        TeamUtil.getScoreInfo(player, (sb, p) -> TeamUtil.getTeam(sb, party, t -> {
            sb.m_83475_(t);
            Parties.debug("Removed Team ({})", t.m_83364_().getString());
        }));
    }

    private static void getScoreInfo(UUID player, BiConsumer<Scoreboard, ServerPlayer> p) {
        if (((Boolean)CommonConfigData.useVanillaTeams.get()).booleanValue()) {
            ServerPlayer pl = PlayerAPI.getNormalServerPlayer(player);
            if (pl == null) {
                return;
            }
            p.accept(pl.m_36329_(), pl);
        }
    }

    private static boolean teamExists(Scoreboard sb, UUID party) {
        return sb.m_83489_(teamSlug + party) != null;
    }

    private static void getTeam(Scoreboard sb, UUID party, Consumer<PlayerTeam> team) {
        PlayerTeam t = sb.m_83489_(teamSlug + party);
        if (t != null) {
            team.accept(t);
        }
    }
}

