/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.setup;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.ColorAPI;
import io.sedu.mc.parties.api.mod.xaerominimap.XMCompatManager;
import io.sedu.mc.parties.client.config.Config;
import io.sedu.mc.parties.client.config.DimConfig;
import io.sedu.mc.parties.client.overlay.BarBase;
import io.sedu.mc.parties.client.overlay.Frame;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.events.ClientEvent;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod.EventBusSubscriber(modid="sedparties", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static final KeyMapping showMouse = new KeyMapping("key.sedparties.hover", 342, "key.categories.ui");
    public static final KeyMapping showPartyGlow = new KeyMapping("key.sedparties.partyglow", 297, "key.categories.multiplayer");
    private static final IGuiOverlay control = (gui, poseStack, partialTicks, width, height) -> {
        RenderItem.resetPos();
        ColorAPI.tick();
    };

    @SubscribeEvent
    public static void onRegisterOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "ctrl", control);
        RenderItem.register(event);
    }

    @SubscribeEvent
    public static void registerMappings(RegisterKeyMappingsEvent event) {
        event.register(showMouse);
        event.register(showPartyGlow);
    }

    public static void init(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(ClientEvent::onClientLeave);
        MinecraftForge.EVENT_BUS.register(ClientEvent.class);
        Frame.init();
        Frame.forEach(Frame::initItems);
        Config.init();
        Parties.debug("Checking for Xaero's Minimap...", new Object[0]);
        XMCompatManager.init();
    }

    public static void postInit(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            DimConfig.init();
            if (ModList.get().isLoaded("incapacitated") || ModList.get().isLoaded("playerrevive") || ModList.get().isLoaded("hardcorerevival")) {
                BarBase.updateRendererForMods();
            }
            if (ModList.get().isLoaded("homeostatic") || ModList.get().isLoaded("toughasnails")) {
                // empty if block
            }
            Config.reloadClientConfigs();
        });
    }
}

