/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.network;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.network.ClientPacketData;
import io.sedu.mc.parties.network.InfoPacketHelper;
import io.sedu.mc.parties.network.PartiesPacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ServerPacketHelper {
    public static void sendNewMember(UUID futureMember, ArrayList<UUID> party) {
        Parties.debug("SendNewMember internal START", new Object[0]);
        PartiesPacketHandler.sendToPlayer(new ClientPacketData(2, party), PlayerAPI.getNormalServerPlayer(futureMember));
        Parties.debug("SendNewMember internal PACKET", new Object[0]);
        party.forEach(id -> InfoPacketHelper.sendName(futureMember, id));
        Parties.debug("SendNewMember internal NAME", new Object[0]);
        party.forEach(id -> {
            PartiesPacketHandler.sendToPlayer(new ClientPacketData(2, futureMember), PlayerAPI.getNormalServerPlayer(id));
            InfoPacketHelper.sendName(id, futureMember);
            if (PlayerAPI.isOnline(futureMember)) {
                PartiesPacketHandler.sendToPlayer(new ClientPacketData(0, futureMember), PlayerAPI.getNormalServerPlayer(id));
                InfoPacketHelper.forceUpdate(id, futureMember, true);
            }
            if (PlayerAPI.isOnline(id)) {
                PartiesPacketHandler.sendToPlayer(new ClientPacketData(0, (UUID)id), PlayerAPI.getNormalServerPlayer(futureMember));
                InfoPacketHelper.forceUpdate(futureMember, id, true);
            }
        });
        Parties.debug("SendNewMember internal DATA", new Object[0]);
        PartiesPacketHandler.sendToPlayer(new ClientPacketData(3, PartyAPI.getPartyFromMember(party.get(0)).getLeader()), PlayerAPI.getNormalServerPlayer(futureMember));
        Parties.debug("SendNewMember internal POST", new Object[0]);
    }

    public static void sendRemoveMember(UUID removedMember, ArrayList<UUID> party, boolean wasKicked) {
        int i = wasKicked ? 5 : 4;
        party.forEach(id -> PartiesPacketHandler.sendToPlayer(new ClientPacketData(i, removedMember), PlayerAPI.getNormalServerPlayer(id)));
        PartiesPacketHandler.sendToPlayer(new ClientPacketData(i), PlayerAPI.getNormalServerPlayer(removedMember));
    }

    public static void disband(ArrayList<UUID> party) {
        party.forEach(id -> PartiesPacketHandler.sendToPlayer(new ClientPacketData(6), PlayerAPI.getNormalServerPlayer(id)));
    }

    public static void sendNewLeader(UUID newLeader, ArrayList<UUID> party) {
        party.forEach(id -> PartiesPacketHandler.sendToPlayer(new ClientPacketData(3, newLeader), PlayerAPI.getNormalServerPlayer(id)));
    }

    public static void sendOnline(ServerPlayer player) {
        if (PartyAPI.hasParty(player.m_20148_())) {
            ArrayList<UUID> mParty = new ArrayList<UUID>(PartyAPI.getPartyFromMember(player.m_20148_()).getMembers());
            mParty.remove(player.m_20148_());
            PartiesPacketHandler.sendToPlayer(new ClientPacketData(2, mParty), player);
            mParty.forEach(id -> {
                InfoPacketHelper.sendName(player.m_20148_(), id);
                PartiesPacketHandler.sendToPlayer(new ClientPacketData(0, player.m_20148_()), PlayerAPI.getNormalServerPlayer(id));
                InfoPacketHelper.forceUpdate(id, player.m_20148_(), true);
                if (PlayerAPI.isOnline(id)) {
                    PartiesPacketHandler.sendToPlayer(new ClientPacketData(0, (UUID)id), player);
                    InfoPacketHelper.forceUpdate(player.m_20148_(), id, true);
                }
            });
            PartiesPacketHandler.sendToPlayer(new ClientPacketData(3, PartyAPI.getPartyFromMember(player.m_20148_()).getLeader()), player);
            PlayerAPI.getPlayer(player.m_20148_(), playerData -> MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Online(playerData.getPartyId(), player.m_20148_())));
        }
        if (!player.m_21224_()) {
            player.m_21220_().forEach(effect -> InfoPacketHelper.sendEffect(player.m_20148_(), MobEffect.m_19459_((MobEffect)effect.m_19544_()), effect.m_267577_() ? -1024 : effect.m_19557_(), effect.m_19564_()));
        }
    }

    public static void sendOffline(UUID player) {
        if (PartyAPI.hasParty(player)) {
            PartyAPI.getPartyFromMember(player).getMembers().forEach(id -> PartiesPacketHandler.sendToPlayer(new ClientPacketData(1, player), PlayerAPI.getNormalServerPlayer(id)));
        }
    }

    public static void trackerToClient(UUID tracker, UUID playerToTrack) {
        ServerPlayerData.changeTracker(tracker, playerToTrack, false);
    }

    public static void trackerToServer(UUID tracker, UUID playerToTrack) {
        ServerPlayerData.changeTracker(tracker, playerToTrack, true);
    }

    public static void sendNewLeader(UUID initiator) {
        PartiesPacketHandler.sendToPlayer(new ClientPacketData(3), PlayerAPI.getNormalServerPlayer(initiator));
    }

    public static void sendMessageToAll(List<ServerPlayer> playerList, ServerPlayer sender, String data) {
        if (ServerPlayerData.isOnMessageCd(sender.m_20148_())) {
            return;
        }
        playerList.forEach(p -> InfoPacketHelper.sendPreset(p.m_20148_(), sender.m_20148_(), data, sender.m_7755_().getString()));
        ServerPlayerData.messageCd.add(new ServerPlayerData.MessageCdHolder(sender.m_20148_(), CommonConfigData.playerMessageCooldown));
    }
}

