/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.network;

import io.sedu.mc.parties.network.ServerPacketHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerPacketData {
    private UUID data;
    private final int type;

    public ServerPacketData(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        try {
            this.data = new UUID(buf.readLong(), buf.readLong());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public ServerPacketData(int i, UUID playerToTrack) {
        this.data = playerToTrack;
        this.type = i;
    }

    void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeLong(this.data.getMostSignificantBits());
        buf.writeLong(this.data.getLeastSignificantBits());
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            switch (this.type) {
                case 0: {
                    ServerPacketHelper.trackerToClient(ctx.getSender().m_20148_(), this.data);
                    break;
                }
                case 1: {
                    ServerPacketHelper.trackerToServer(ctx.getSender().m_20148_(), this.data);
                }
            }
        });
        return true;
    }
}

