/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.network;

import io.sedu.mc.parties.network.RenderPacketHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class RenderPacketData {
    private UUID player;
    private final int type;
    private Object data;

    RenderPacketData(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        if (this.type == 10 || this.type == 11) {
            return;
        }
        this.player = new UUID(buf.readLong(), buf.readLong());
        this.readData(buf);
    }

    public RenderPacketData(int type, UUID player, Object ... data) {
        this.type = type;
        this.player = player;
        this.data = data.length == 1 ? data[0] : data;
    }

    public RenderPacketData(UUID propOf, ResourceLocation world) {
        this.type = 9;
        this.player = propOf;
        this.data = world.toString();
    }

    public RenderPacketData(int i) {
        this.type = i;
    }

    private void readData(FriendlyByteBuf buf) {
        switch (this.type) {
            case -1: {
                this.data = new Object[]{Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()), buf.readInt(), buf.readInt(), buf.readInt()};
                break;
            }
            case 0: 
            case 9: 
            case 34: {
                StringBuilder builder = new StringBuilder();
                try {
                    while (true) {
                        builder.append(buf.readChar());
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    this.data = builder.toString();
                    break;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 40: {
                this.data = Float.valueOf(buf.readFloat());
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 19: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 41: {
                this.data = buf.readInt();
                break;
            }
            case 12: {
                this.data = new Object[]{buf.readInt(), buf.readInt(), buf.readInt()};
                break;
            }
            case 15: 
            case 17: {
                this.data = new Object[]{buf.readBoolean(), buf.readInt()};
                break;
            }
            case 18: {
                this.data = buf.readBoolean();
                break;
            }
            case 37: {
                this.data = new Object[]{buf.m_130277_(), buf.readInt()};
                break;
            }
            case 39: {
                this.data = new Object[]{buf.m_130277_(), buf.m_130277_()};
            }
        }
    }

    private void writeData(FriendlyByteBuf buf) {
        switch (this.type) {
            case -1: {
                buf.writeFloat(((Float)((Object[])this.data)[0]).floatValue());
                buf.writeFloat(((Float)((Object[])this.data)[1]).floatValue());
                buf.writeFloat(((Float)((Object[])this.data)[2]).floatValue());
                buf.writeInt(((Integer)((Object[])this.data)[3]).intValue());
                buf.writeInt(((Integer)((Object[])this.data)[4]).intValue());
                buf.writeInt(((Integer)((Object[])this.data)[5]).intValue());
                break;
            }
            case 0: 
            case 9: 
            case 34: {
                for (char letter : ((String)this.data).toCharArray()) {
                    buf.writeChar((int)letter);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 40: {
                buf.writeFloat(((Float)this.data).floatValue());
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 19: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 41: {
                buf.writeInt(((Integer)this.data).intValue());
                break;
            }
            case 12: {
                buf.writeInt(((Integer)((Object[])this.data)[0]).intValue());
                buf.writeInt(((Integer)((Object[])this.data)[1]).intValue());
                buf.writeInt(((Integer)((Object[])this.data)[2]).intValue());
                break;
            }
            case 15: 
            case 17: {
                buf.writeBoolean(((Boolean)((Object[])this.data)[0]).booleanValue());
                buf.writeInt(((Integer)((Object[])this.data)[1]).intValue());
                break;
            }
            case 18: {
                buf.writeBoolean(((Boolean)this.data).booleanValue());
                break;
            }
            case 37: {
                buf.m_130070_((String)((Object[])this.data)[0]);
                buf.writeInt(((Integer)((Object[])this.data)[1]).intValue());
                break;
            }
            case 39: {
                buf.m_130070_((String)((Object[])this.data)[0]);
                buf.m_130070_((String)((Object[])this.data)[1]);
            }
        }
    }

    void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        if (this.type == 10 || this.type == 11) {
            return;
        }
        buf.writeLong(this.player.getMostSignificantBits());
        buf.writeLong(this.player.getLeastSignificantBits());
        this.writeData(buf);
    }

    boolean handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            switch (this.type) {
                case -1: {
                    RenderPacketHelper.setHealth(this.player, ((Float)((Object[])this.data)[0]).floatValue());
                    RenderPacketHelper.setMaxHealth(this.player, ((Float)((Object[])this.data)[1]).floatValue());
                    RenderPacketHelper.setAbsorb(this.player, ((Float)((Object[])this.data)[2]).floatValue());
                    RenderPacketHelper.setArmor(this.player, (Integer)((Object[])this.data)[3]);
                    RenderPacketHelper.setFood(this.player, (Integer)((Object[])this.data)[4]);
                    RenderPacketHelper.setXp(this.player, (Integer)((Object[])this.data)[5]);
                    break;
                }
                case 0: {
                    RenderPacketHelper.setName(this.player, (String)this.data);
                    break;
                }
                case 1: {
                    RenderPacketHelper.setHealth(this.player, ((Float)this.data).floatValue());
                    break;
                }
                case 3: {
                    RenderPacketHelper.setAbsorb(this.player, ((Float)this.data).floatValue());
                    break;
                }
                case 4: {
                    RenderPacketHelper.setArmor(this.player, (Integer)this.data);
                    break;
                }
                case 5: {
                    RenderPacketHelper.setFood(this.player, (Integer)this.data);
                    break;
                }
                case 6: {
                    RenderPacketHelper.setXp(this.player, (Integer)this.data);
                    break;
                }
                case 7: {
                    RenderPacketHelper.markDeath(this.player);
                    break;
                }
                case 8: {
                    RenderPacketHelper.markLife(this.player);
                    break;
                }
                case 9: {
                    RenderPacketHelper.setDim(this.player, (String)this.data);
                    break;
                }
                case 10: {
                    RenderPacketHelper.markDeath();
                    break;
                }
                case 11: {
                    RenderPacketHelper.markLife();
                    break;
                }
                case 12: {
                    RenderPacketHelper.setPotionEffect(this.player, (Integer)((Object[])this.data)[0], (Integer)((Object[])this.data)[1], (Integer)((Object[])this.data)[2]);
                    break;
                }
                case 13: {
                    RenderPacketHelper.removePotionEffect(this.player, (Integer)this.data);
                    break;
                }
                case 14: {
                    RenderPacketHelper.setXpBar(this.player, (Float)this.data);
                    break;
                }
                case 15: {
                    RenderPacketHelper.setBleeding(this.player, (Boolean)((Object[])this.data)[0], (Integer)((Object[])this.data)[1]);
                    break;
                }
                case 16: {
                    RenderPacketHelper.setReviveProgress(this.player, (Float)this.data);
                    break;
                }
                case 17: {
                    RenderPacketHelper.setDowned(this.player, (Boolean)((Object[])this.data)[0], (Integer)((Object[])this.data)[1]);
                    break;
                }
                case 18: {
                    RenderPacketHelper.setSpectating(this.player, (Boolean)this.data);
                    break;
                }
                case 19: {
                    RenderPacketHelper.setThirst(this.player, (Integer)this.data);
                    break;
                }
                case 20: {
                    RenderPacketHelper.setWorldTemp(this.player, (Float)this.data);
                    break;
                }
                case 21: {
                    RenderPacketHelper.setBodyTemp(this.player, (Float)this.data);
                    break;
                }
                case 22: {
                    RenderPacketHelper.setWorldTempTAN(this.player, ((Float)this.data).floatValue());
                    break;
                }
                case 23: {
                    RenderPacketHelper.setMana(this.player, ((Float)this.data).floatValue());
                    break;
                }
                case 24: {
                    RenderPacketHelper.setMaxMana(this.player, (Integer)this.data);
                    break;
                }
                case 25: {
                    RenderPacketHelper.setCurrentStamina(this.player, (Float)this.data);
                    break;
                }
                case 26: {
                    RenderPacketHelper.setMaxStamina(this.player, (Integer)this.data);
                    break;
                }
                case 27: {
                    RenderPacketHelper.setManaSS(this.player, (Float)this.data);
                    break;
                }
                case 28: {
                    RenderPacketHelper.setMaxManaSS(this.player, (Float)this.data);
                    break;
                }
                case 29: {
                    RenderPacketHelper.setExtraMana(this.player, (Float)this.data);
                    break;
                }
                case 30: {
                    RenderPacketHelper.setExtraStam(this.player, (Integer)this.data);
                    break;
                }
                case 31: {
                    RenderPacketHelper.setQuench(this.player, (Integer)this.data);
                    break;
                }
                case 32: {
                    RenderPacketHelper.setMaxHunger(this.player, (Float)this.data);
                    break;
                }
                case 33: {
                    RenderPacketHelper.setSaturation(this.player, ((Float)this.data).floatValue());
                    break;
                }
                case 34: {
                    RenderPacketHelper.setOrigin(this.player, (String)this.data);
                    break;
                }
                case 35: {
                    RenderPacketHelper.setManaI(this.player, (Integer)this.data);
                    break;
                }
                case 36: {
                    RenderPacketHelper.setMaxManaI(this.player, (Integer)this.data);
                    break;
                }
                case 37: {
                    RenderPacketHelper.startCast(this.player, (String)((Object[])this.data)[0], (Integer)((Object[])this.data)[1]);
                    break;
                }
                case 38: {
                    RenderPacketHelper.endCast(this.player);
                    break;
                }
                case 39: {
                    RenderPacketHelper.sendMessage(this.player, (String)((Object[])this.data)[0], (String)((Object[])this.data)[1]);
                    break;
                }
                case 40: {
                    RenderPacketHelper.setNutrition(this.player, ((Float)this.data).floatValue());
                    break;
                }
                case 41: {
                    RenderPacketHelper.setArmorToughness(this.player, (Integer)this.data);
                    break;
                }
            }
        });
        return true;
    }
}

