/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.network;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.network.ClientPacketData;
import io.sedu.mc.parties.network.PartiesPacketHandler;
import io.sedu.mc.parties.network.RenderPacketData;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;

public class InfoPacketHelper {
    public static void sendName(UUID sendTo, UUID nameOf) {
        InfoPacketHelper.sendData(sendTo, nameOf, 0, PlayerAPI.getName(nameOf));
    }

    public static void sendData(UUID sendTo, UUID propOf, int type, Object data) {
        if (!sendTo.equals(propOf)) {
            PartiesPacketHandler.sendToPlayer(new RenderPacketData(type, propOf, data), PlayerAPI.getNormalServerPlayer(sendTo));
        }
    }

    public static void sendData(UUID sendTo, int type, Object data) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(type, sendTo, data), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendHealth(UUID sendTo, UUID healthOf, float health) {
        InfoPacketHelper.sendData(sendTo, healthOf, 1, Float.valueOf(health));
    }

    public static void sendMaxHealth(UUID sendTo, UUID absorbOf, float max) {
        InfoPacketHelper.sendData(sendTo, absorbOf, 2, Float.valueOf(max));
    }

    public static void sendAbsorb(UUID sendTo, UUID absorbOf, float absorb) {
        InfoPacketHelper.sendData(sendTo, absorbOf, 3, Float.valueOf(absorb));
    }

    public static void sendArmor(UUID sendTo, UUID armorOf, int armorValue) {
        InfoPacketHelper.sendData(sendTo, armorOf, 4, armorValue);
    }

    public static void sendArmorToughness(UUID sendTo, UUID armorOf, int armorValue) {
        InfoPacketHelper.sendData(sendTo, armorOf, 41, armorValue);
    }

    public static void sendFood(UUID sendTo, UUID hungerOf, int foodLevel) {
        InfoPacketHelper.sendData(sendTo, hungerOf, 5, foodLevel);
    }

    public static void sendXp(UUID sendTo, UUID levelOf, int levels) {
        InfoPacketHelper.sendData(sendTo, levelOf, 6, levels);
    }

    public static void forceUpdate(UUID sendTo, UUID propOf, boolean withDim) {
        if (sendTo.equals(propOf)) {
            return;
        }
        ServerPlayer p = PlayerAPI.getNormalServerPlayer(propOf);
        if (p != null) {
            InfoPacketHelper.sendData(PlayerAPI.getNormalServerPlayer(sendTo), propOf, p.m_21223_(), p.m_21233_(), p.m_6103_(), p.m_21230_(), p.m_36324_().m_38702_(), p.f_36078_);
            if (withDim) {
                InfoPacketHelper.sendDim(sendTo, propOf, p.m_9236_().m_46472_().m_135782_());
            }
            if (p.m_21224_()) {
                InfoPacketHelper.sendDeath(sendTo, propOf);
            } else {
                p.m_21220_().forEach(effect -> InfoPacketHelper.sendEffect(sendTo, propOf, MobEffect.m_19459_((MobEffect)effect.m_19544_()), effect.m_267577_() ? -1024 : effect.m_19557_(), effect.m_19564_()));
            }
        }
    }

    private static void sendData(ServerPlayer serverPlayer, UUID propOf, float health, float maxHealth, float absorptionAmount, int armorValue, int foodLevel, int experienceLevel) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(-1, propOf, Float.valueOf(health), Float.valueOf(maxHealth), Float.valueOf(absorptionAmount), armorValue, foodLevel, experienceLevel), serverPlayer);
    }

    public static void sendDeath(UUID sendTo, UUID propOf) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(7, propOf, new Object[0]), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendAlive(UUID sendTo, UUID propOf) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(8, propOf, new Object[0]), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendDim(UUID sendTo, UUID propOf, ResourceLocation world) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(propOf, world), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendDeath(ServerPlayer p) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(10), p);
    }

    public static void sendLife(ServerPlayer p) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(11), p);
    }

    public static void sendEffectExpired(UUID sendTo, UUID propOf, int potionEffect) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(13, propOf, potionEffect), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendEffect(UUID sendTo, UUID propOf, int type, int duration, int amp) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(12, propOf, type, duration, amp), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendEffectExpired(UUID sendTo, int id) {
        InfoPacketHelper.sendEffectExpired(sendTo, sendTo, id);
    }

    public static void sendEffect(UUID sendTo, int id, int duration, int amplifier) {
        InfoPacketHelper.sendEffect(sendTo, sendTo, id, duration, amplifier);
    }

    public static void sendXpBar(UUID sendTo, UUID propOf, float bar) {
        InfoPacketHelper.sendData(sendTo, propOf, 14, Float.valueOf(bar));
    }

    public static void sendClose(ServerPlayer p) {
        PartiesPacketHandler.sendToPlayer(new ClientPacketData(8), p);
    }

    public static void sendBleeding(ServerPlayer p, boolean b, int dur) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(15, p.m_20148_(), b, dur), p);
    }

    public static void sendBleeding(UUID sendTo, UUID propOf, boolean b, int dur) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(15, propOf, b, dur), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendDowned(ServerPlayer p, boolean b, int dur) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(17, p.m_20148_(), b, dur), p);
    }

    public static void sendDowned(UUID sendTo, UUID propOf, boolean b, int dur) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(17, propOf, b, dur), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendReviveUpdate(UUID sendTo, UUID propOf, float revive) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(16, propOf, Float.valueOf(revive)), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendReviveUpdate(UUID sendTo, float revive) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(16, sendTo, Float.valueOf(revive)), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendSpectating(UUID sendTo, UUID propOf, boolean b) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(18, propOf, b), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendSpectating(UUID sendTo, boolean b) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(18, sendTo, b), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendThirstUpdate(UUID sendTo, UUID propOf, int thirst) {
        InfoPacketHelper.sendData(sendTo, propOf, 19, thirst);
    }

    public static void sendWorldTempUpdate(UUID sendTo, UUID propOf, float worldTemp) {
        InfoPacketHelper.sendData(sendTo, propOf, 20, Float.valueOf(worldTemp));
    }

    public static void sendBodyTempUpdate(UUID sendTo, UUID propOf, float bodyTemp) {
        InfoPacketHelper.sendData(sendTo, propOf, 21, Float.valueOf(bodyTemp));
    }

    public static void sendWorldTempUpdateTAN(UUID sendTo, UUID propOf, float worldTemp) {
        InfoPacketHelper.sendData(sendTo, propOf, 22, Float.valueOf(worldTemp));
    }

    public static void sendManaUpdate(UUID sendTo, UUID propOf, float mana) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(23, propOf, Float.valueOf(mana)), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendMaxManaUpdate(UUID sendTo, UUID propOf, int maxMana) {
        InfoPacketHelper.sendData(sendTo, propOf, 24, maxMana);
    }

    public static void sendStaminaUpdate(UUID sendTo, UUID propOf, float currentStamina) {
        InfoPacketHelper.sendData(sendTo, propOf, 25, Float.valueOf(currentStamina));
    }

    public static void sendMaxStaminaUpdate(UUID sendTo, UUID propOf, int maxStamina) {
        InfoPacketHelper.sendData(sendTo, propOf, 26, maxStamina);
    }

    public static void sendManaUpdateSS(UUID sendTo, UUID propOf, float curMana) {
        Parties.debug("Sending mana update:" + curMana, new Object[0]);
        InfoPacketHelper.sendData(sendTo, propOf, 27, Float.valueOf(curMana));
    }

    public static void sendMaxManaUpdateSS(UUID sendTo, UUID propOf, float mana) {
        InfoPacketHelper.sendData(sendTo, propOf, 28, Float.valueOf(mana));
    }

    public static void sendExtraManaUpdateSS(UUID sendTo, UUID propOf, float mana) {
        InfoPacketHelper.sendData(sendTo, propOf, 29, Float.valueOf(mana));
    }

    public static void sendExtraStamUpdate(UUID sendTo, UUID propOf, int extra) {
        InfoPacketHelper.sendData(sendTo, propOf, 30, extra);
    }

    public static void sendQuenchUpdate(UUID sendTo, UUID propOf, int quench) {
        InfoPacketHelper.sendData(sendTo, propOf, 31, quench);
    }

    public static void sendMaxHungerUpdate(UUID sendTo, UUID propOf, float max) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(32, propOf, Float.valueOf(max)), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendSaturationUpdate(ServerPlayer player, float saturation) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(33, player.m_20148_(), Float.valueOf(saturation)), player);
    }

    public static void sendSaturationUpdate(UUID sendTo, UUID propOf, float sat) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(33, propOf, Float.valueOf(sat)), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendOriginUpdate(UUID sendTo, UUID propOf, String origin) {
        InfoPacketHelper.sendData(sendTo, propOf, 34, origin);
    }

    public static void sendOriginUpdate(UUID sendTo, String origin) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(34, sendTo, origin), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendManaUpdateI(UUID sendTo, UUID propOf, Integer cur) {
        InfoPacketHelper.sendData(sendTo, propOf, 35, cur);
    }

    public static void sendMaxManaUpdateI(UUID sendTo, UUID propOf, Integer max) {
        InfoPacketHelper.sendData(sendTo, propOf, 36, max);
    }

    public static void sendCastUpdate(UUID sendTo, UUID propOf, String spellId, int castDuration) {
        if (!sendTo.equals(propOf)) {
            PartiesPacketHandler.sendToPlayer(new RenderPacketData(37, propOf, spellId, castDuration), PlayerAPI.getNormalServerPlayer(sendTo));
        }
    }

    public static void sendCastUpdate(UUID sendTo, UUID propOf) {
        if (!sendTo.equals(propOf)) {
            PartiesPacketHandler.sendToPlayer(new RenderPacketData(38, propOf, new Object[0]), PlayerAPI.getNormalServerPlayer(sendTo));
        }
    }

    public static void sendPreset(UUID sendTo, UUID propOf, String preset, String name) {
        PartiesPacketHandler.sendToPlayer(new RenderPacketData(39, propOf, preset, name), PlayerAPI.getNormalServerPlayer(sendTo));
    }

    public static void sendNutritionUpdate(UUID sendTo, UUID propOf, float nutrition) {
        InfoPacketHelper.sendData(sendTo, propOf, 40, Float.valueOf(nutrition));
    }
}

