/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.network;

import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.network.PartiesPacketHandler;
import io.sedu.mc.parties.network.ServerPacketData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;

public class ClientPacketHelper {
    private static final boolean debug = false;

    static void msgDebug(MutableComponent msg) {
    }

    static void msgDebug(String msg) {
        ClientPacketHelper.msgDebug(Component.m_237113_((String)msg).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
    }

    public static void msg(MutableComponent msg) {
        Minecraft.m_91087_().f_91074_.m_5661_((Component)msg, true);
    }

    private static void error() {
        Thread.dumpStack();
    }

    public static void markOnline(ArrayList<UUID> list) {
        list.forEach(uuid -> {
            try {
                PlayerAPI.getClientPlayer(uuid, ClientPlayerData::setOnline);
                ClientPacketHelper.msgDebug(Component.m_237113_((String)ClientPlayerData.getName(uuid)).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" is now online.").m_130940_(ChatFormatting.AQUA)));
            }
            catch (NullPointerException e) {
                ClientPacketHelper.error();
                e.printStackTrace();
            }
        });
        assert (Minecraft.m_91087_().f_91074_ != null);
        Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12211_.get(), 0.5f, 1.25f);
        Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12211_.get(), 0.25f, 1.0f);
    }

    public static void markOffline(ArrayList<UUID> list) {
        list.forEach(uuid -> {
            try {
                PlayerAPI.getClientPlayer(uuid, ClientPlayerData::setOffline);
                ClientPacketHelper.msgDebug(Component.m_237113_((String)ClientPlayerData.getName(uuid)).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" is now offline.").m_130940_(ChatFormatting.AQUA)));
            }
            catch (NullPointerException e) {
                ClientPacketHelper.error();
                e.printStackTrace();
            }
        });
        Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12218_.get(), 0.5f, 0.25f);
        Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12170_.get(), 0.25f, 1.0f);
    }

    public static void addMembers(ArrayList<UUID> list) {
        try {
            if (ClientPlayerData.partySize() == 0) {
                ClientPlayerData.addSelfParty();
            }
            list.forEach(ClientPlayerData::addClientMember);
        }
        catch (NullPointerException e) {
            ClientPacketHelper.error();
        }
        ClientPacketHelper.msg(Component.m_237115_((String)"messages.sedparties.phandler.joinparty").m_130940_(ChatFormatting.AQUA));
        Minecraft.m_91087_().f_91073_.m_6907_().forEach(player -> {
            if (ClientPlayerData.playerList.containsKey(player.m_20148_())) {
                ClientPacketHelper.sendTrackerToClient((Player)player);
            }
        });
        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11736_, 0.25f, 1.0f);
    }

    public static void refreshClientOnDimChange() {
        ClientPlayerData.playerList.forEach((id, data) -> ClientPacketHelper.sendTrackerToServer(id));
    }

    public static void changeLeader(ArrayList<UUID> list) {
        ClientPlayerData.changeLeader(list.get(0));
        ClientPacketHelper.msg(Component.m_237110_((String)"messages.sedparties.phandler.changeleader", (Object[])new Object[]{ClientPlayerData.getName(list.get(0))}).m_130940_(ChatFormatting.AQUA));
        Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12218_.get(), 0.5f, 1.0f);
        Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12211_.get(), 0.5f, 1.25f);
    }

    public static void dropParty() {
        ClientPlayerData.reset();
        ClientPacketHelper.msg(Component.m_237115_((String)"messages.sedparties.phandler.dropparty").m_130940_(ChatFormatting.DARK_AQUA));
        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11738_, 0.25f, 1.0f);
    }

    public static void removePartyMemberDropped(UUID uuid) {
        ClientPacketHelper.msg(Component.m_237110_((String)"messages.sedparties.phandler.leftparty", (Object[])new Object[]{ClientPlayerData.getName(uuid)}).m_130940_(ChatFormatting.AQUA));
        ClientPacketHelper.remove(uuid);
    }

    private static void remove(UUID id) {
        ClientPlayerData.playerList.remove(id);
        ClientPlayerData.playerOrderedList.remove(id);
    }

    public static void dropPartyKicked() {
        ClientPlayerData.reset();
        ClientPacketHelper.msg(Component.m_237115_((String)"messages.sedparties.phandler.kickedfromparty").m_130940_(ChatFormatting.AQUA));
        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11738_, 0.25f, 1.0f);
    }

    public static void removePartyMemberKicked(UUID uuid) {
        ClientPacketHelper.msg(Component.m_237110_((String)"messages.sedparties.phandler.kickedfrompartyother", (Object[])new Object[]{ClientPlayerData.getName(uuid)}).m_130940_(ChatFormatting.AQUA));
        ClientPacketHelper.remove(uuid);
    }

    public static void disbandParty() {
        ClientPlayerData.reset();
        ClientPacketHelper.msg(Component.m_237115_((String)"messages.sedparties.phandler.partydisband").m_130940_(ChatFormatting.AQUA));
        Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11738_, 0.25f, 1.0f);
    }

    public static void sendTrackerToClient(Player entity) {
        ClientPlayerData.playerList.get(entity.m_20148_()).setClientPlayer(entity);
        if (entity.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            return;
        }
        ClientPacketHelper.msgDebug("You are now tracking " + ClientPlayerData.getName(entity.m_20148_()) + " on the client.");
        PartiesPacketHandler.sendToServer(new ServerPacketData(0, entity.m_20148_()));
    }

    public static void sendTrackerToServer(UUID id) {
        ClientPlayerData.playerList.get(id).removeClientPlayer();
        if (id.equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            return;
        }
        ClientPacketHelper.msgDebug("You are no longer tracking " + ClientPlayerData.getName(id) + " on the client.");
        PartiesPacketHandler.sendToServer(new ServerPacketData(1, id));
    }

    public static void setLeader() {
        ClientPlayerData.changeLeader(Minecraft.m_91087_().f_91074_.m_20148_());
        ClientPacketHelper.msg(Component.m_237115_((String)"messages.sedparties.phandler.changeleader2").m_130940_(ChatFormatting.AQUA));
    }
}

