/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.network;

import io.sedu.mc.parties.client.config.Config;
import io.sedu.mc.parties.client.config.DimConfig;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.network.ClientPacketHelper;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketData {
    private final ArrayList<UUID> list;
    private final int type;

    ClientPacketData(FriendlyByteBuf buf) {
        this.type = buf.readInt();
        this.list = new ArrayList();
        try {
            while (true) {
                this.list.add(new UUID(buf.readLong(), buf.readLong()));
            }
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    public ClientPacketData(int i, ArrayList<UUID> party) {
        this.type = i;
        this.list = party;
    }

    public ClientPacketData(int i, UUID futureMember) {
        this.list = new ArrayList();
        this.list.add(futureMember);
        this.type = i;
    }

    public ClientPacketData(int i) {
        this.type = i;
        this.list = new ArrayList();
    }

    void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.type);
        for (UUID id : this.list) {
            buf.writeLong(id.getMostSignificantBits());
            buf.writeLong(id.getLeastSignificantBits());
        }
    }

    boolean handle(Supplier<NetworkEvent.Context> ctx) {
        switch (this.type) {
            case 0: {
                ClientPacketHelper.markOnline(this.list);
                break;
            }
            case 1: {
                ClientPacketHelper.markOffline(this.list);
                break;
            }
            case 2: {
                ClientPacketHelper.addMembers(this.list);
                break;
            }
            case 3: {
                if (this.list.size() == 0) {
                    ClientPacketHelper.setLeader();
                    break;
                }
                ClientPacketHelper.changeLeader(this.list);
                break;
            }
            case 4: {
                if (this.list.size() == 0) {
                    ClientPacketHelper.dropParty();
                    break;
                }
                ClientPacketHelper.removePartyMemberDropped(this.list.get(0));
                break;
            }
            case 5: {
                if (this.list.size() == 0) {
                    ClientPacketHelper.dropPartyKicked();
                    break;
                }
                ClientPacketHelper.removePartyMemberKicked(this.list.get(0));
                break;
            }
            case 6: {
                ClientPacketHelper.disbandParty();
                break;
            }
            case 7: {
                DimConfig.reload();
                Config.reloadClientConfigs();
                Config.loadDefaultPreset();
                break;
            }
            case 8: {
                ClientPacketData.closeScreens(false);
                break;
            }
            case 9: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static void closeScreens(boolean closeAll) {
        if (closeAll) {
            if (Minecraft.m_91087_().f_91080_ != null) {
                Minecraft.m_91087_().f_91080_.m_7379_();
            }
            Minecraft.m_91087_().m_91152_(null);
        } else {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof SettingsScreen) {
                SettingsScreen sS = (SettingsScreen)screen;
                sS.m_7379_();
                Minecraft.m_91087_().m_91152_(null);
            }
        }
    }
}

