/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.mixin.vanilla;

import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.mixin.vanilla.EntityMixin;
import io.sedu.mc.parties.network.InfoPacketHelper;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends EntityMixin {
    @Inject(method={"onEffectAdded"}, at={@At(value="RETURN")})
    protected void playerEffectAdded(MobEffectInstance effect, Entity ignore, CallbackInfo ci) {
        if (Objects.isNull(effect)) {
            return;
        }
        InfoPacketHelper.sendEffect(this.m_20148_(), MobEffect.m_19459_((MobEffect)effect.m_19544_()), effect.m_267577_() ? -1024 : effect.m_19557_(), effect.m_19564_());
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(this.m_20148_());
        if (trackers != null) {
            trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendEffect(id, this.m_20148_(), MobEffect.m_19459_((MobEffect)effect.m_19544_()), effect.m_267577_() ? -1024 : effect.m_19557_(), effect.m_19564_()));
        }
    }

    @Inject(method={"onEffectUpdated"}, at={@At(value="RETURN")})
    protected void playerEffectAdded(MobEffectInstance effect, boolean notTick, Entity ignore, CallbackInfo ci) {
        if (Objects.isNull(effect)) {
            return;
        }
        InfoPacketHelper.sendEffect(this.m_20148_(), MobEffect.m_19459_((MobEffect)effect.m_19544_()), effect.m_267577_() ? -1024 : effect.m_19557_(), effect.m_19564_());
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(this.m_20148_());
        if (trackers != null) {
            trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendEffect(id, this.m_20148_(), MobEffect.m_19459_((MobEffect)effect.m_19544_()), effect.m_267577_() ? -1024 : effect.m_19557_(), effect.m_19564_()));
        }
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="RETURN")})
    protected void playerEffectAdded(MobEffectInstance effect, CallbackInfo ci) {
        if (Objects.isNull(effect)) {
            return;
        }
        InfoPacketHelper.sendEffectExpired(this.m_20148_(), MobEffect.m_19459_((MobEffect)effect.m_19544_()));
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(this.m_20148_());
        if (trackers != null) {
            trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendEffectExpired(id, this.m_20148_(), MobEffect.m_19459_((MobEffect)effect.m_19544_())));
        }
    }
}

