/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.mixin.vanilla;

import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.api.mod.epicfight.EFCompatManager;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.gui.GUIRenderer;
import io.sedu.mc.parties.data.PartyData;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.ClientConfigData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.events.PlayerEvents;
import io.sedu.mc.parties.mixin.vanilla.EntityMixin;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends EntityMixin
implements GUIRenderer {
    @Shadow
    @Final
    private static Map<Pose, EntityDimensions> f_36074_;
    private boolean renderUI = false;

    @ModifyVariable(at=@At(value="HEAD"), method={"giveExperiencePoints(I)V"}, argsOnly=true)
    private int modifiedExperiencePoints(int pXpPoints) {
        List<Player> members;
        if (pXpPoints < 0 || PlayerEvents.ignoreXpShare || !((Boolean)CommonConfigData.enableShare.get()).booleanValue()) {
            return pXpPoints;
        }
        ServerPlayerData pd = PlayerAPI.getNormalPlayer(((Player)this).m_20148_());
        if (pd == null) {
            return pXpPoints;
        }
        List<Player> list = members = (Boolean)CommonConfigData.globalShare.get() != false ? pd.getOnlineMembers() : pd.getNearbyMembers();
        if (members.size() > 0) {
            PartyData party = PartyAPI.getPartyFromMember(((Player)this).m_20148_());
            assert (party != null);
            int sharedXp = (pXpPoints += party.getXpOverflow()) / (members.size() + 1);
            party.setXpOverflow(pXpPoints - sharedXp * (members.size() + 1));
            int selfXp = sharedXp;
            for (Player member : members) {
                if (this.givePartyExperiencePoints(member, sharedXp)) continue;
                selfXp += sharedXp;
            }
            return selfXp;
        }
        return pXpPoints;
    }

    @Override
    protected void shouldPlayerGlow(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            cir.setReturnValue((Object)(ClientConfigData.glowParty && ClientPlayerData.playerList.containsKey(this.m_20148_()) ? 1 : 0));
        }
    }

    @Override
    public void setRenderMode(boolean uiRendering) {
        this.renderUI = uiRendering;
        EFCompatManager.getHandler().setRenderEngine(uiRendering);
    }

    @Override
    public boolean isRenderingUI() {
        return this.renderUI;
    }

    private boolean givePartyExperiencePoints(Player partyPlayer, int pXpPoints) {
        PlayerXpEvent.XpChange event = new PlayerXpEvent.XpChange((Player)this, pXpPoints);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        pXpPoints = event.getAmount();
        partyPlayer.m_36401_(pXpPoints);
        partyPlayer.f_36080_ += (float)pXpPoints / (float)partyPlayer.m_36323_();
        partyPlayer.f_36079_ = Mth.m_14045_((int)(partyPlayer.f_36079_ + pXpPoints), (int)0, (int)Integer.MAX_VALUE);
        while (partyPlayer.f_36080_ < 0.0f) {
            float f = partyPlayer.f_36080_ * (float)partyPlayer.m_36323_();
            if (partyPlayer.f_36078_ > 0) {
                partyPlayer.m_6749_(-1);
                partyPlayer.f_36080_ = 1.0f + f / (float)partyPlayer.m_36323_();
                continue;
            }
            partyPlayer.m_6749_(-1);
            partyPlayer.f_36080_ = 0.0f;
        }
        while (partyPlayer.f_36080_ >= 1.0f) {
            partyPlayer.f_36080_ = (partyPlayer.f_36080_ - 1.0f) * (float)partyPlayer.m_36323_();
            partyPlayer.m_6749_(1);
            partyPlayer.f_36080_ /= (float)partyPlayer.m_36323_();
        }
        return true;
    }
}

