/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.lib.ct;

import com.mojang.blaze3d.platform.NativeImage;
import io.sedu.mc.parties.lib.ct.MMCQ;
import java.util.Arrays;

public class ColorThief {
    private static final int DEFAULT_QUALITY = 10;
    private static final boolean DEFAULT_IGNORE_WHITE = true;

    public static int[] getColor(NativeImage sourceImage) {
        int[][] palette = ColorThief.getPalette(sourceImage, 5);
        if (palette == null) {
            return null;
        }
        int[] dominantColor = palette[0];
        return dominantColor;
    }

    public static int[][] getPalette(NativeImage sourceImage, int colorCount) {
        MMCQ.CMap cmap = ColorThief.getColorMap(sourceImage, colorCount);
        if (cmap == null) {
            return null;
        }
        return cmap.palette();
    }

    public static MMCQ.CMap getColorMap(NativeImage sourceImage, int colorCount) {
        return ColorThief.getColorMap(sourceImage, colorCount, 10, true);
    }

    public static MMCQ.CMap getColorMap(NativeImage sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        if (sourceImage.m_85102_() == NativeImage.Format.RGBA) {
            int[][] pixelArray = ColorThief.getPixelsMod(sourceImage, quality, ignoreWhite);
            return MMCQ.quantize(pixelArray, colorCount);
        }
        return null;
    }

    private static int[][] getPixelsMod(NativeImage sourceImage, int quality, boolean ignoreWhite) {
        int width = sourceImage.m_84982_();
        int height = sourceImage.m_85084_();
        int pixelCount = width * height;
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] pixelArray = new int[numRegardedPixels][];
        int i = 0;
        while (i < pixelCount) {
            int x = i % width;
            int y = i / width;
            int rgba = sourceImage.m_84985_(x, y);
            int a = rgba >> 24 & 0xFF;
            int b = rgba >> 16 & 0xFF;
            int g = rgba >> 8 & 0xFF;
            int r = rgba & 0xFF;
            if (!(a < 125 || ignoreWhite && r > 250 && g > 250 && b > 250)) {
                pixelArray[numUsedPixels] = new int[]{r, g, b};
                ++numUsedPixels;
                i += quality;
                continue;
            }
            ++i;
        }
        return (int[][])Arrays.copyOfRange(pixelArray, 0, numUsedPixels);
    }
}

