/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.events;

import com.mojang.brigadier.CommandDispatcher;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.commands.PartyCommands;
import io.sedu.mc.parties.data.DataType;
import io.sedu.mc.parties.data.PartySaveData;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.network.ClientPacketHelper;
import io.sedu.mc.parties.network.InfoPacketHelper;
import io.sedu.mc.parties.network.ServerPacketHelper;
import io.sedu.mc.parties.teams.TeamUtil;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sedparties")
public class PlayerEvents {
    public static boolean ignoreXpShare = false;
    private static int tickCounter = 8;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            UUID id = event.getEntity().m_20148_();
            ServerPlayerData pD = PlayerAPI.getNormalPlayer(id);
            if (pD == null) {
                pD = new ServerPlayerData(id);
            }
            pD.setServerPlayer((ServerPlayer)event.getEntity());
            ServerPacketHelper.sendOnline((ServerPlayer)event.getEntity());
            Player p = event.getEntity();
            boolean spectating = p.m_5833_();
            InfoPacketHelper.sendSpectating(p.m_20148_(), spectating);
            HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p.m_20148_());
            if (trackers != null) {
                trackers.forEach((trackId, serverTracked) -> InfoPacketHelper.sendSpectating(trackId, p.m_20148_(), spectating));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            PlayerAPI.getPlayer(event.getEntity().m_20148_(), playerData -> playerData.removeServerPlayer().removeInviters());
            ServerPacketHelper.sendOffline(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            PlayerAPI.getPlayer(event.getEntity().m_20148_(), playerData -> playerData.setServerPlayer((ServerPlayer)event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_ && event.getEntity() instanceof Player && ClientPlayerData.playerList.containsKey(event.getEntity().m_20148_()) && (ClientPlayerData.playerList.get(event.getEntity().m_20148_()).isTrackedOnServer() || ((Player)event.getEntity()).m_7578_())) {
            Minecraft.m_91087_().execute(() -> ClientPacketHelper.sendTrackerToClient((Player)event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent e) {
        if (e.side == LogicalSide.SERVER && e.phase == TickEvent.Phase.END) {
            if (e.player.f_19797_ % (Integer)CommonConfigData.playerUpdateInterval.get() == 3) {
                HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(e.player.m_20148_());
                UUID player = e.player.m_20148_();
                ServerPlayerData pD = ServerPlayerData.playerList.get(player);
                FoodData d = e.player.m_36324_();
                pD.setData(Float.valueOf(d.m_38722_()), DataType.SATURATION, saturation -> {
                    InfoPacketHelper.sendSaturationUpdate((ServerPlayer)e.player, saturation.floatValue());
                    if (trackers != null) {
                        trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendSaturationUpdate(id, player, saturation.floatValue()));
                    }
                });
                if (trackers != null) {
                    pD.setData(d.m_38702_(), DataType.HUNGER, hunger -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendFood(id, player, hunger)));
                    pD.setData(Float.valueOf(e.player.f_36080_), DataType.XPPROG, xp -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendXpBar(id, player, xp.floatValue())));
                    pD.setData(e.player.m_21230_(), DataType.ARMOR, armor -> trackers.forEach((id, serverTracked) -> {
                        if (serverTracked.booleanValue()) {
                            InfoPacketHelper.sendArmor(id, player, armor);
                        }
                    }));
                    pD.setData(PlayerAPI.getToughnessValue(e.player), DataType.ARMORT, a -> trackers.forEach((id, serverTracked) -> {
                        if (serverTracked.booleanValue()) {
                            InfoPacketHelper.sendArmorToughness(id, player, a);
                        }
                    }));
                }
            }
            if (e.player.f_19797_ % 20 == 7) {
                ServerPlayerData.playerList.get(e.player.m_20148_()).tickInviters();
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END && tickCounter++ >= 20) {
            tickCounter = 1;
            ServerPlayerData.messageCd.removeIf(ServerPlayerData.MessageCdHolder::tick);
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveLevelEvent event) {
        if (event.getLevel().f_46443_ && event.getEntity() instanceof Player && ClientPlayerData.playerList.containsKey(event.getEntity().m_20148_()) && !ClientPlayerData.playerList.get(event.getEntity().m_20148_()).isTrackedOnServer()) {
            ClientPacketHelper.sendTrackerToServer(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPartyCreate(PartyEvent.Create event) {
        TeamUtil.createTeam(event.getPartyId(), event.getPlayerId());
    }

    @SubscribeEvent
    public static void onPartyDisband(PartyEvent.Disband event) {
        TeamUtil.removeTeam(event.getPartyId(), event.getPlayerId());
    }

    @SubscribeEvent
    public static void onPartyAddMember(PartyEvent.Join event) {
        TeamUtil.addTeamMember(event.getPartyId(), event.getPlayerId());
    }

    @SubscribeEvent
    public static void onPartyRemoveMember(PartyEvent.Leave event) {
        TeamUtil.removeTeamMember(event.getPartyId(), event.getPlayerId());
    }

    @SubscribeEvent
    public static void onPartyMemberOnline(PartyEvent.Online event) {
        event.forTrackersAndSelf((sendTo, propOf) -> PlayerAPI.getPlayer(propOf, p -> InfoPacketHelper.sendSaturationUpdate(sendTo, propOf, p.getSaturation())));
    }

    @SubscribeEvent
    public static void onWorldChange(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            ClientPacketHelper.refreshClientOnDimChange();
        }
    }

    @SubscribeEvent
    public static void onWorldChange(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            ClientPlayerData.updateSelfDim(String.valueOf(((ClientLevel)event.getLevel()).m_46472_().m_135782_()));
        }
    }

    @SubscribeEvent
    public static void onDimChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer p = (ServerPlayer)event.getEntity();
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p.m_20148_());
        if (trackers != null) {
            trackers.keySet().forEach(id -> InfoPacketHelper.sendDim(id, p.m_20148_(), event.getTo().m_135782_()));
        }
        p.m_9174_(p.f_36078_);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAttacked(LivingAttackEvent event) {
        Entity entity;
        LivingEntity member1 = event.getEntity();
        if (!member1.m_9236_().m_5776_() && event.getSource() != null && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity member2 = (LivingEntity)entity;
            if (!((Boolean)CommonConfigData.friendlyFire.get()).booleanValue() && PartyAPI.inSameParty(member1, member2)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().m_5776_() && (livingEntity = event.getEntity()) instanceof Player) {
            Player p = (Player)livingEntity;
            InfoPacketHelper.sendClose((ServerPlayer)p);
            HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p.m_20148_());
            if (trackers != null) {
                trackers.forEach((id, serverTracked) -> {
                    if (serverTracked.booleanValue()) {
                        if (event.getAmount() != 0.0f) {
                            InfoPacketHelper.sendHealth(id, p.m_20148_(), Math.max(p.m_21223_() - event.getAmount(), 0.0f));
                        }
                        InfoPacketHelper.sendAbsorb(id, p.m_20148_(), p.m_6103_());
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHealed(LivingHealEvent event) {
        HashMap<UUID, Boolean> trackers;
        Player p;
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().m_5776_() && (livingEntity = event.getEntity()) instanceof Player && !(p = (Player)livingEntity).m_21224_() && (trackers = ServerPlayerData.playerTrackers.get(p.m_20148_())) != null) {
            trackers.forEach((id, serverTracked) -> {
                if (serverTracked.booleanValue() && event.getAmount() != 0.0f) {
                    InfoPacketHelper.sendHealth(id, p.m_20148_(), Math.min(p.m_21223_() + event.getAmount(), p.m_21233_()));
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (event.isCanceled()) {
            return;
        }
        if (!event.getEntity().m_9236_().m_5776_() && (livingEntity = event.getEntity()) instanceof Player) {
            Player p = (Player)livingEntity;
            InfoPacketHelper.sendDeath((ServerPlayer)p);
            HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p.m_20148_());
            if (trackers != null) {
                trackers.keySet().forEach(id -> InfoPacketHelper.sendDeath(id, p.m_20148_()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            InfoPacketHelper.sendLife((ServerPlayer)event.getEntity());
            UUID p = event.getEntity().m_20148_();
            HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p);
            if (trackers != null) {
                trackers.forEach((id, serverTrack) -> {
                    InfoPacketHelper.sendAlive(id, p);
                    if (serverTrack.booleanValue()) {
                        InfoPacketHelper.forceUpdate(id, p, false);
                    }
                    InfoPacketHelper.sendDim(id, p, event.getEntity().m_9236_().m_46472_().m_135782_());
                });
            }
        }
    }

    @SubscribeEvent
    public static void onFoodConsumption(LivingEntityUseItemEvent.Finish event) {
        Player p;
        HashMap<UUID, Boolean> trackers;
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().m_5776_() && event.getItem().m_41614_() && (livingEntity = event.getEntity()) instanceof Player && (trackers = ServerPlayerData.playerTrackers.get((p = (Player)livingEntity).m_20148_())) != null) {
            trackers.keySet().forEach(id -> InfoPacketHelper.sendFood(id, p.m_20148_(), p.m_36324_().m_38702_()));
        }
    }

    @SubscribeEvent
    public static void onLevelChange(PlayerXpEvent.LevelChange event) {
        Player p;
        HashMap<UUID, Boolean> trackers;
        if (!event.getEntity().m_9236_().m_5776_() && (trackers = ServerPlayerData.playerTrackers.get((p = event.getEntity()).m_20148_())) != null) {
            trackers.keySet().forEach(id -> InfoPacketHelper.sendXp(id, p.m_20148_(), p.f_36078_ + event.getLevels()));
        }
    }

    @SubscribeEvent
    public static void onGamemodeChange(PlayerEvent.PlayerChangeGameModeEvent event) {
        Player p = event.getEntity();
        if (event.getCurrentGameMode() == event.getNewGameMode()) {
            return;
        }
        boolean spectating = event.getNewGameMode() == GameType.SPECTATOR;
        InfoPacketHelper.sendSpectating(p.m_20148_(), spectating);
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p.m_20148_());
        if (trackers != null) {
            trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendSpectating(id, p.m_20148_(), spectating));
        }
    }

    @SubscribeEvent
    public static void RegisterCommands(RegisterCommandsEvent event) {
        PartyCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        PartySaveData.server = event.getServer();
        TeamUtil.removeOldTeams(event.getServer().m_129896_());
        ServerLevel l = event.getServer().m_129880_(Level.f_46428_);
        if (l != null) {
            PartySaveData.globalLevel = l;
            Parties.debug("Level saved successfully...", new Object[0]);
            if (CommonConfigData.isPartySyncEnabled()) {
                return;
            }
            PartySaveData.get();
        }
    }
}

