/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.events;

import com.mojang.brigadier.CommandDispatcher;
import io.sedu.mc.parties.api.helper.ColorAPI;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;
import io.sedu.mc.parties.client.overlay.gui.GUIRenderer;
import io.sedu.mc.parties.client.overlay.gui.PartyScreen;
import io.sedu.mc.parties.client.overlay.gui.SliderButton;
import io.sedu.mc.parties.commands.ClientCommands;
import io.sedu.mc.parties.data.config.ClientConfigData;
import io.sedu.mc.parties.network.ClientPacketHelper;
import io.sedu.mc.parties.setup.ClientSetup;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvent {
    public static int tick = 0;

    @SubscribeEvent
    public static void onClientLeave(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientPlayerData.completeReset();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientPlayerData.addSelf();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterClientCommandsEvent event) {
        ClientCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.Color event) {
        if (PartyScreen.status == 1) {
            event.setBorderStart(ColorAPI.getRainbowColor() | 0x40000000);
            event.setBorderEnd(ColorAPI.getRainbowColor() | 0xFF000000);
            event.setBackgroundStart(-16777216);
            event.setBackgroundEnd(-15661824);
        }
    }

    @SubscribeEvent
    public static void ticker(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AnimBarHandler.tick();
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            ClientPlayerData.playerList.values().forEach(ClientPlayerData::tick);
            if (tick++ % 20 == 8) {
                ClientPlayerData.playerList.values().forEach(ClientPlayerData::slowTick);
                ClientPlayerData.getSelf(ClientPlayerData::checkHunger);
            }
        }
        while (ClientSetup.showPartyGlow.m_90859_()) {
            if (Minecraft.m_91087_().f_91074_ == null) continue;
            if (ClientConfigData.glowParty) {
                ClientPacketHelper.msg(Component.m_237115_((String)"messages.sedparties.phandler.glowoff").m_130940_(ChatFormatting.YELLOW));
                ClientConfigData.glowParty = false;
                Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11871_, 0.15f, 0.5f);
                continue;
            }
            ClientPacketHelper.msg(Component.m_237115_((String)"messages.sedparties.phandler.glowon").m_130940_(ChatFormatting.YELLOW));
            ClientConfigData.glowParty = true;
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11871_, 0.15f, 0.75f);
        }
    }

    @SubscribeEvent
    public static void keyPress(InputEvent.Key event) {
        if (ClientSetup.showMouse.getKey().m_84873_() == event.getKey() && Minecraft.m_91087_().f_91080_ == null) {
            Minecraft.m_91087_().m_91152_(PartyScreen.get(ClientSetup.showMouse.getKey().m_84873_()));
        }
    }

    @SubscribeEvent
    public static void mouseReleased(ScreenEvent.MouseButtonReleased event) {
        SliderButton.clickReleased = true;
    }

    @SubscribeEvent
    public static void nameTagRender(RenderNameTagEvent event) {
        Player p;
        Entity entity = event.getEntity();
        if (entity instanceof Player && ((GUIRenderer)(p = (Player)entity)).isRenderingUI()) {
            event.setResult(Event.Result.DENY);
        }
    }
}

