/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.events;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.data.PartyData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.mixin.LivingEntityAccessor;
import io.sedu.mc.parties.mixin.MobAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="sedparties")
public class BossEvents {
    private static final UUID HEALTH_MOD = UUID.fromString("cb8fae8d-2aa9-4fc0-8028-9de2638b877f");
    private static final UUID DAMAGE_MOD = UUID.fromString("2a480477-f7f5-4689-9bb4-f724f2988fb0");
    private static final HashSet<String> bosses = new HashSet();

    @SubscribeEvent
    public static void onBossSpawn(EntityJoinLevelEvent event) {
        LivingEntity b;
        Entity entity;
        if (!event.getLevel().f_46443_ && (entity = event.getEntity()) instanceof LivingEntity && BossEvents.isBoss(b = (LivingEntity)entity) && ((Boolean)CommonConfigData.bossModuleEnabled.get()).booleanValue()) {
            Parties.debug("Tracked boss has spawned.", new Object[0]);
            BossEvents.modifyBoss(b);
        }
    }

    public static void modifyBoss(LivingEntity b) {
        AttributeInstance damage;
        double damageMod;
        AttributeInstance maxHealth;
        double healthMod = (Double)CommonConfigData.healthMod.get() * (double)BossEvents.getPlayers(b.m_9236_(), b);
        if (healthMod != 0.0 && (maxHealth = b.m_21051_(Attributes.f_22276_)) != null) {
            AttributeModifier mod = new AttributeModifier(HEALTH_MOD, "partyModHealth", healthMod, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (maxHealth.m_22111_(HEALTH_MOD) == null) {
                maxHealth.m_22125_(mod);
                b.m_21153_(b.m_21233_());
                Parties.debug("Health for boss {} has been increased by x{}", b.m_6302_(), healthMod);
            }
        }
        if ((damageMod = (Double)CommonConfigData.damageMod.get() * (double)BossEvents.getPlayers(b.m_9236_(), b)) != 0.0 && (damage = b.m_21051_(Attributes.f_22281_)) != null) {
            AttributeModifier mod = new AttributeModifier(DAMAGE_MOD, "partyModDamage", damageMod, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (damage.m_22111_(DAMAGE_MOD) == null) {
                damage.m_22125_(mod);
                Parties.debug("Damage for boss {} has been increased by x{}", b.m_6302_(), damageMod);
            }
        }
    }

    @SubscribeEvent
    public static void addBossTags(FMLLoadCompleteEvent event) {
        bosses.clear();
        bosses.addAll((Collection)CommonConfigData.markBosses.get());
        Parties.debug("Tracking Bosses: {}", bosses.toString());
    }

    private static boolean isBoss(LivingEntity b) {
        ResourceLocation l = ForgeRegistries.ENTITY_TYPES.getKey((Object)b.m_6095_());
        if (l == null) {
            return false;
        }
        return bosses.contains(l.toString());
    }

    @SubscribeEvent
    public static void onBossDrop(LivingDropsEvent event) {
        if (BossEvents.isBoss(event.getEntity()) && ((Boolean)CommonConfigData.bossModuleEnabled.get()).booleanValue() && ((Boolean)CommonConfigData.scaleLoot.get()).booleanValue()) {
            LivingEntity b = event.getEntity();
            int count = BossEvents.getPlayers(b.m_9236_(), b);
            if (((LivingEntityAccessor)b).invokeShouldDropLoot() && b.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
                for (int i = 0; i < count; ++i) {
                    ((MobAccessor)b).invokeDropFromLootTable(event.getSource(), event.isRecentlyHit());
                    ((MobAccessor)b).invokeDropCustomDeathLoot(event.getSource(), event.getLootingLevel(), event.isRecentlyHit());
                }
            }
        }
    }

    public static int getPlayers(Level l, LivingEntity boss) {
        return switch (CommonConfigData.getCountType()) {
            default -> throw new IncompatibleClassChangeError();
            case CommonConfigData.CountType.SERVER -> {
                if (l.m_7654_() == null) {
                    yield 0;
                }
                yield l.m_7654_().m_7416_() - 1;
            }
            case CommonConfigData.CountType.DIMENSION -> l.m_6907_().size() - 1;
            case CommonConfigData.CountType.RADIUS -> 0;
            case CommonConfigData.CountType.PARTY -> {
                Player p = l.m_45930_((Entity)boss, 32.0);
                if (p == null) {
                    yield 0;
                }
                PartyData pD = PartyAPI.getPartyFromMember(p.m_20148_());
                if (pD != null) {
                    yield pD.getMembers().size() - 1;
                }
                yield 0;
            }
        };
    }
}

