/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.data.config;

import io.sedu.mc.parties.api.mod.gamestages.SyncType;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sedparties", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfigData {
    public static ForgeConfigSpec.IntValue playerAcceptTimer;
    public static Integer playerMessageCooldown;
    public static ForgeConfigSpec.IntValue partySize;
    public static ForgeConfigSpec.BooleanValue useFTBTeams;
    public static ForgeConfigSpec.BooleanValue useVanillaTeams;
    public static ForgeConfigSpec.IntValue playerUpdateInterval;
    public static ForgeConfigSpec.IntValue playerSlowUpdateInterval;
    public static ForgeConfigSpec.BooleanValue friendlyFire;
    public static ForgeConfigSpec.BooleanValue globalShare;
    public static ForgeConfigSpec.BooleanValue enableShare;
    public static ForgeConfigSpec.BooleanValue allowGlobalUpdates;
    public static ForgeConfigSpec.ConfigValue<SyncType> syncGameStages;
    public static ForgeConfigSpec.BooleanValue useSyncLists;
    public static ForgeConfigSpec.BooleanValue ignoreCommand;
    public static ForgeConfigSpec.BooleanValue bossModuleEnabled;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> markBosses;
    public static ForgeConfigSpec.ConfigValue<CountType> playerCountType;
    public static ForgeConfigSpec.IntValue playerCountRadius;
    public static ForgeConfigSpec.DoubleValue healthMod;
    public static ForgeConfigSpec.DoubleValue damageMod;
    public static ForgeConfigSpec.BooleanValue scaleLoot;
    public static ForgeConfigSpec.BooleanValue scaleSpecialLoot;

    public static void registerCommonConfig(ForgeConfigSpec.Builder SERVER_BUILDER) {
        SERVER_BUILDER.comment("Common Party Settings");
        SERVER_BUILDER.push("timers");
        playerAcceptTimer = SERVER_BUILDER.comment("Delay (in seconds) for player to accept invite before it automatically expires.").defineInRange("playerAcceptTimer", 30, 5, 60);
        playerUpdateInterval = SERVER_BUILDER.comment("Delay (in ticks) for player packet syncing (hunger, xp)").defineInRange("playerUpdateInterval", 10, 10, 200);
        playerSlowUpdateInterval = SERVER_BUILDER.comment("Delay (in ticks) for player packet syncing for less frequent items (World Temp, etc)").defineInRange("playerSlowUpdateInterval", 40, 40, 800);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("mechanics");
        partySize = SERVER_BUILDER.comment("Max size for a party").defineInRange("partySize", 5, 2, Integer.MAX_VALUE);
        useVanillaTeams = SERVER_BUILDER.comment("Makes the party system utilize the vanilla team system as well.").define("useVanillaTeams", true);
        friendlyFire = SERVER_BUILDER.comment("Allow players to attack each other in parties").define("friendlyFire", false);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("xp-share");
        enableShare = SERVER_BUILDER.comment("Allow players to share XP in a party. This is a universal option.").define("enableShare", true);
        globalShare = SERVER_BUILDER.comment("Enables XP Sharing between party members regardless of distance from each other.").define("globalShare", true);
        ignoreCommand = SERVER_BUILDER.comment(new String[]{"Disables XP Sharing from vanilla commands that give experience *points*.", "(/xp add [name] [amount] points)"}).define("ignoreCommand", true);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("mod-support");
        allowGlobalUpdates = SERVER_BUILDER.comment(new String[]{"This allows for extra modded information (like cast bars) to update regardless of distance.", "true - Enables this feature.  Members have all information shared regardless of distance.", "false - Disables this feature. Members have to be within tracking range for updates.", "APPLIES TO: Cast Bar Element"}).define("allowGlobalUpdates", true);
        syncGameStages = SERVER_BUILDER.comment(new String[]{"Allow you to enable specific type of game stage syncing between party members.", "ALL - Players can opt-in to allow all game stage syncing, including previous entries.", "FUTURE - Players can only opt-in to allow future game stages to be synced", "NONE - Game stage syncing is disabled completely."}).defineEnum("syncGameStages", (Enum)SyncType.NONE);
        useSyncLists = SERVER_BUILDER.comment(new String[]{"Specifies if Game Stages (and other mods with similar systems) should utilize server lists for syncing.", "These white/blacklists determine what stages are allowed to be synced by the client, regardless of sync settings.", "If the list is a whitelist, only stages in the list will be syncable.", "For a blacklist, all stages that aren't in the list will be syncable."}).define("useSyncLists", false);
        useFTBTeams = SERVER_BUILDER.comment("Uses FTB Teams to handle party management instead. Commands will be disabled.").define("useFTBTeams", false);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("boss-module");
        bossModuleEnabled = SERVER_BUILDER.comment(new String[]{"The boss module allows you to alter boss attributes and loot depending on the number of players from various types of sources.", "true - Enables the boss module.", "false - Disables the boss module."}).define("bossModuleEnabled", false);
        markBosses = SERVER_BUILDER.comment("A list of entity IDs that the Parties mod treats as bosses. These entities will utilize the scaling of the Boss Module. Changes to this list require a restart.").defineList("markBosses", Arrays.asList("minecraft:wither", "minecraft:ender_dragon", "minecraft:warden"), entry -> true);
        playerCountType = SERVER_BUILDER.comment(new String[]{"Changes the way the player count is calculated to adjust the attributes and loot drops of bosses.", "SERVER - Counts all online players.", "DIMENSION - Counts all players in the same dimension.", "RADIUS - Counts all players in a defined radius from the spawned boss. (Not functional yet)", "PARTY - Counts all players in the nearest player's party."}).defineEnum("playerCountType", (Enum)CountType.DIMENSION);
        playerCountRadius = SERVER_BUILDER.comment("If playerCountType is RADIUS, this defines the radius size from the boss to look for players, in meters.").defineInRange("playerCountRadius", 256, 1, Integer.MAX_VALUE);
        healthMod = SERVER_BUILDER.comment(new String[]{"The health mod per player count defined above, as a total multiplier. (0.5 = 150%)", "A value of 0 disables health modifiers."}).defineInRange("healthMod", 0.25, 0.0, 2.147483647E9);
        damageMod = SERVER_BUILDER.comment(new String[]{"The damage mod per player count defined above, as a total multiplier. (0.5 = 150%)", "A value of 0 disables damage modifiers."}).defineInRange("damageMod", 0.25, 0.0, 2.147483647E9);
        scaleLoot = SERVER_BUILDER.comment(new String[]{"If true, scales the loot to the amount of players from the player count above.", "Setting this value to false disables this feature."}).define("scaleLoot", true);
        scaleSpecialLoot = SERVER_BUILDER.comment(new String[]{"If true, scales special loot just like above.", "Currently determines whether you'd get more Affixed items from Apotheosis mini-bosses."}).define("scaleSpecialLoot", false);
        SERVER_BUILDER.pop();
    }

    public static CountType getCountType() {
        return (CountType)((Object)playerCountType.get());
    }

    public static boolean isPersistDisabled() {
        return true;
    }

    public static boolean isPartySyncEnabled() {
        return false;
    }

    static {
        playerMessageCooldown = 10;
    }

    public static enum CountType {
        SERVER,
        DIMENSION,
        RADIUS,
        PARTY;

    }
}

