/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.data.config;

import io.sedu.mc.parties.api.mod.gamestages.SyncType;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfigData {
    public static ForgeConfigSpec.BooleanValue renderPotionEffects;
    public static ForgeConfigSpec.BooleanValue renderXPBar;
    public static ForgeConfigSpec.BooleanValue renderPlayerHealth;
    public static ForgeConfigSpec.BooleanValue renderPlayerArmor;
    public static ForgeConfigSpec.BooleanValue renderHunger;
    public static ForgeConfigSpec.BooleanValue renderThirst;
    public static ForgeConfigSpec.BooleanValue renderTemperature;
    public static ForgeConfigSpec.BooleanValue renderMana;
    public static ForgeConfigSpec.BooleanValue renderSSMana;
    public static ForgeConfigSpec.BooleanValue renderFeathers;
    public static ForgeConfigSpec.BooleanValue forceModelRotation;
    public static ForgeConfigSpec.IntValue rotationOffset;
    public static ForgeConfigSpec.BooleanValue endPotionEffects;
    public static ForgeConfigSpec.ConfigValue<RenderType> playerRender;
    public static ForgeConfigSpec.BooleanValue toughnessRender;
    public static ForgeConfigSpec.ConfigValue<SyncType> defaultSync;
    public static boolean glowParty;

    public static void registerClientConfig(ForgeConfigSpec.Builder CLIENT_BUILDER) {
        CLIENT_BUILDER.comment(new String[]{"--------------------------------------------------------", "Client Party Settings", "Type /party reload in-game to reload this configuration.", "--------------------------------------------------------"});
        CLIENT_BUILDER.push("party-ui");
        endPotionEffects = CLIENT_BUILDER.comment(new String[]{"End the potion effects on the client without the server packet", "If true, the client won't wait for the server to send a potion effect packet to remove the potion effects from the UI.", "If false, the potion effects will stay on the client until the server says the client no longer has it."}).define("endPotionEffects", true);
        playerRender = CLIENT_BUILDER.comment(new String[]{"Enables the Player Frame under specific conditions.", "ON - Enables the Player Frame.", "PARTY - Enables the Player Frame only when the player is in a party.", "OFF - Disables the Player Frame."}).defineEnum("playerRender", (Enum)RenderType.ON);
        toughnessRender = CLIENT_BUILDER.comment("Renders armor toughness as text in paranthesis next to the armor value if it's not zero.").define("toughnessRender", false);
        forceModelRotation = CLIENT_BUILDER.comment(new String[]{"Makes all the models drawn on the party frame face forward if true.", "Self model is drawn when the head element has Head Type at 1, or 2 for the entire party."}).define("forceModelRotation", false);
        rotationOffset = CLIENT_BUILDER.comment(new String[]{"Offset of the front-facing model if forceModelRotation is enabled.", "Negative values make the model face right, while positive values make the model face left."}).defineInRange("rotationOffset", -20, -180, 180);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("mod-options");
        defaultSync = CLIENT_BUILDER.comment(new String[]{"This allows you to set the type of automatic syncing you'd like for GameStages support", "When prompted from a party invite. Syncing only occurs if players allow it.", "ALL - Prompt disabled, all game stages are synced. Only works if server allows it.", "FUTURE - Prompt disabled, future game stages are synced. Only works if server allows it.", "NONE - Prompt disabled, no game stages are synced at all.", "PROMPT - A prompt asking for sync permission is sent each time you join a party."}).defineEnum("defaultSync", (Enum)SyncType.NONE);
        CLIENT_BUILDER.pop();
    }

    static {
        glowParty = false;
    }

    public static enum RenderType {
        ON,
        PARTY,
        OFF;

    }
}

