/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.data;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.DataType;
import io.sedu.mc.parties.data.PartyHelper;
import io.sedu.mc.parties.data.config.CommonConfigData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerPlayerData {
    public static HashMap<UUID, ServerPlayerData> playerList = new HashMap();
    public static List<MessageCdHolder> messageCd = new ArrayList<MessageCdHolder>();
    public static HashMap<UUID, HashMap<UUID, Boolean>> playerTrackers = new HashMap();
    private List<Player> nearMembers = new ArrayList<Player>();
    private List<Player> globalMembers = new ArrayList<Player>();
    private boolean listDirty = true;
    protected WeakReference<ServerPlayer> serverPlayer;
    private final HashMap<DataType, Object> dataItems = new HashMap();
    private LinkedHashMap<UUID, Integer> inviters = new LinkedHashMap();
    private UUID party;
    private boolean saturationDirty = false;

    public ServerPlayerData(UUID id) {
        playerList.put(id, this);
    }

    public ServerPlayerData(UUID playerId, UUID partyId, String name) {
        this.party = partyId;
        this.setName(name);
        playerList.put(playerId, this);
    }

    public static boolean isOnMessageCd(UUID uuid) {
        for (MessageCdHolder h : messageCd) {
            if (h.id != uuid) continue;
            return true;
        }
        return false;
    }

    public boolean hasParty() {
        return this.party != null;
    }

    public boolean isInviter(UUID inviter) {
        return this.inviters.containsKey(inviter);
    }

    public void removeInviter(UUID inviter) {
        this.inviters.remove(inviter);
    }

    public void addInviter(UUID inviter) {
        this.inviters.put(inviter, (Integer)CommonConfigData.playerAcceptTimer.get());
    }

    public void addParty(UUID id) {
        if (this.party != null) {
            return;
        }
        this.party = id;
    }

    public ServerPlayer getPlayer() {
        if (this.serverPlayer != null) {
            return (ServerPlayer)this.serverPlayer.get();
        }
        return null;
    }

    public UUID getPartyId() {
        return this.party;
    }

    public void removeParty() {
        this.party = null;
    }

    public ServerPlayerData setServerPlayer(ServerPlayer player) {
        this.serverPlayer = new WeakReference<ServerPlayer>(player);
        this.setName(player.m_7755_().getString());
        return this;
    }

    public String getName() {
        return this.serverPlayer != null && this.serverPlayer.get() != null ? ((ServerPlayer)this.serverPlayer.get()).m_7755_().getString() : (String)this.dataItems.get((Object)DataType.NAME);
    }

    public void setName(String name) {
        this.dataItems.put(DataType.NAME, name);
    }

    public ServerPlayerData removeServerPlayer() {
        this.serverPlayer = null;
        return this;
    }

    public static void addTracker(UUID trackerHost, UUID toTrack) {
        if (!playerTrackers.containsKey(toTrack)) {
            playerTrackers.put(toTrack, new HashMap());
        }
        playerTrackers.get(toTrack).put(trackerHost, true);
        PlayerAPI.getPlayer(trackerHost, ServerPlayerData::markDirty);
    }

    private void markDirty() {
        this.listDirty = true;
    }

    public static void removeTracker(UUID trackerHost, UUID toTrack) {
        if (!playerTrackers.containsKey(toTrack)) {
            return;
        }
        playerTrackers.get(toTrack).remove(trackerHost);
        if (playerTrackers.get(toTrack).isEmpty()) {
            playerTrackers.remove(toTrack);
        }
        PlayerAPI.getPlayer(trackerHost, ServerPlayerData::markDirty);
    }

    public static void changeTracker(UUID trackerHost, UUID toTrack, boolean serverTracked) {
        playerTrackers.get(toTrack).put(trackerHost, serverTracked);
        PlayerAPI.getPlayer(trackerHost, ServerPlayerData::markDirty);
    }

    public void tickInviters() {
        LinkedHashMap invNew = new LinkedHashMap();
        this.inviters.forEach((uuid, anInt) -> {
            Integer n = anInt;
            anInt = anInt - 1;
            if (n <= 0) {
                PartyHelper.dismissInvite(this, uuid);
            } else {
                invNew.put(uuid, anInt);
            }
        });
        this.inviters = invNew;
    }

    public <T> void setData(T data, DataType t, Consumer<? super T> action) {
        try {
            if (!this.dataItems.getOrDefault((Object)t, t.empty()).equals(data)) {
                this.dataItems.put(t, data);
                action.accept(data);
                t.onUpdate(this);
                Parties.debug("Update of type {} for Player {}: {}", new Object[]{t, this.getName(), data});
            }
        }
        catch (ClassCastException e) {
            Parties.LOGGER.error("Stored object is of a different type!", (Throwable)e);
        }
    }

    public float getStamina() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.STAM, Float.valueOf(0.0f))).floatValue();
    }

    public int getMaxStamina() {
        return (Integer)this.dataItems.getOrDefault((Object)DataType.MAXSTAM, 0);
    }

    public int getExtraStamina() {
        return (Integer)this.dataItems.getOrDefault((Object)DataType.EXTRASTAM, 0);
    }

    public void updateSaturation(Consumer<Float> action) {
        if (this.saturationDirty) {
            action.accept(Float.valueOf(this.getSaturation()));
            this.saturationDirty = false;
        }
    }

    public float getSaturation() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.SATURATION, Float.valueOf(0.0f))).floatValue();
    }

    public void removeInviters() {
        this.inviters.forEach((uuid, integer) -> PartyHelper.dismissInvite(uuid));
        this.inviters.clear();
    }

    public void ifInviterExists(Consumer<UUID> action) {
        Iterator<UUID> iter = this.inviters.keySet().iterator();
        UUID id = null;
        while (iter.hasNext()) {
            id = iter.next();
        }
        if (id != null) {
            action.accept(id);
        }
    }

    public void markSaturationDirty() {
        this.saturationDirty = true;
    }

    public List<Player> getNearbyMembers() {
        ServerPlayer p = this.getPlayer();
        if (this.listDirty) {
            if (p == null) {
                Parties.LOGGER.error("Attempted to redo experience calculations when a player was not fully connected yet!");
            } else {
                this.redoList(p.m_20148_());
            }
        }
        return this.nearMembers;
    }

    public List<Player> getOnlineMembers() {
        ServerPlayer p = this.getPlayer();
        if (this.listDirty) {
            if (p == null) {
                Parties.LOGGER.error("Attempted to redo experience calculations when a player was not fully connected yet!");
            } else {
                this.redoList(p.m_20148_());
            }
        }
        return this.globalMembers;
    }

    private void redoList(UUID id) {
        Parties.debug("Refreshing members for XP share!", new Object[0]);
        this.nearMembers = PartyAPI.getNearMembersWithoutSelf(id);
        this.globalMembers = PartyAPI.getOnlineMembersWithoutSelf(id);
        this.listDirty = false;
    }

    public float getCurrentMana() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.MANA, Float.valueOf(0.0f))).floatValue();
    }

    public int getMaxMana() {
        return (Integer)this.dataItems.getOrDefault((Object)DataType.MAXMANA, 0);
    }

    public float getManaSS() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.SSMANA, Float.valueOf(0.0f))).floatValue();
    }

    public float getMaxManaSS() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.SSMANAMAX, Float.valueOf(0.0f))).floatValue();
    }

    public float getExtraManaSS() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.SSMANAABS, Float.valueOf(0.0f))).floatValue();
    }

    public int getThirst() {
        return (Integer)this.dataItems.getOrDefault((Object)DataType.THIRST, 0);
    }

    public int getQuench() {
        return (Integer)this.dataItems.getOrDefault((Object)DataType.QUENCH, 0);
    }

    public float getWorldTemp() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.WORLDTEMP, Float.valueOf(0.0f))).floatValue();
    }

    public float getBodyTemp() {
        return ((Float)this.dataItems.getOrDefault((Object)DataType.BODYTEMP, Float.valueOf(0.0f))).floatValue();
    }

    public static class MessageCdHolder {
        UUID id;
        int cooldown;

        public MessageCdHolder(UUID id, int cooldown) {
            this.id = id;
            this.cooldown = cooldown;
        }

        public boolean tick() {
            return this.cooldown-- <= 0;
        }
    }
}

