/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.data;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.PartyData;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class PartySaveData
extends SavedData {
    private static final String ID = "partiesdata";
    public static ServerLevel globalLevel;
    public static MinecraftServer server;

    @NotNull
    public static PartySaveData get() {
        return (PartySaveData)globalLevel.m_8895_().m_164861_(PartySaveData::new, PartySaveData::new, ID);
    }

    public PartySaveData() {
        Parties.debug("Creating party save data...", new Object[0]);
    }

    public PartySaveData(CompoundTag tag) {
        Parties.debug("Loading party save data...", new Object[0]);
        if (CommonConfigData.isPersistDisabled() || CommonConfigData.isPartySyncEnabled()) {
            Parties.debug("Loading cancelled, party persistence disabled or syncing from other parties mod...", new Object[0]);
            return;
        }
        ListTag parties = tag.m_128437_("parties", 10);
        for (Tag t : parties) {
            CompoundTag tC = (CompoundTag)t;
            UUID partyId = tC.m_128342_("id");
            PartyData party = new PartyData(partyId, tC.m_128342_("leader"), false);
            ListTag members = tC.m_128437_("members", 10);
            for (Tag m : members) {
                CompoundTag mC = (CompoundTag)m;
                UUID pId = mC.m_128342_("id");
                new ServerPlayerData(pId, partyId, mC.m_128461_("name"));
                party.addMemberSilently(pId);
            }
            PartyData.partyList.put(partyId, party);
        }
        Parties.debug("Created " + PartyData.partyList.size() + " parties.", new Object[0]);
        for (PartyData p : PartyData.partyList.values()) {
            Parties.debug("Party with " + p.getMembers().size() + " people", new Object[0]);
            Parties.debug("Party leader is " + PlayerAPI.getName(p.getLeader()), new Object[0]);
            for (UUID member : p.getMembers()) {
                Parties.debug("Party member: " + PlayerAPI.getName(member), new Object[0]);
            }
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        Parties.debug("Saving parties to disk...", new Object[0]);
        if (CommonConfigData.isPersistDisabled()) {
            Parties.debug("Saving cancelled, party persistence disabled...", new Object[0]);
            return tag;
        }
        ListTag list = new ListTag();
        PartyData.partyList.forEach((uuid, partyData) -> {
            CompoundTag partyTag = new CompoundTag();
            partyTag.m_128362_("id", uuid);
            partyTag.m_128362_("leader", partyData.getLeader());
            ListTag partyMems = new ListTag();
            partyData.getMembers().forEach(id -> {
                CompoundTag playerTag = new CompoundTag();
                playerTag.m_128359_("name", PlayerAPI.getName(id));
                playerTag.m_128362_("id", id);
                partyMems.add((Object)playerTag);
            });
            partyTag.m_128365_("members", (Tag)partyMems);
            list.add((Object)partyTag);
        });
        tag.m_128365_("parties", (Tag)list);
        return tag;
    }
}

