/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.data;

import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.PartyData;
import io.sedu.mc.parties.data.ServerPlayerData;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PartyHelper {
    public static boolean invitePlayerForced(UUID initiator, UUID futureMember, boolean ignoreVerify) {
        if (!ignoreVerify && !PartyHelper.verifyRequest(initiator, futureMember)) {
            return false;
        }
        ServerPlayerData pD = PlayerAPI.getNormalPlayer(initiator);
        if (pD != null && !pD.hasParty()) {
            new PartyData(initiator);
            if (pD.getPlayer() != null) {
                MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Online(pD.getPartyId(), initiator));
            }
        }
        return PartyHelper.addPlayerToParty(futureMember, Objects.requireNonNull(PartyAPI.getPartyFromMember(initiator)));
    }

    public static boolean acceptInvite(UUID initiator, UUID futureMember) {
        ServerPlayerData fM = PlayerAPI.getNormalPlayer(futureMember);
        if (fM == null) {
            return false;
        }
        if (fM.isInviter(initiator)) {
            fM.removeInviter(initiator);
            return PartyHelper.invitePlayerForced(initiator, futureMember, false);
        }
        return false;
    }

    public static boolean acceptInvite(UUID futureMember) {
        AtomicBoolean ret = new AtomicBoolean(false);
        PlayerAPI.getPlayer(futureMember, playerData -> playerData.ifInviterExists(inviter -> ret.set(PartyHelper.acceptInvite(inviter, futureMember))));
        return ret.get();
    }

    public static boolean declineInvite(UUID initiator, UUID futureMember) {
        ServerPlayerData pD = PlayerAPI.getNormalPlayer(futureMember);
        if (pD == null) {
            return false;
        }
        if (!pD.isInviter(initiator)) {
            return false;
        }
        ServerPlayer p = PlayerAPI.getNormalServerPlayer(initiator);
        if (p != null) {
            p.m_213846_((Component)Component.m_237110_((String)"messages.sedparties.phandler.invitedeclined", (Object[])new Object[]{PlayerAPI.getName(futureMember)}).m_130940_(ChatFormatting.DARK_AQUA));
        }
        if ((p = PlayerAPI.getNormalServerPlayer(futureMember)) != null) {
            p.m_213846_((Component)Component.m_237110_((String)"messages.sedparties.phandler.declineinvite", (Object[])new Object[]{PlayerAPI.getName(initiator)}).m_130940_(ChatFormatting.DARK_AQUA));
        }
        PlayerAPI.getPlayer(futureMember, playerData -> playerData.removeInviter(initiator));
        return true;
    }

    public static boolean declineInvite(UUID futureMember) {
        AtomicBoolean ret = new AtomicBoolean(false);
        PlayerAPI.getPlayer(futureMember, playerData -> playerData.ifInviterExists(inviter -> ret.set(PartyHelper.declineInvite(inviter, futureMember))));
        return ret.get();
    }

    public static boolean addPlayerToParty(UUID futureMember, PartyData currentParty) {
        currentParty.addMember(futureMember);
        MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Join(currentParty.getId(), futureMember));
        return true;
    }

    public static boolean kickPlayer(UUID initiator, UUID removedMember) {
        if (!PartyAPI.inSameParty(initiator, removedMember)) {
            return false;
        }
        return PartyHelper.removePlayerFromParty(removedMember, true);
    }

    public static boolean removePlayerFromParty(UUID removedMember, boolean wasKicked) {
        Objects.requireNonNull(PartyAPI.getPartyFromMember(removedMember)).removeMember(removedMember, wasKicked);
        return true;
    }

    public static boolean leaveParty(UUID memberLeaving) {
        ServerPlayerData p = PlayerAPI.getNormalPlayer(memberLeaving);
        if (p != null && p.hasParty()) {
            Objects.requireNonNull(PartyAPI.getPartyFromMember(memberLeaving)).removeMember(memberLeaving, false);
            return true;
        }
        return false;
    }

    public static boolean giveLeader(UUID newLeader) {
        Objects.requireNonNull(PartyAPI.getPartyFromMember(newLeader)).updateLeader(newLeader);
        return true;
    }

    public static void questionPlayer(UUID initiator, UUID futureMember) {
        ServerPlayerData fM;
        if (PartyHelper.verifyRequest(initiator, futureMember) && !Objects.requireNonNull(fM = PlayerAPI.getNormalPlayer(futureMember)).isInviter(initiator)) {
            fM.addInviter(initiator);
            fM.getPlayer().m_213846_((Component)Component.m_237110_((String)"messages.sedparties.phandler.receivedinvite", (Object[])new Object[]{PlayerAPI.getName(initiator)}).m_130940_(ChatFormatting.DARK_AQUA));
            fM.getPlayer().m_213846_((Component)Component.m_237115_((String)"messages.sedparties.phandler.receivedinvite2").m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)Component.m_237115_((String)"messages.sedparties.phandler.receivedinvite3").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/party accept " + PlayerAPI.getName(initiator))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"messages.sedparties.phandler.accepttooltip"))))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"messages.sedparties.phandler.receivedinvite4").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/party decline " + PlayerAPI.getName(initiator))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"messages.sedparties.phandler.declinetooltip"))))));
            PlayerAPI.getServerPlayer(futureMember, serverPlayer -> serverPlayer.m_213846_((Component)Component.m_237115_((String)"messages.sedparties.phandler.receivedinvite5").m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)Component.m_237113_((String)"/party accept").m_130938_(style -> style.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)" | ").m_130940_(ChatFormatting.DARK_AQUA)).m_7220_((Component)Component.m_237113_((String)"/party decline").m_130938_(style -> style.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))))));
            PlayerAPI.getServerPlayer(initiator, serverPlayer -> serverPlayer.m_213846_((Component)Component.m_237110_((String)"messages.sedparties.phandler.sendinvite", (Object[])new Object[]{PlayerAPI.getName(futureMember)}).m_130940_(ChatFormatting.DARK_AQUA)));
        }
    }

    private static boolean verifyRequest(UUID initiator, UUID futureMember) {
        ServerPlayer p;
        if (PlayerAPI.getNormalPlayer(futureMember) == null || (p = PlayerAPI.getNormalServerPlayer(initiator)) == null || initiator.equals(futureMember)) {
            return false;
        }
        if (Objects.requireNonNull(PlayerAPI.getNormalPlayer(futureMember)).hasParty()) {
            p.m_213846_((Component)Component.m_237110_((String)"messages.sedparties.phandler.alreadyhasparty", (Object[])new Object[]{PlayerAPI.getName(futureMember)}).m_130940_(ChatFormatting.DARK_AQUA));
            return false;
        }
        if (Objects.requireNonNull(PlayerAPI.getNormalPlayer(initiator)).hasParty()) {
            if (!PartyAPI.isLeader(initiator)) {
                p.m_213846_((Component)Component.m_237115_((String)"messages.sedparties.phandler.noinviteperms").m_130940_(ChatFormatting.DARK_AQUA));
                return false;
            }
            if (Objects.requireNonNull(PartyAPI.getPartyFromMember(initiator)).isFull()) {
                p.m_213846_((Component)Component.m_237115_((String)"messages.sedparties.phandler.partyfull").m_130940_(ChatFormatting.DARK_AQUA));
                return false;
            }
        }
        return true;
    }

    public static void dismissInvite(UUID initiator) {
        PlayerAPI.getServerPlayer(initiator, serverPlayer -> serverPlayer.m_213846_((Component)Component.m_237115_((String)"messages.sedparties.phandler.declineinviteauto").m_130940_(ChatFormatting.DARK_AQUA)));
    }

    public static void dismissInvite(ServerPlayerData serverPlayerData, UUID initiator) {
        PlayerAPI.getServerPlayer(initiator, serverPlayer -> serverPlayer.m_213846_((Component)Component.m_237110_((String)"messages.sedparties.phandler.declineinviteauto2", (Object[])new Object[]{serverPlayerData.getName()}).m_130940_(ChatFormatting.DARK_AQUA)));
        ServerPlayer p = serverPlayerData.getPlayer();
        if (p != null) {
            p.m_213846_((Component)Component.m_237110_((String)"messages.sedparties.phandler.declineinviteauto3", (Object[])new Object[]{PlayerAPI.getName(initiator)}).m_130940_(ChatFormatting.DARK_AQUA));
        }
    }
}

