/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.data;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.network.ServerPacketHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PartyData {
    public static HashMap<UUID, PartyData> partyList = new HashMap();
    private UUID leader;
    private final ArrayList<UUID> party = new ArrayList();
    private final UUID partyId;
    private int xpOverflow = 0;

    public PartyData(UUID initiator) {
        this.partyId = UUID.randomUUID();
        partyList.put(this.partyId, this);
        this.party.add(initiator);
        MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Create(this.partyId, initiator));
        PlayerAPI.getPlayer(initiator, playerData -> playerData.addParty(this.partyId));
        this.updateLeaderNew(initiator);
    }

    public PartyData(UUID partyId, UUID leader, boolean addToParty) {
        this.partyId = partyId;
        this.leader = leader;
        if (addToParty) {
            this.party.add(leader);
        }
    }

    private void updateLeaderNew(UUID initiator) {
        this.leader = initiator;
        ServerPacketHelper.sendNewLeader(initiator);
    }

    public void addMember(UUID futureMember) {
        Parties.debug("Add Member internal START", new Object[0]);
        this.party.forEach(id -> {
            ServerPlayerData.addTracker(id, futureMember);
            ServerPlayerData.addTracker(futureMember, id);
        });
        Parties.debug("Add Member internal POST-trackers", new Object[0]);
        ServerPacketHelper.sendNewMember(futureMember, this.party);
        Parties.debug("Add Member internal POST-packet", new Object[0]);
        this.party.add(futureMember);
        Parties.debug("Add Member internal POST-party", new Object[0]);
        PlayerAPI.getPlayer(futureMember, playerData -> playerData.addParty(this.partyId));
        Parties.debug("Add Member internal POST-player party info", new Object[0]);
        PlayerAPI.getServerPlayer(futureMember, serverPlayer -> MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Online(this.partyId, futureMember)));
        Parties.debug("Add Member internal POST-api", new Object[0]);
    }

    public void addMemberSilently(UUID futureMember) {
        this.party.forEach(id -> {
            ServerPlayerData.addTracker(id, futureMember);
            ServerPlayerData.addTracker(futureMember, id);
        });
        this.party.add(futureMember);
    }

    public ArrayList<UUID> getMembers() {
        return this.party;
    }

    public UUID getId() {
        return this.partyId;
    }

    public boolean equals(Object o) {
        if (o instanceof PartyData) {
            return this.partyId == ((PartyData)o).partyId;
        }
        return false;
    }

    public void removeMember(UUID removedMember, boolean wasKicked) {
        if (!this.party.remove(removedMember)) {
            Parties.LOGGER.error(" Error removing a party member from party!");
        }
        MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Leave(this.partyId, removedMember));
        PlayerAPI.getPlayer(removedMember, ServerPlayerData::removeParty);
        ServerPacketHelper.sendRemoveMember(removedMember, this.party, wasKicked);
        this.party.forEach(id -> {
            ServerPlayerData.removeTracker(removedMember, id);
            ServerPlayerData.removeTracker(id, removedMember);
        });
        if (this.party.size() == 1) {
            this.disband();
            return;
        }
        if (removedMember.equals(this.leader)) {
            this.updateLeader(this.party.get(0));
        }
    }

    public void disband() {
        UUID member = null;
        if (this.party.size() >= 1) {
            PlayerAPI.getServerPlayer(this.party.get(0), player -> player.m_6756_(this.xpOverflow));
            MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Disband(this.partyId, this.party.get(0)));
        }
        ServerPacketHelper.disband(this.party);
        Iterator<UUID> i = this.party.iterator();
        while (i.hasNext()) {
            member = i.next();
            PlayerAPI.getPlayer(member, ServerPlayerData::removeParty);
            MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Leave(this.partyId, member));
            ServerPlayerData.playerTrackers.remove(member);
            i.remove();
        }
        partyList.remove(this.partyId);
        if (member != null) {
            MinecraftForge.EVENT_BUS.post((Event)new PartyEvent.Disband(this.partyId, member));
        }
    }

    public void updateLeader(UUID newLeader) {
        this.leader = newLeader;
        ServerPacketHelper.sendNewLeader(newLeader, this.party);
    }

    public boolean isLeader(UUID playerId) {
        return this.leader.equals(playerId);
    }

    public UUID getLeader() {
        return this.leader;
    }

    public boolean isFull() {
        if (CommonConfigData.isPartySyncEnabled()) {
            return false;
        }
        return this.party.size() >= (Integer)CommonConfigData.partySize.get();
    }

    public int getXpOverflow() {
        return this.xpOverflow;
    }

    public void setXpOverflow(int i) {
        this.xpOverflow = i;
    }
}

