/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.sedu.mc.parties.api.helper.PartyAPI;
import io.sedu.mc.parties.api.mod.ftbteams.FTCompatManager;
import io.sedu.mc.parties.commands.NotSelfArgument;
import io.sedu.mc.parties.data.PartyHelper;
import io.sedu.mc.parties.data.PartySaveData;
import io.sedu.mc.parties.network.ClientPacketData;
import io.sedu.mc.parties.network.PartiesPacketHandler;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PartyCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"applypreset").executes(ctx -> {
            PartiesPacketHandler.sendToPlayer(new ClientPacketData(9), ((CommandSourceStack)ctx.getSource()).m_81375_());
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            PartyHelper.questionPlayer(p.m_20148_(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player").m_20148_());
            return 1;
        })))).then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"initiator", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            if (PartyHelper.acceptInvite(EntityArgument.m_91474_((CommandContext)ctx, (String)"initiator").m_20148_(), p.m_20148_())) {
                PartySaveData.get().m_77762_();
                return 1;
            }
            return 0;
        })))).then(Commands.m_82127_((String)"accept").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            if (PartyHelper.acceptInvite(p.m_20148_())) {
                PartySaveData.get().m_77762_();
                return 1;
            }
            return 0;
        }))).then(Commands.m_82127_((String)"decline").then(Commands.m_82129_((String)"initiator", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            if (PartyHelper.declineInvite(EntityArgument.m_91474_((CommandContext)ctx, (String)"initiator").m_20148_(), p.m_20148_())) {
                return 1;
            }
            return 0;
        })))).then(Commands.m_82127_((String)"decline").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            if (PartyHelper.declineInvite(p.m_20148_())) {
                return 1;
            }
            return 0;
        }))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            PartiesPacketHandler.sendToPlayer(new ClientPacketData(7), ((CommandSourceStack)ctx.getSource()).m_81375_());
            return 1;
        }))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"member", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            UUID senderId = p.m_20148_();
            if (!PartyAPI.hasParty(senderId)) {
                return 0;
            }
            if (!PartyAPI.isLeader(senderId)) {
                p.m_213846_((Component)Component.m_237115_((String)"messages.sedparties.command.kickfail").m_130940_(ChatFormatting.DARK_AQUA));
                return 0;
            }
            if (PartyHelper.kickPlayer(p.m_20148_(), NotSelfArgument.getPlayerUUID((CommandContext<CommandSourceStack>)ctx, "member", senderId))) {
                PartySaveData.get().m_77762_();
                return 1;
            }
            return 0;
        })))).then(Commands.m_82127_((String)"leave").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            if (PartyHelper.leaveParty(p.m_20148_())) {
                PartySaveData.get().m_77762_();
                return 1;
            }
            return 0;
        }))).then(Commands.m_82127_((String)"leader").then(Commands.m_82129_((String)"member", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            if (PartyCommands.partyDisabled((Player)p)) {
                return 0;
            }
            if (PartyAPI.isLeader(p.m_20148_()) && PartyHelper.giveLeader(EntityArgument.m_91474_((CommandContext)ctx, (String)"member").m_20148_())) {
                PartySaveData.get().m_77762_();
                return 1;
            }
            return 0;
        }))));
    }

    private static boolean partyDisabled(Player p) {
        if (FTCompatManager.getHandler().usingTeams()) {
            p.m_213846_((Component)Component.m_237115_((String)"messages.sedparties.api.partiesprefix").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)).m_7220_((Component)Component.m_237115_((String)"messages.sedparties.disabled.ftbteams").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))));
            return true;
        }
        return false;
    }
}

