/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.ColorAPI;
import io.sedu.mc.parties.client.overlay.GeneralOptions;
import io.sedu.mc.parties.client.overlay.PHead;
import io.sedu.mc.parties.client.overlay.PName;
import io.sedu.mc.parties.client.overlay.POrigin;
import io.sedu.mc.parties.client.overlay.PresetOptions;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.gui.ColorButton;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.HexBox;
import io.sedu.mc.parties.client.overlay.gui.InputBox;
import io.sedu.mc.parties.client.overlay.gui.SmallButton;
import io.sedu.mc.parties.client.overlay.gui.TabButton;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class SettingsScreen
extends Screen {
    private final ResourceLocation MENU_LOC = new ResourceLocation("textures/block/deepslate_tiles.png");
    private final ResourceLocation OPTIONS_LOC = new ResourceLocation("textures/block/spruce_log.png");
    private final ResourceLocation SEARCH_LOC = new ResourceLocation("textures/block/deepslate_tiles.png");
    int screenW;
    int screenH;
    int screenX = 0;
    int screenY = 0;
    private int oldX = 0;
    private int oldY = 0;
    private Integer oldMX = null;
    private Integer oldMY = null;
    private int maxScreenX;
    private int maxScreenY;
    private boolean draggingWindow = false;
    int eleBoxX;
    int eleBoxY;
    int eleBoxW;
    int eleBoxH;
    static int selEle = 0;
    int maxEles = 0;
    HashMap<String, TabButton> tabs = new HashMap();
    ArrayList<String> tabsOrder = new ArrayList();
    TabButton presetButton;
    ConfigOptionsList options;
    ArrayList<InputBox> tickables = new ArrayList();
    int modBoxX;
    int modBoxY;
    int modBoxW;
    int modBoxH;
    boolean modVisible = false;
    int optBoxX;
    int optBoxY;
    int optBoxW;
    int optBoxH;
    int presetBoxX;
    int presetBoxY;
    int presetBoxW;
    int presetBoxH;
    int selBoxX;
    int selBoxY;
    int selBoxW;
    int selBoxH;
    boolean renderSelBox = false;
    private static String nameHolder = null;
    private static String descHolder = null;
    Pattern alphaNumeric = Pattern.compile("^[a-zA-Z0-9_-]*$");
    private final ArrayList<Button> miscButtons;
    private final MutableComponent confirmPrompt;
    private boolean isConfirmed = false;
    public int buttonCooldown = 0;
    public boolean sentMessage = false;
    public int messageCooldown = 0;
    public int revertCooldown = 0;
    private boolean triggeredPrompt = false;
    private final boolean isPresetOnly;
    protected final HashMap<String, RenderItem.Update> updater = new HashMap();
    protected final HashMap<String, RenderItem.Getter> getter = new HashMap();
    InputBox nameBox;
    InputBox descBox;

    protected SettingsScreen(boolean b) {
        super((Component)Component.m_237113_((String)"Party Advanced Settings"));
        this.miscButtons = new ArrayList();
        this.isPresetOnly = b;
        this.confirmPrompt = Component.m_237115_((String)"gui.sedparties.tooltip.confirmreset").m_130940_(ChatFormatting.DARK_RED);
    }

    private void resetAll() {
    }

    private void refreshCurrentEle() {
        this.selectButton(selEle);
    }

    private void resetEle() {
        if (selEle == -1) {
            return;
        }
        if (selEle == 0) {
            RenderItem.getGeneralDefaults().forEachEntry((s, v) -> this.updater.get(s.getName()).onUpdate(null, v));
        } else {
            this.refreshCurrentEle();
        }
    }

    private void toggleEles(boolean b) {
    }

    private void toggleRGB() {
        HexBox.rgbMode = !HexBox.rgbMode;
        this.options.markDirty();
    }

    private void toggleModBox(boolean show) {
        if (show) {
            this.modVisible = true;
            this.miscButtons.get((int)1).f_93624_ = true;
            this.miscButtons.get((int)0).f_93624_ = false;
        } else {
            this.modVisible = false;
            this.miscButtons.get((int)1).f_93624_ = false;
            this.miscButtons.get((int)0).f_93624_ = true;
        }
        this.updateOptionsBounds();
    }

    public void m_86600_() {
        this.tickables.forEach(InputBox::tick);
        if (this.triggeredPrompt && this.buttonCooldown > 0 && --this.buttonCooldown == 0) {
            this.triggeredPrompt = false;
            this.isConfirmed = true;
            this.miscButtons.get((int)6).f_93623_ = true;
        }
        if (this.isConfirmed && this.revertCooldown > 0 && --this.revertCooldown == 0) {
            this.isConfirmed = false;
            ((SmallButton)this.miscButtons.get(6)).setColor(1.0f, 1.0f, 0.5f);
            this.miscButtons.get(6).m_93666_((Component)Component.m_237113_((String)"\u21ba"));
        }
        if (this.sentMessage && this.messageCooldown-- < 0) {
            this.sentMessage = false;
            this.miscButtons.get((int)10).f_93623_ = true;
        }
    }

    public void m_7379_() {
        ColorAPI.setColorCycle(false);
        PHead.icon = null;
        PName.sign = null;
        POrigin.icon = null;
        GeneralOptions.icon = null;
        PresetOptions.icon = null;
        nameHolder = this.nameBox.getValue().isEmpty() ? null : this.nameBox.getValue();
        descHolder = this.descBox.getValue().isEmpty() ? null : this.descBox.getValue();
        super.m_7379_();
    }

    void addTickableEntry(InputBox input) {
        this.tickables.add(input);
    }

    void resetTickables() {
        this.tickables.clear();
        this.tickables.add(this.nameBox);
        this.tickables.add(this.descBox);
    }

    public void render(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.triggeredPrompt) {
            poseStack.m_252880_(0.0f, 0.0f, 1.0f);
            poseStack.m_252880_(0.0f, 0.0f, -1.0f);
        }
        if (this.renderSelBox) {
            this.renderSelection(poseStack);
        }
        if (this.draggingWindow) {
            this.move(pMouseX, pMouseY);
            return;
        }
        if (this.oldMX != null) {
            this.save();
            return;
        }
        RenderSystem.enableDepthTest();
        assert (this.f_96541_ != null);
        this.renderOptionsBox();
        this.renderPresetBox();
        this.renderShadows(poseStack);
        RenderUtils.renderBg(0, this.screenX, this.screenY, this.screenX + this.screenW, this.screenY + this.eleBoxH, this.screenW, this.eleBoxH, 200, this.MENU_LOC);
    }

    private void move(int x, int y) {
        if (this.oldMX == null) {
            this.oldMX = x;
            this.oldMY = y;
            this.oldX = this.screenX;
            this.oldY = this.screenY;
        }
        this.checkLimits(x, y);
    }

    private void checkLimits(int x, int y) {
        int tempFrame = x - this.oldMX + this.oldX;
        this.screenX = tempFrame < 0 ? 0 : (tempFrame + this.screenW > this.maxScreenX ? this.maxScreenX - this.screenW : tempFrame);
        tempFrame = y - this.oldMY + this.oldY;
        this.screenY = tempFrame < 0 ? 0 : (tempFrame + this.screenH > this.maxScreenY ? this.maxScreenY - this.screenH : tempFrame);
    }

    private void save() {
        this.oldMY = null;
        this.oldMX = null;
        this.setBounds(this.f_96543_, this.f_96544_, false, true);
    }

    private void renderSelection(PoseStack poseStack) {
    }

    void renderPresetBox() {
        RenderUtils.renderBg(this.presetBoxX, this.presetBoxY, this.presetBoxX + this.presetBoxW, this.presetBoxY + this.presetBoxH, this.presetBoxW, this.presetBoxH, 200, this.SEARCH_LOC);
    }

    private void renderOptionsBox() {
        RenderUtils.renderBg(this.optBoxX, this.optBoxY, this.optBoxX + this.optBoxW, this.optBoxY + this.optBoxH, this.optBoxW, this.optBoxH, 255, this.OPTIONS_LOC);
    }

    void renderShadows(PoseStack poseStack) {
    }

    protected void m_7856_() {
        this.initMiscButtons();
        ColorAPI.setColorCycle(true);
        RenderItem.initUpdater(this.updater);
        RenderItem.initGetter(this.getter);
        if (this.isPresetOnly) {
            // empty if block
        }
        PHead.icon = new ItemStack((ItemLike)Items.f_42680_);
        GeneralOptions.icon = new ItemStack((ItemLike)Items.f_42351_);
        PresetOptions.icon = new ItemStack((ItemLike)Items.f_42519_);
        assert (Minecraft.m_91087_().f_91074_ != null);
        PHead.icon.m_41700_("SkullOwner", (Tag)StringTag.m_129297_((String)Minecraft.m_91087_().f_91074_.m_7755_().getString()));
        PName.sign = Items.f_42439_.m_7968_();
        POrigin.icon = Items.f_42686_.m_7968_();
        POrigin.icon.m_41700_("Enchantments", (Tag)StringTag.m_129297_((String)""));
        this.initTabButtons();
        this.setBounds(this.f_96543_, this.f_96544_, true, false);
        super.m_7856_();
    }

    void initMiscButtons() {
        this.miscButtons.add(new ColorButton(6633155, 0, 0, 20, 20, (Component)Component.m_237113_((String)"\u25ba"), b -> this.toggleModBox(true), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.showfilters"))));
        this.miscButtons.add(new ColorButton(6633155, 0, 0, 20, 20, (Component)Component.m_237113_((String)"\u25c4"), b -> this.toggleModBox(false), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.hidefilters"))));
        this.miscButtons.add(new SmallButton(0, 0, "c", b -> this.toggleRGB(), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.rgbtoggle")), 0.5f, 0.0f, 0.5f, 0.5f, 0.5f));
        this.miscButtons.add(new SmallButton(0, 0, "x", b -> this.toggleEles(false), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.eleoff")), 1.0f, 0.5f, 0.5f));
        this.miscButtons.add(new SmallButton(0, 0, "\u2713", b -> this.toggleEles(true), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.eleon")), 0.5f, 1.0f, 0.5f));
        this.miscButtons.add(new SmallButton(0, 0, "\u21ba", b -> this.resetEle(), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.curdefault")), 0.5f, 1.0f, 1.0f));
        this.miscButtons.add(new SmallButton(0, 0, "\u21ba", b -> this.resetAll(), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.alldefault")), 1.0f, 1.0f, 0.5f));
        this.miscButtons.add(new SmallButton(0, 0, "s", b -> this.savePreset(), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.savepreset")), 0.5f, 0.0f, 0.5f, 1.0f, 0.5f));
        this.miscButtons.add(new SmallButton(0, 0, "c", b -> this.copyPreset(), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.copypreset")), 0.5f, 0.0f, 1.0f, 0.5f, 1.0f));
        this.miscButtons.add(new SmallButton(0, 0, "p", b -> this.pastePreset(), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.loadpreset")), 0.5f, 0.0f, 1.0f, 0.5f, 1.0f));
        this.miscButtons.add(new SmallButton(0, 0, "\u270e", b -> this.sendPresetToChat(), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.linkpreset")), 0.0f, 1.0f, 1.0f, 0.5f, 1.0f));
        this.nameBox = new InputBox(0xFFFFFF, this.f_96547_, 0, 12, (Component)Component.m_237115_((String)"gui.sedparties.name.namebox"), s -> this.checkSaveFlags(), false);
        this.descBox = new InputBox(0xFFFFFF, this.f_96547_, 0, 12, (Component)Component.m_237115_((String)"gui.sedparties.name.descbox"), s -> this.checkSaveFlags(), false);
        this.nameBox.filter = s -> this.alphaNumeric.matcher((CharSequence)s).find();
        this.nameBox.insertText(nameHolder == null ? "" : nameHolder);
        this.descBox.insertText(descHolder == null ? "" : descHolder);
        this.descBox.setMaxLength(128);
        this.checkSaveFlags();
    }

    private void sendPresetToChat() {
    }

    private void pastePreset() {
    }

    private void savePreset() {
    }

    private void copyPreset() {
    }

    private void checkSaveFlags() {
        this.miscButtons.get((int)7).f_93623_ = !this.nameBox.getValue().isEmpty() && !this.descBox.getValue().isEmpty();
    }

    private void initTabButtons() {
        assert (this.f_96541_ != null);
        this.presetButton = this.isPresetOnly ? new TabButton(-1, 0, 0, 32, 32, b -> {}, RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.name.preset")), new PresetOptions("Load").render((ForgeGui)this.f_96541_.f_91065_)) : new TabButton(-1, 0, 0, 32, 32, b -> this.selectButton(((TabButton)b).index), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.name.preset")), new PresetOptions("Load").render((ForgeGui)this.f_96541_.f_91065_));
        if (this.isPresetOnly) {
            return;
        }
        boolean i = true;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.tickables.size() > 0) {
            this.tickables.forEach(inputBox -> inputBox.setFocus(false));
        }
        if (!super.m_6375_(pMouseX, pMouseY, pButton)) {
            this.checkWindowDrag(pMouseX, pMouseY);
            return false;
        }
        return true;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.draggingWindow = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    private void checkWindowDrag(double x, double y) {
        this.draggingWindow = x < (double)this.screenX || x > (double)(this.screenX + this.screenW) || y < (double)this.screenY || y > (double)(this.screenY + this.screenH);
    }

    protected void selectButton(int i) {
        selEle = i;
        this.options = null;
        this.updateOptionsBounds();
        this.organizeTabButtons();
    }

    void setBounds(int width, int height, boolean init, boolean moved) {
        if (!moved) {
            this.screenW = Math.min(width >> 1, 320);
            this.screenH = Math.min((height >> 2) * 3, 300);
            this.screenX = width > 720 ? width - this.screenW >> 1 : width - this.screenW - 10;
            this.screenY = height - this.screenH >> 1;
        }
        this.eleBoxW = this.screenW - 32;
        this.maxEles = this.eleBoxW / 24;
        this.eleBoxX = this.screenX + 32;
        this.eleBoxY = this.screenY;
        this.eleBoxH = Math.min(32, this.screenH);
        this.organizeTabButtons();
        this.modBoxW = Math.min(32, this.screenW);
        this.modBoxX = this.screenX;
        this.modBoxY = this.screenY + 32;
        this.modBoxH = this.screenH - 32;
        this.optBoxH = this.screenH - this.eleBoxH;
        this.optBoxW = 16;
        this.optBoxX = this.screenX + this.screenW - this.optBoxW;
        this.optBoxY = this.screenY + this.eleBoxH;
        int butX = this.optBoxX + 3;
        this.presetBoxH = Math.min(32, this.screenH);
        this.presetBoxW = this.screenW;
        this.presetBoxX = this.screenX;
        this.presetBoxY = this.screenY + this.screenH - this.presetBoxH;
        this.nameBox.m_93674_(Math.max(30, this.screenW / 5));
        this.descBox.m_93674_(Math.max(50, this.screenW * 2 / 5));
        if (init) {
            this.miscButtons.forEach(x$0 -> {
                Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
            });
            this.tabs.values().forEach(x$0 -> {
                TabButton cfr_ignored_0 = (TabButton)this.m_142416_((GuiEventListener)x$0);
            });
            this.m_142416_((GuiEventListener)this.presetButton);
            this.m_142416_((GuiEventListener)this.nameBox);
            this.m_142416_((GuiEventListener)this.descBox);
            this.nameBox.setHighlightPos(this.nameBox.getValue().length());
            this.descBox.setHighlightPos(this.descBox.getValue().length());
            this.m_169411_((GuiEventListener)this.miscButtons.get(0));
            this.m_169411_((GuiEventListener)this.miscButtons.get(1));
            if (this.isPresetOnly) {
                this.miscButtons.get((int)0).f_93623_ = false;
                this.miscButtons.get((int)1).f_93623_ = false;
                this.miscButtons.get((int)2).f_93623_ = false;
                this.miscButtons.get((int)3).f_93623_ = false;
                this.miscButtons.get((int)4).f_93623_ = false;
                this.miscButtons.get((int)5).f_93623_ = false;
                this.miscButtons.get((int)6).f_93623_ = false;
            }
        }
        this.updateOptionsBounds();
        this.maxScreenX = this.f_96541_.m_91268_().m_85445_();
        this.maxScreenY = this.f_96541_.m_91268_().m_85446_();
    }

    private void organizeTabButtons() {
        int eleCounter = 0;
        int xOffset = this.eleBoxX + (this.eleBoxW - 24 * this.maxEles) / 2;
        int yOffset = this.eleBoxY + 16;
        int currEle = 0;
        for (String tab : this.tabsOrder) {
            TabButton b = this.tabs.get(tab);
            if (eleCounter++ == this.maxEles) {
                yOffset -= 16;
                xOffset = this.eleBoxX + (this.eleBoxW - 24 * Math.min(this.maxEles, this.tabs.size() - (currEle += this.maxEles))) / 2;
                eleCounter = 1;
            }
            xOffset += 24;
        }
    }

    protected void updateOptionsBounds() {
        if (this.options == null) {
            if (selEle == -1 || this.isPresetOnly) {
                this.miscButtons.get((int)5).f_93623_ = false;
                this.options = this.presetButton.getOptions(this, this.f_96541_, 0, 0, 0, 0);
                this.renderSelBox = false;
            } else {
                this.miscButtons.get((int)5).f_93623_ = true;
                TabButton b = this.tabs.get(this.tabsOrder.get(selEle));
                this.options = b.getOptions(this, this.f_96541_, 0, 0, 0, 0);
                RenderItem.ItemBound bound = b.getBounds();
                this.selBoxX = bound.getX();
                this.selBoxY = bound.getY();
                this.selBoxW = bound.getWidth();
                this.selBoxH = bound.getHeight();
                this.renderSelBox = selEle != 0;
            }
        }
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        this.setBounds(pWidth, pHeight, false, false);
        this.f_96543_ = pWidth;
        this.f_96544_ = pHeight;
    }

    public void finalizeUpdate(String name, Object data, boolean markDirty) {
        this.triggerUpdate(name, data);
        Parties.debug("Update for " + name + " value " + data + ".", new Object[0]);
        if (markDirty) {
            this.markDirty();
        }
    }

    public void markDirty() {
        this.options.markSlidersDirty();
    }

    public void triggerUpdate(String name, Object data) {
    }

    public boolean m_7043_() {
        return false;
    }
}

