/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.gui;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.accessors.TrimmedMessagesAccessor;
import io.sedu.mc.parties.api.helper.ColorAPI;
import io.sedu.mc.parties.api.mod.jeed.JCompatManager;
import io.sedu.mc.parties.client.config.Config;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.Frame;
import io.sedu.mc.parties.client.overlay.PresetEntry;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.gui.SButton;
import io.sedu.mc.parties.util.AnimUtils;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PartyScreen
extends Screen {
    private final int keyCode;
    private SButton main;
    private final List<SButton> menu = new ArrayList<SButton>();
    private final List<SButton> pos = new ArrayList<SButton>();
    private final List<SButton> anch = new ArrayList<SButton>();
    private ScreenState state;
    private ScreenState preparedState;
    private boolean animActive = false;
    private int animTimer = 0;
    private int bgAlpha = 0;
    private final Rect r1 = new Rect(0, 0, 0, 0, 0);
    private final Rect r2 = new Rect(0, 0, 0, 0, 0);
    private final int step = 8;
    private boolean gridActive = false;
    private Frame.Type selectedFrame = Frame.Type.PLAYER;
    public static int offset = 0;
    public static int status = 0;
    private boolean draggingFrame = false;
    private List<GuiMessage.Line> trimmedMessages;
    private static ScreenGetter get = PartyScreen::new;
    private double dX = 0.0;
    private double dY = 0.0;

    public static Screen get(int value) {
        return get.getScreen(value);
    }

    public static void updateScreen(ScreenGetter g) {
        get = g;
    }

    public PartyScreen(int keyCode) {
        super((Component)Component.m_237113_((String)"Hover Screen"));
        this.keyCode = keyCode;
    }

    protected void m_7856_() {
        this.checkBorders();
        Frame.get(Frame.Type.PARTY).storeFakeData(Math.min(Math.max(0, ClientPlayerData.playerOrderedList != null ? ClientPlayerData.playerOrderedList.size() - 2 : 0), 4));
        ColorAPI.setColorCycle(true);
        this.initMenuButtons();
        status = 1;
        assert (this.f_96541_ != null);
        this.trimmedMessages = ((TrimmedMessagesAccessor)this.f_96541_.f_91065_.m_93076_()).getTrimmedMessages();
    }

    @Nullable
    public Style getClickedText(double pMouseX, double pMouseY) {
        if (this.trimmedMessages == null) {
            return null;
        }
        assert (this.f_96541_ != null);
        ChatComponent chat = this.f_96541_.f_91065_.m_93076_();
        if (!this.f_96541_.f_91066_.f_92062_) {
            double d0 = pMouseX - 2.0;
            double d1 = (double)this.f_96541_.m_91268_().m_85446_() - pMouseY - 40.0;
            d0 = Mth.m_14107_((double)(d0 / chat.m_93815_()));
            d1 = Mth.m_14107_((double)(d1 / (chat.m_93815_() * ((Double)this.f_96541_.f_91066_.m_232101_().m_231551_() + 1.0))));
            if (!(d0 < 0.0) && !(d1 < 0.0)) {
                GuiMessage.Line guimessage;
                int j;
                int i = Math.min(chat.m_93816_(), this.trimmedMessages.size());
                if (d0 <= (double)Mth.m_14107_((double)((double)chat.m_93813_() / chat.m_93815_())) && d1 < (double)(9 * i + i) && (j = (int)(d1 / 9.0)) >= 0 && j < this.trimmedMessages.size() && 200 + (guimessage = this.trimmedMessages.get(j)).f_240350_() - this.f_96541_.f_91065_.m_93079_() > 0) {
                    return this.f_96541_.f_91062_.m_92865_().m_92338_(guimessage.f_240339_(), (int)d0);
                }
            }
        }
        return null;
    }

    private void checkBorders() {
        Frame.forEach(frame -> frame.bindFrame(this.f_96543_, this.f_96544_));
        this.dX = Frame.get(this.selectedFrame).trueX();
        this.dY = Frame.get(this.selectedFrame).trueY();
    }

    private void initMenuButtons() {
        int primary = 16767139;
        int close = 0xFF7A7A;
        int util = 0x696969;
        int accept = 3329330;
        int anchor = 43690;
        Button.Builder b = new Button.Builder((Component)Component.m_237113_((String)"\u2398"), p -> this.prepareState(ScreenState.POSITIONING));
        b.m_253046_(12, 12);
        b.m_257505_(this.tip("posmenu"));
        this.menu.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u270e"), p -> this.openAdvancedSettings());
        b.m_253046_(12, 12);
        b.m_257505_(this.tip("presetmenu"));
        this.menu.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, util)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2690"), p -> this.prepareState(ScreenState.MAIN));
        b.m_253046_(12, 12);
        b.m_257505_(this.tip("closemenu"));
        this.menu.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, close)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2690"), p -> this.prepareState(ScreenState.MENU));
        b.m_253046_(12, 12);
        b.m_257505_(this.tip("mainmenu"));
        this.main = (SButton)this.m_142416_((GuiEventListener)new SButton(b, primary));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u20e0"), p -> this.defaultFrameValues());
        b.m_253046_(16, 16);
        b.m_257505_(this.tip("default"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, close)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2191"), p -> Frame.get(this.selectedFrame).changeFakeDisplay(true));
        b.m_253046_(14, 14);
        b.m_257505_(this.tip("countup"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2193"), p -> Frame.get(this.selectedFrame).changeFakeDisplay(false));
        b.m_253046_(14, 14);
        b.m_257505_(this.tip("countdown"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u25a1"), p -> {
            this.gridActive = !this.gridActive;
        });
        b.m_253046_(12, 12);
        b.m_257505_(this.tip("grid"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, util)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2190"), p -> this.moveX(false));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipMove("mleft"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2192"), p -> this.moveX(true));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipMove("mright"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2191"), p -> this.moveY(false));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipMove("mup"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2193"), p -> this.moveY(true));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipMove("mdown"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2714"), p -> {
            this.checkBorders();
            this.prepareState(ScreenState.MENU);
        });
        b.m_253046_(16, 16);
        b.m_257505_(this.tip("accept"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, accept)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2193"), p -> Frame.get(this.selectedFrame).changeScale(false));
        b.m_253046_(14, 14);
        b.m_257505_(this.tip("scaledown"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2191"), p -> Frame.get(this.selectedFrame).changeScale(true));
        b.m_253046_(14, 14);
        b.m_257505_(this.tip("scaleup"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, primary)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2398"), p -> this.nextFrame());
        b.m_253046_(12, 12);
        b.m_257505_(this.tip("cycle"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, util)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u27be"), p -> this.toggleAnchors());
        b.m_253046_(12, 12);
        b.m_257505_(this.tip("anchor"));
        this.pos.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2196"), p -> this.setAnchor(PresetEntry.Anchor.TOP_LEFT));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("topleft"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2191"), p -> this.setAnchor(PresetEntry.Anchor.TOP_CENTER));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("topcenter"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2197"), p -> this.setAnchor(PresetEntry.Anchor.TOP_RIGHT));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("topright"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2190"), p -> this.setAnchor(PresetEntry.Anchor.LEFT));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("left"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u25a1"), p -> this.setAnchor(PresetEntry.Anchor.CENTER));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("center"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2192"), p -> this.setAnchor(PresetEntry.Anchor.RIGHT));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("right"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2199"), p -> this.setAnchor(PresetEntry.Anchor.BOTTOM_LEFT));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("bottomleft"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2193"), p -> this.setAnchor(PresetEntry.Anchor.BOTTOM_CENTER));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("bottomcenter"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        b = new Button.Builder((Component)Component.m_237113_((String)"\u2198"), p -> this.setAnchor(PresetEntry.Anchor.BOTTOM_RIGHT));
        b.m_253046_(12, 12);
        b.m_257505_(this.tipAnchor("bottomright"));
        this.anch.add((SButton)this.m_142416_((GuiEventListener)new SButton(b, anchor)));
        this.anch.forEach(bt -> {
            bt.f_93624_ = false;
        });
        this.resetButtonPositions();
        this.preparedState = ScreenState.MAIN;
        this.changeState();
    }

    private void setAnchor(PresetEntry.Anchor anchor) {
        Frame.get(this.selectedFrame).setAnchor(anchor);
        Frame.get(this.selectedFrame).setX(0);
        Frame.get(this.selectedFrame).setY(0);
    }

    private void toggleAnchors() {
        boolean visible = this.anch.get((int)0).f_93624_;
        this.anch.forEach(b -> {
            b.f_93624_ = !visible;
        });
    }

    private Tooltip tip(String name) {
        String loc = "screen.sedparties.tooltip.";
        return Tooltip.m_257550_((Component)Component.m_237115_((String)(loc + name + ".title")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)(loc + name + ".desc")).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY)));
    }

    private Tooltip tipMove(String name) {
        String loc = "screen.sedparties.tooltip.";
        return Tooltip.m_257550_((Component)Component.m_237115_((String)(loc + name + ".title")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237110_((String)(loc + "mdown.desc"), (Object[])new Object[]{8}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY)));
    }

    private Tooltip tipAnchor(String name) {
        String loc = "screen.sedparties.tooltip.anchor.";
        return Tooltip.m_257550_((Component)Component.m_237115_((String)(loc + name)).m_130940_(ChatFormatting.GOLD));
    }

    private void moveX(boolean up) {
        Frame.get(this.selectedFrame).addX((Screen.m_96638_() ? 8 : 1) * (up ? 1 : -1));
    }

    private void moveY(boolean up) {
        Frame.get(this.selectedFrame).addY((Screen.m_96638_() ? 8 : 1) * (up ? 1 : -1));
    }

    private void defaultFrameValues() {
        Frame f = Frame.get(this.selectedFrame);
        switch (this.selectedFrame) {
            case PLAYER: {
                f.setScale(1.0);
                f.setX(0);
                f.setY(0);
                f.setAnchor(PresetEntry.Anchor.TOP_LEFT);
                break;
            }
            case PARTY: {
                f.setScale(0.5);
                f.setX(0);
                f.setY(0);
                f.setAnchor(PresetEntry.Anchor.LEFT);
            }
        }
        this.dX = Frame.get(this.selectedFrame).trueX();
        this.dY = Frame.get(this.selectedFrame).trueY();
    }

    private void openAdvancedSettings() {
        Config.generateDefaultPreset();
    }

    private void resetButtonPositions() {
        int left = this.f_96543_ / 2 - 102 - 8;
        int top = this.f_96544_ - 17;
        this.main.m_264152_(left, top);
        this.menu.get(0).m_264152_(left, top - 17);
        this.menu.get(1).m_264152_(left, top - 34);
        this.menu.get(2).m_264152_(left, top);
        left = this.f_96543_ / 2 - 6;
        top = this.f_96544_ - 25;
        this.pos.get(0).m_264152_(left - 30, top - 2);
        this.pos.get(1).m_264152_(left - 50, top);
        this.pos.get(2).m_264152_(left - 66, top);
        this.pos.get(3).m_264152_(left - 84, top - 9);
        this.pos.get(4).m_264152_(left - 10, top);
        this.pos.get(5).m_264152_(left + 10, top);
        this.pos.get(6).m_264152_(left, top - 10);
        this.pos.get(7).m_264152_(left, top + 10);
        this.pos.get(8).m_264152_(left + 26, top - 2);
        this.pos.get(9).m_264152_(left + 48, top);
        this.pos.get(10).m_264152_(left + 64, top);
        this.pos.get(11).m_264152_(left - 84, top + 9);
        this.pos.get(12).m_264152_(left + 83, top + 1);
        this.anch.get(0).m_264152_(left += 100, top -= 13);
        this.anch.get(1).m_264152_(left + 13, top);
        this.anch.get(2).m_264152_(left + 26, top);
        this.anch.get(3).m_264152_(left, top += 13);
        this.anch.get(4).m_264152_(left + 13, top);
        this.anch.get(5).m_264152_(left + 26, top);
        this.anch.get(6).m_264152_(left, top += 13);
        this.anch.get(7).m_264152_(left + 13, top);
        this.anch.get(8).m_264152_(left + 26, top);
    }

    private void prepareState(ScreenState s) {
        if (this.animActive) {
            return;
        }
        this.preparedState = s;
        this.animActive = true;
        this.animTimer = 10;
        if (this.preparedState == ScreenState.MENU) {
            if (this.state == ScreenState.MAIN) {
                this.hideButton(this.main);
                this.menu.get(0).disableMessage();
                this.menu.get(1).disableMessage();
                this.menu.get(2).enableMessage();
            }
            this.r1.l = this.f_96543_ / 2 - 117;
            this.r1.r = this.f_96543_ / 2 - 91;
            this.r1.b = this.f_96544_;
            this.menu.forEach(this::showButton);
        }
        if (this.preparedState == ScreenState.POSITIONING) {
            RenderItem.disableRenderer();
            this.r2.t = this.f_96544_ - 38;
            this.r2.b = this.f_96544_;
            this.pos.forEach(this::showButton);
            this.enableButtonsIfFrameValid();
        }
        if (this.state == ScreenState.POSITIONING) {
            RenderItem.enableRenderer();
        }
        if (this.preparedState == ScreenState.MAIN) {
            this.menu.forEach(SButton::disableMessage);
            this.showButton(this.main);
        }
        this.anch.forEach(b -> {
            b.f_93624_ = false;
        });
    }

    private void changeState() {
        this.state = this.preparedState;
        this.hideButton(this.main);
        this.menu.forEach(this::hideButton);
        this.pos.forEach(this::hideButton);
        switch (this.state) {
            case MAIN: {
                this.showButton(this.main);
                this.r2.a = 0;
                this.r1.a = 0;
                break;
            }
            case MENU: {
                this.menu.forEach(b -> {
                    b.enableMessage();
                    this.showButton((Button)b);
                });
                this.r1.pos(this.f_96543_ / 2 - 117, this.f_96543_ / 2 - 91, this.f_96544_ - 59, this.f_96544_);
                this.r1.a = 255;
                this.r2.a = 0;
                break;
            }
            case POSITIONING: {
                this.r1.a = 0;
                this.r2.a = 255;
                this.r2.pos(this.f_96543_ / 2 - 94, this.f_96543_ / 2 + 94, this.f_96544_ - 38, this.f_96544_);
                this.pos.forEach(this::showButton);
                this.enableButtonsIfFrameValid();
            }
        }
    }

    private void hideButton(Button b) {
        b.f_93624_ = false;
        b.f_93623_ = false;
    }

    private void showButton(Button b) {
        b.f_93624_ = true;
        b.f_93623_ = true;
    }

    private void enableButtonsIfFrameValid() {
        this.pos.get((int)2).f_93623_ = this.selectedFrame == Frame.Type.PARTY;
        this.pos.get((int)1).f_93623_ = this.pos.get((int)2).f_93623_;
    }

    public void m_88315_(@NotNull GuiGraphics g, int mX, int mY, float partialTick) {
        RenderUtils.rect(g.m_280168_().m_85850_().m_252922_(), -1, this.r2.l, this.r2.t, this.r2.r, this.r2.b, ColorAPI.getRainbowColor() | this.r2.a / 4 << 24);
        RenderUtils.borderRect(g.m_280168_().m_85850_().m_252922_(), -1, 1, this.r2.l, this.r2.t, this.r2.r, this.r2.b, ColorAPI.getRainbowColor() | this.r2.a / 2 << 24);
        RenderUtils.rect(g.m_280168_().m_85850_().m_252922_(), -1, this.r1.l, this.r1.t, this.r1.r, this.r1.b, ColorAPI.getRainbowColor() | this.r1.a / 4 << 24);
        RenderUtils.borderRect(g.m_280168_().m_85850_().m_252922_(), -1, 1, this.r1.l, this.r1.t, this.r1.r, this.r1.b, ColorAPI.getRainbowColor() | this.r1.a / 2 << 24);
        switch (this.preparedState) {
            case MAIN: {
                Frame.forEachHoveredTooltip(g, mX, mY, (item, id) -> item.renderTooltip(g, (ClientPlayerData)id, mX, mY));
            }
            case MENU: {
                this.renderChat(g, mX, mY);
                break;
            }
            case POSITIONING: {
                Frame.get(Frame.Type.PLAYER).selfRender(g, partialTick);
                RenderUtils.renderFrameOutline(Frame.get(Frame.Type.PLAYER), g.m_280168_());
                Frame.get(Frame.Type.PARTY).memberRenderFake(g, partialTick);
                RenderUtils.renderFrameSelection(Frame.get(this.selectedFrame), g);
                g.m_280137_(this.f_96547_, "\u00a72" + Frame.get(this.selectedFrame).getPositionString(), this.f_96543_ / 2, this.f_96544_ - 72, 0xFFFFFF);
                g.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"screen.sedparties.render.frameanchor", (Object[])new Object[]{String.valueOf((Object)Frame.get(this.selectedFrame).getAnchor())}).m_130940_(ChatFormatting.DARK_AQUA), this.f_96543_ / 2, this.f_96544_ - 60, 0xFFFFFF);
                g.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"screen.sedparties.render.frameselect", (Object[])new Object[]{String.valueOf((Object)this.selectedFrame)}).m_130940_(ChatFormatting.GOLD), this.f_96543_ / 2, this.f_96544_ - 48, 0xFFFFFF);
                if (!this.gridActive) break;
                this.renderGrid(g.m_280168_().m_85850_().m_252922_());
            }
        }
        this.animate();
        RenderUtils.rect(g.m_280168_().m_85850_().m_252922_(), -2, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.bgAlpha << 24);
        super.m_88315_(g, mX, mY, partialTick);
    }

    private void renderChat(GuiGraphics g, int mX, int mY) {
        Style style = this.getClickedText(mX, mY);
        if (style != null && style.m_131186_() != null) {
            g.m_280304_(this.f_96547_, style, mX, mY);
        }
    }

    private void animate() {
        if (this.animActive) {
            switch (this.state) {
                case MAIN: {
                    this.bgAlpha = AnimUtils.screenAnim(this.animTimer, 10, 0, 64);
                    this.menu.forEach(b -> b.m_253211_(AnimUtils.screenAnim(this.animTimer, 10, this.f_96544_ - 17, b.oY)));
                    this.r1.a = AnimUtils.screenAnim(this.animTimer, 10, 0, 255);
                    this.r1.t = this.f_96544_ - AnimUtils.screenAnim(this.animTimer, 10, 0, 59);
                    break;
                }
                case MENU: {
                    switch (this.preparedState) {
                        case MAIN: {
                            this.bgAlpha = AnimUtils.screenAnim(this.animTimer, 10, 64, 0);
                            this.menu.forEach(b -> b.m_253211_(AnimUtils.screenAnim(this.animTimer, 10, b.oY, this.f_96544_ - 17)));
                            this.r1.a = AnimUtils.screenAnim(this.animTimer, 10, 255, 0);
                            this.r1.t = this.f_96544_ - AnimUtils.screenAnim(this.animTimer, 10, 59, 0);
                            break;
                        }
                        case POSITIONING: {
                            this.bgAlpha = AnimUtils.screenAnim(this.animTimer, 10, 64, 128);
                            offset = AnimUtils.screenAnim(this.animTimer, 10, 0, 60);
                            this.menu.forEach(b -> b.m_253211_(AnimUtils.screenAnim(this.animTimer, 10, b.oY, this.f_96544_ + 5)));
                            this.pos.forEach(b -> b.m_253211_(AnimUtils.screenAnim(this.animTimer, 10, b.oY + 48, b.oY)));
                            int w = AnimUtils.screenAnim(this.animTimer, 10, 0, 94);
                            this.r2.l = this.f_96543_ / 2 - w;
                            this.r2.r = this.f_96543_ / 2 + w;
                            this.r2.a = AnimUtils.screenAnim(this.animTimer, 10, 0, 255);
                            this.r1.a = 255 - this.r2.a;
                            this.r1.t = this.f_96544_ - AnimUtils.screenAnim(this.animTimer, 10, 59, 0);
                        }
                    }
                    break;
                }
                case POSITIONING: {
                    offset = AnimUtils.screenAnim(this.animTimer, 10, 60, 0);
                    this.bgAlpha = AnimUtils.screenAnim(this.animTimer, 10, 128, 64);
                    this.menu.forEach(b -> b.m_253211_(AnimUtils.screenAnim(this.animTimer, 10, this.f_96544_ + 5, b.oY)));
                    this.pos.forEach(b -> b.m_253211_(AnimUtils.screenAnim(this.animTimer, 10, b.oY, b.oY + 48)));
                    int w = AnimUtils.screenAnim(this.animTimer, 10, 94, 0);
                    this.r2.l = this.f_96543_ / 2 - w;
                    this.r2.r = this.f_96543_ / 2 + w;
                    this.r2.a = AnimUtils.screenAnim(this.animTimer, 10, 255, 0);
                    this.r1.a = 255 - this.r2.a;
                    this.r1.t = this.f_96544_ - AnimUtils.screenAnim(this.animTimer, 10, 0, 59);
                }
            }
        }
    }

    private void renderGrid(Matrix4f g) {
        int s = 0;
        int tWidth = this.f_96543_ / 2;
        int tHeight = this.f_96544_ / 2;
        int check = Math.max(tWidth, tHeight);
        int counter = 0;
        RenderUtils.vLine(g, tWidth, 0, this.f_96544_, -2236963);
        RenderUtils.hLine(g, tHeight, 0, this.f_96543_, -2236963);
        while (s < check) {
            int color;
            int n = color = ++counter % 4 == 0 ? 0x44FFFFFF : 0x15FFFFFF;
            if ((s += 8) < tWidth) {
                RenderUtils.vLine(g, tWidth + s, 0, this.f_96544_, color);
                RenderUtils.vLine(g, tWidth - s, 0, this.f_96544_, color);
            }
            if (s >= tHeight) continue;
            RenderUtils.hLine(g, tHeight + s, 0, this.f_96543_, color);
            RenderUtils.hLine(g, tHeight - s, 0, this.f_96543_, color);
        }
    }

    public void m_86600_() {
        --this.animTimer;
        if (this.animTimer <= 0) {
            this.animTimer = 0;
            this.animActive = false;
            this.changeState();
        }
        super.m_86600_();
    }

    public void m_7379_() {
        ColorAPI.setColorCycle(false);
        Parties.debug("Saving frame position and scale...", new Object[0]);
        Config.savePersistentPreset();
        RenderItem.enableRenderer();
        this.checkBorders();
        offset = 0;
        status = 0;
        Frame.forEach(Frame::deleteFakeData);
        super.m_7379_();
    }

    public void m_6574_(@NotNull Minecraft m, int w, int h) {
        this.f_96543_ = w;
        this.f_96544_ = h;
        this.resetButtonPositions();
        this.checkBorders();
        this.changeState();
    }

    public void m_232761_() {
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (Screen.m_96638_()) {
            return true;
        }
        if (pKeyCode != this.keyCode) {
            this.m_7379_();
            Minecraft.m_91087_().m_91152_(null);
        }
        return true;
    }

    public boolean m_6375_(double mX, double mY, int button) {
        if (!super.m_6375_(mX, mY, button)) {
            if (this.preparedState != ScreenState.POSITIONING) {
                Style style;
                if (this.preparedState == ScreenState.MAIN) {
                    Frame.getHoveredEffect((int)mX, (int)mY, effect -> JCompatManager.getHandler().onEffectClick((MobEffect)effect));
                }
                return (style = this.getClickedText(mX, mY)) != null && this.m_5561_(style);
            }
            this.updateSelectedFrame(Frame.getClickedFrame(mX, mY));
            return false;
        }
        return true;
    }

    public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
        this.m_7897_(false);
        this.draggingFrame = false;
        return super.m_6348_(p_94722_, p_94723_, p_94724_);
    }

    public boolean m_7979_(double mX, double mY, int button, double deltaX, double deltaY) {
        if (this.draggingFrame) {
            this.dX += deltaX;
            this.dY += deltaY;
            Frame.get(this.selectedFrame).setX((int)this.dX);
            Frame.get(this.selectedFrame).setY((int)this.dY);
        }
        return super.m_7979_(mX, mY, button, deltaX, deltaY);
    }

    private void updateSelectedFrame(Frame.Type t) {
        if (t == null) {
            return;
        }
        this.draggingFrame = true;
        if (t == this.selectedFrame) {
            return;
        }
        this.selectedFrame = t;
        this.dX = Frame.get(this.selectedFrame).trueX();
        this.dY = Frame.get(this.selectedFrame).trueY();
        this.enableButtonsIfFrameValid();
    }

    private void nextFrame() {
        if (this.selectedFrame == Frame.Type.PLAYER) {
            this.updateSelectedFrame(Frame.Type.PARTY);
        } else {
            this.updateSelectedFrame(Frame.Type.PLAYER);
        }
    }

    public static interface ScreenGetter {
        public Screen getScreen(int var1);
    }

    private static class Rect {
        int l;
        int r;
        int t;
        int b;
        int a;

        public Rect(int l, int r, int t, int b, int a) {
            this.l = l;
            this.r = r;
            this.t = t;
            this.b = b;
            this.a = a;
        }

        public void pos(int l, int r, int t, int b) {
            this.l = l;
            this.r = r;
            this.t = t;
            this.b = b;
        }
    }

    static enum ScreenState {
        MAIN,
        MENU,
        POSITIONING;

    }
}

