/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class InputBox
extends AbstractWidget {
    protected final Font font;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    protected int color;
    protected Predicate<String> filter = Objects::nonNull;
    @Nullable
    private Consumer<String> responder;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (p_94147_, p_94148_) -> FormattedCharSequence.m_13714_((String)p_94147_, (Style)Style.f_131099_);
    OnTextInput onInput;

    public InputBox(int color, Font pFont, int pWidth, int pHeight, Component pMessage, OnTextInput onInput, boolean numbersOnly) {
        super(0, 0, pWidth, pHeight, pMessage);
        this.font = pFont;
        this.color = color;
        this.onInput = onInput;
        if (numbersOnly) {
            this.filter = f -> Objects.nonNull(f) && this.isNumber((String)f);
        }
    }

    public InputBox(int maxSize, int color, Font pFont, int pWidth, int pHeight, Component pMessage, OnTextInput onInput, boolean numbersOnly) {
        super(0, 0, pWidth, pHeight, pMessage);
        this.maxLength = maxSize;
        this.font = pFont;
        this.color = color;
        this.onInput = onInput;
        if (numbersOnly) {
            this.filter = f -> Objects.nonNull(f) && this.isNumber((String)f);
        }
    }

    protected boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        ++this.frame;
    }

    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    protected void m_87963_(GuiGraphics guiGraphics, int i, int i1, float v) {
    }

    public void setValue(String pText) {
        if (this.filter.test(pText)) {
            this.value = pText.length() > this.maxLength ? pText.substring(0, this.maxLength) : pText;
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(pText);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void insertText(String pTextToWrite) {
        String s1;
        String s;
        int l;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (s = SharedConstants.m_136190_((String)pTextToWrite)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.filter.test(s1 = new StringBuilder(this.value).replace(i, j, s).toString())) {
            this.value = s1;
            this.setCursorPosition(i + l);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(this.value);
            if (!this.value.equals("")) {
                this.onInput.onInput(this.getValue());
            }
        }
    }

    private void onValueChange(String pNewText) {
        if (this.responder != null) {
            this.responder.accept(pNewText);
        }
    }

    private void deleteText(int pCount) {
        if (Screen.m_96637_()) {
            this.deleteWords(pCount);
        } else {
            this.deleteChars(pCount);
        }
    }

    public void deleteWords(int pNum) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(pNum) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int pNum) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(pNum);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(s = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = s;
                    this.moveCursorTo(j);
                    if (!this.value.equals("")) {
                        this.onInput.onInput(this.getValue());
                    }
                }
            }
        }
    }

    public int getWordPosition(int pNumWords) {
        return this.getWordPosition(pNumWords, this.getCursorPosition());
    }

    private int getWordPosition(int pN, int pPos) {
        return this.getWordPosition(pN, pPos, true);
    }

    private int getWordPosition(int pN, int pPos, boolean pSkipWs) {
        int i = pPos;
        boolean flag = pN < 0;
        int j = Math.abs(pN);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.value.length();
                if ((i = this.value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (pSkipWs && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (pSkipWs && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int pDelta) {
        this.moveCursorTo(this.getCursorPos(pDelta));
    }

    private int getCursorPos(int pDelta) {
        return Util.m_137479_((String)this.value, (int)this.cursorPos, (int)pDelta);
    }

    public void moveCursorTo(int pPos) {
        this.setCursorPosition(pPos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int pPos) {
        this.cursorPos = Mth.m_14045_((int)pPos, (int)0, (int)this.value.length());
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.m_96638_();
        if (Screen.m_96634_((int)pKeyCode)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.m_96632_((int)pKeyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            return true;
        }
        if (Screen.m_96630_((int)pKeyCode)) {
            if (this.isEditable) {
                this.insertText(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)pKeyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (pKeyCode) {
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)pCodePoint)) {
            if (this.isEditable) {
                this.insertText(Character.toString(pCodePoint));
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.isVisible()) {
            return false;
        }
        return false;
    }

    public void setFocus(boolean pIsFocused) {
        this.m_93692_(pIsFocused);
    }

    public void renderButton(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isVisible()) {
            boolean flag2;
            boolean flag1;
            int i2 = this.isEditable ? (this.m_93696_() ? 0xFFFF55 : this.color) : 0xAAAAAA;
            int j = this.cursorPos - this.displayPos;
            int k = this.highlightPos - this.displayPos;
            String s = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean bl = flag1 = this.m_93696_() && this.frame / 6 % 2 == 0 && flag;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                RenderSystem.enableDepthTest();
            }
            boolean bl2 = flag2 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            if (!flag || flag2) {
                // empty if block
            }
            if (s.isEmpty() || !flag || j < s.length()) {
                // empty if block
            }
            if (!flag1 || flag2) {
                // empty if block
            }
            if (k != j) {
                // empty if block
            }
        }
    }

    private void renderHighlight(int pStartX, int pStartY, int pEndX, int pEndY) {
        if (pStartX < pEndX) {
            int i = pStartX;
            pStartX = pEndX;
            pEndX = i;
        }
        if (pStartY < pEndY) {
            int j = pStartY;
            pStartY = pEndY;
            pEndY = j;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_5483_((double)pStartX, (double)pEndY, 0.0).m_5752_();
        bufferbuilder.m_5483_((double)pEndX, (double)pEndY, 0.0).m_5752_();
        bufferbuilder.m_5483_((double)pEndX, (double)pStartY, 0.0).m_5752_();
        bufferbuilder.m_5483_((double)pStartX, (double)pStartY, 0.0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
    }

    public void setMaxLength(int pLength) {
        this.maxLength = pLength;
        if (this.value.length() > pLength) {
            this.value = this.value.substring(0, pLength);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        return false;
    }

    protected void onFocusedChanged(boolean pFocused) {
        if (pFocused) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean pEnabled) {
        this.isEditable = pEnabled;
    }

    public int getInnerWidth() {
        return this.f_93618_;
    }

    public void setHighlightPos(int pPosition) {
        int i = this.value.length();
        this.highlightPos = Mth.m_14045_((int)pPosition, (int)0, (int)i);
        if (this.font != null) {
            if (this.displayPos > i) {
                this.displayPos = i;
            }
            int j = this.getInnerWidth();
            String s = this.font.m_92834_(this.value.substring(this.displayPos), j);
            int k = s.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.font.m_92837_(this.value, j, true).length();
            }
            if (this.highlightPos > k) {
                this.displayPos += this.highlightPos - k;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = Mth.m_14045_((int)this.displayPos, (int)0, (int)i);
        }
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean pIsVisible) {
        this.f_93624_ = pIsVisible;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void setColor(int color) {
        this.color = color;
    }

    public static interface OnTextInput {
        public void onInput(String var1);
    }
}

