/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.api.helper.ColorAPI;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.gui.HexBox;
import io.sedu.mc.parties.client.overlay.gui.InputBox;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.client.overlay.gui.SliderButton;
import io.sedu.mc.parties.client.overlay.gui.SmallButton;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ConfigOptionsList {
    SettingsScreen s;
    EntryColor entryColor;
    ArrayList<SliderEntry> sliders = new ArrayList();
    private final boolean parsing;

    public ConfigOptionsList(EntryColor color, SettingsScreen s, Minecraft pMinecraft, int x, int y, int w, int h, boolean parsing) {
        this.entryColor = color;
        this.s = s;
        s.resetTickables();
        this.parsing = parsing;
    }

    public Entry addTitleEntry(String title) {
        TitleEntry e = new TitleEntry(title);
        return e;
    }

    public void addPresetEntry(String file, String description, boolean isDefault) {
        PresetEntry e = new PresetEntry(file, description, isDefault);
    }

    public Entry addBooleanEntry(String name, boolean defaultState) {
        CheckboxEntry e = new CheckboxEntry(name, defaultState);
        return e;
    }

    public Entry addBooleanEntry(String name, boolean defaultState, Entry.OuterUpdate toggleLimSliders) {
        CheckboxEntry e = new CheckboxEntry(name, defaultState);
        e.outerUpdate = toggleLimSliders;
        return e;
    }

    public Entry addSliderEntry(String name, int lowBound, SliderEntry.Bound upBound, int defaultState) {
        SliderEntry e = new SliderEntry(name, lowBound, upBound, defaultState);
        this.sliders.add(e);
        return e;
    }

    public void addSliderEntry(String name, int lowBound, SliderEntry.Bound upBound, int defaultState, boolean doesRefresh) {
        SliderEntry e = new SliderEntry(name, lowBound, upBound, defaultState, doesRefresh);
        this.sliders.add(e);
    }

    public SliderEntry addSliderWithUpdater(String name, int lowBound, SliderEntry.Bound upBound, int defaultState, Entry.OuterUpdate sliderUpdate, boolean refresh) {
        SliderEntry e = new SliderEntry(name, lowBound, upBound, defaultState, refresh);
        e.outerUpdate = sliderUpdate;
        return e;
    }

    public void addColorEntry(String name, int defaultState) {
        HexBoxEntry e = new HexBoxEntry(name, defaultState);
    }

    public void addSpaceEntry() {
    }

    protected void markDirty() {
    }

    public void markSlidersDirty() {
        this.sliders.forEach(Entry::updateValues);
    }

    public static interface EntryColor {
        public int getColor();
    }

    public class TitleEntry
    extends Entry {
        private int x;

        TitleEntry(String title) {
            this.name = Component.m_237115_((String)("config.sedparties.title." + title));
            this.markDirty();
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput p_193906_) {
                    p_193906_.m_169146_(NarratedElementType.TITLE, TitleEntry.this.name);
                }
            });
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @Override
        void toggle(boolean enabled) {
        }

        @Override
        void updateValues(int pTop, int pLeft, int pWidth, int pHeight) {
        }

        @Override
        void updateValues() {
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            if (this.isDirty) {
                this.updateValues(pTop, pLeft, pWidth, pHeight);
                this.isDirty = false;
            }
        }
    }

    public class PresetEntry
    extends Entry {
        private int x;
        private String fileName;
        private String descTrimmed;
        private Button loadPreset;
        private Button deletePreset;

        PresetEntry(String file, String desc, boolean isDefault) {
            this.fileName = file;
            this.desc = desc;
            this.name = Component.m_237113_((String)this.fileName);
            this.loadPreset = new SmallButton(0, 0, "\u2b07", pButton -> {}, RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.loadpresetb")), 0.5f, 1.0f, 0.5f, 0.5f);
            this.deletePreset = new SmallButton(0, 0, "x", pButton -> ConfigOptionsList.this.s.selectButton(-1), RenderUtils.transTip(Component.m_237115_((String)"gui.sedparties.tooltip.delpresetb")), 1.0f, 0.5f, 0.5f, 0.5f);
            this.deletePreset.f_93623_ = !isDefault;
            this.markDirty();
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput p_193906_) {
                    p_193906_.m_169146_(NarratedElementType.TITLE, PresetEntry.this.name);
                }
            });
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.loadPreset, (Object)this.deletePreset);
        }

        @Override
        void toggle(boolean enabled) {
        }

        @Override
        void updateValues(int pTop, int pLeft, int pWidth, int pHeight) {
            this.x = pLeft + 4;
            this.descTip = RenderUtils.splitTooltip(this.desc, pWidth / 5, false, false);
            this.descTrimmed = this.desc.substring(0, Math.min(this.desc.length(), (pWidth - 32) / 6));
            if (this.descTrimmed.length() != this.desc.length()) {
                this.descTrimmed = this.descTrimmed + "...";
            }
        }

        @Override
        void updateValues() {
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            if (this.isDirty) {
                this.updateValues(pTop, pLeft, pWidth, pHeight);
                this.isDirty = false;
            }
            if (pIsMouseOver) {
                // empty if block
            }
        }
    }

    public class CheckboxEntry
    extends Entry {
        private boolean isEnabled;
        private SmallButton enable;
        private SmallButton disable;

        CheckboxEntry(String name, boolean isEnabled) {
            if (ConfigOptionsList.this.parsing) {
                RenderItem.parser.add(name);
                return;
            }
            this.name = Component.m_237115_((String)("config.sedparties.name." + name));
            this.isEnabled = isEnabled;
            this.disable = new SmallButton(0, 0, "\u2713", pButton -> this.updateVal(false), RenderUtils.transTip(Component.m_237115_((String)"config.sedparties.tooltip.enableb")), 0.5f, 1.0f, 0.5f, 0.5f);
            this.enable = new SmallButton(0, 0, "x", pButton -> this.updateVal(true), RenderUtils.transTip(Component.m_237115_((String)"config.sedparties.tooltip.disableb")), 1.0f, 0.5f, 0.5f, 0.5f);
            this.enable.f_93624_ = !isEnabled;
            this.disable.f_93624_ = isEnabled;
            this.internal = name;
            this.desc = Component.m_237115_((String)("config.sedparties.tooltip." + name)).getString();
        }

        CheckboxEntry(String name, boolean isEnabled, boolean refreshes) {
            this(name, isEnabled);
            this.doesRefresh = refreshes;
        }

        @Override
        void toggle(boolean enabled) {
            this.enable.f_93623_ = enabled;
            this.disable.f_93623_ = enabled;
        }

        private void updateVal(boolean enabled) {
            ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), enabled, this.doesRefresh);
            if (this.outerUpdate != null) {
                this.outerUpdate.outerUpdate();
            }
            this.isEnabled = enabled;
            this.enable.f_93624_ = !this.isEnabled;
            this.disable.f_93624_ = this.isEnabled;
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput p_193906_) {
                    p_193906_.m_169146_(NarratedElementType.TITLE, CheckboxEntry.this.name);
                }
            });
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.enable), (Object)((Object)this.disable));
        }

        @Override
        void updateValues(int pTop, int pLeft, int pWidth, int pHeight) {
            this.descTip = RenderUtils.splitTooltip(this.desc, pWidth / 5, false, false);
        }

        @Override
        void updateValues() {
        }

        @Override
        void updateData(Object data) {
            this.updateVal((Boolean)data);
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            if (this.isDirty) {
                this.updateValues(pTop, pLeft, pWidth, pHeight);
                this.isDirty = false;
            }
            if (pIsMouseOver) {
                // empty if block
            }
        }
    }

    public abstract class Entry {
        String internal = "";
        Component name;
        boolean isDirty;
        boolean doesRefresh = false;
        OuterUpdate outerUpdate;
        String desc;
        List<Component> descTip;

        public void setVisible(boolean enabled) {
            if (ConfigOptionsList.this.parsing) {
                return;
            }
            this.toggle(enabled);
        }

        abstract void toggle(boolean var1);

        abstract void updateValues(int var1, int var2, int var3, int var4);

        abstract void updateValues();

        void updateData(Object data) {
        }

        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            if (this.isDirty) {
                this.updateValues(pTop, pLeft, pWidth, pHeight);
                this.isDirty = false;
            }
            if (pIsMouseOver) {
                // empty if block
            }
        }

        public void markDirty() {
            this.isDirty = true;
        }

        protected String getConfigName() {
            return this.internal;
        }

        public static interface OuterUpdate {
            public void outerUpdate();
        }
    }

    public class SliderEntry
    extends Entry {
        private InputBox input;
        private SliderButton slider;
        private int lowBound;
        private int upBound;
        private int boundWidth;
        private int value;
        private Bound maxBound;

        SliderEntry(String name, int lowBound, Bound maxBound, int currentValue) {
            if (ConfigOptionsList.this.parsing) {
                RenderItem.parser.add(name);
                return;
            }
            this.name = Component.m_237115_((String)("config.sedparties.name." + name));
            this.lowBound = lowBound;
            this.maxBound = maxBound;
            this.value = currentValue;
            this.upBound = maxBound.updateBound();
            this.boundWidth = this.upBound - lowBound;
            ConfigOptionsList.this.s.addTickableEntry(this.input);
            this.markDirty();
            this.internal = name;
            this.desc = Component.m_237115_((String)("config.sedparties.tooltip." + name)).getString();
        }

        SliderEntry(String name, int lowBound, Bound maxBound, int currentValue, boolean doesRefresh) {
            this(name, lowBound, maxBound, currentValue);
            this.doesRefresh = doesRefresh;
        }

        @Override
        void toggle(boolean enabled) {
            this.input.f_93624_ = enabled;
            this.slider.f_93623_ = enabled;
        }

        private void updateVal(float percent) {
            if (this.updateActualValue(percent)) {
                ConfigOptionsList.this.s.triggerUpdate(this.getConfigName(), this.value);
                if (this.outerUpdate != null) {
                    this.outerUpdate.outerUpdate();
                }
            }
        }

        private void updateInputVal(String text) {
            int upVal = Mth.m_14045_((int)Integer.parseInt(text), (int)this.lowBound, (int)this.upBound);
            if (this.value != upVal) {
                this.value = upVal;
                this.slider.updateValue((float)(this.value - this.lowBound) / (float)this.boundWidth);
                ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), this.value, this.doesRefresh);
            }
            this.input.setValue(String.valueOf(upVal));
        }

        private boolean updateActualValue(float percent) {
            int upVal = Math.round((float)this.lowBound + (float)this.boundWidth * percent);
            if (this.value != upVal) {
                this.value = upVal;
                this.input.setValue(String.valueOf(this.value));
                return true;
            }
            return false;
        }

        private void finalizeVal(float percent) {
            ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), this.value, this.doesRefresh);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput p_193906_) {
                    p_193906_.m_169146_(NarratedElementType.TITLE, SliderEntry.this.name);
                }
            });
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.slider), (Object)((Object)this.input));
        }

        @Override
        void updateValues(int pTop, int pLeft, int pWidth, int pHeight) {
            this.slider.rightBound = pLeft + pWidth - 50;
            this.slider.boundWidth = this.slider.rightBound - this.slider.leftBound;
            this.descTip = RenderUtils.splitTooltip(this.desc, pWidth / 5, false, false);
            this.updateValues();
        }

        @Override
        void updateValues() {
            this.upBound = this.maxBound.updateBound();
            this.boundWidth = this.upBound - this.lowBound;
            this.slider.f_93624_ = this.boundWidth > 0;
            this.updateData(this.value);
            this.updateSliderPosition();
        }

        public SliderEntry forceUpdate(int data) {
            this.upBound = this.maxBound.updateBound();
            this.boundWidth = this.upBound - this.lowBound;
            this.slider.f_93624_ = this.boundWidth > 0;
            this.value = data;
            this.input.setValue(String.valueOf(data));
            this.updateSliderPosition();
            return this;
        }

        @Override
        void updateData(Object data) {
            int upVal = Mth.m_14045_((int)((Integer)data), (int)this.lowBound, (int)this.upBound);
            if (this.value != upVal) {
                this.value = upVal;
                this.slider.updateValue((float)(this.value - this.lowBound) / (float)this.boundWidth);
                ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), this.value, this.doesRefresh);
            }
            this.input.setValue(String.valueOf(upVal));
        }

        private void updateSliderPosition() {
            this.slider.updateValue((float)(this.value - this.lowBound) / (float)this.boundWidth);
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            if (this.isDirty) {
                this.updateValues(pTop, pLeft, pWidth, pHeight);
                this.isDirty = false;
            }
            if (pIsMouseOver) {
                // empty if block
            }
            this.slider.updateX();
            this.slider.color = ConfigOptionsList.this.entryColor.getColor();
        }

        public static interface Bound {
            public int updateBound();
        }
    }

    public class HexBoxEntry
    extends Entry {
        private HexBox input;
        private InputBox r;
        private InputBox g;
        private InputBox b;
        private int value;
        private int rI;
        private int gI;
        private int bI;

        HexBoxEntry(String pName, int currentValue) {
            if (ConfigOptionsList.this.parsing) {
                RenderItem.parser.add(pName);
                return;
            }
            this.name = Component.m_237115_((String)("config.sedparties.name." + pName));
            this.value = currentValue;
            this.updateIndValues();
            if (currentValue == 0) {
                this.input.setValue("");
            } else {
                this.finalizeAndGetValue();
            }
            ConfigOptionsList.this.s.addTickableEntry(this.input);
            ConfigOptionsList.this.s.addTickableEntry(this.r);
            ConfigOptionsList.this.s.addTickableEntry(this.g);
            ConfigOptionsList.this.s.addTickableEntry(this.b);
            this.markDirty();
            this.internal = pName;
            this.desc = Component.m_237115_((String)("config.sedparties.tooltip." + pName)).getString();
        }

        private void updateRVal(String text) {
            int upVal = Mth.m_14045_((int)Integer.parseInt(text), (int)0, (int)255);
            if (this.rI != upVal) {
                this.rI = upVal;
                ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), this.finalizeAndGetValue(), this.doesRefresh);
            }
            this.r.setValue(String.valueOf(upVal));
        }

        private int finalizeAndGetValue() {
            this.value = this.rI;
            this.value = (this.value << 8) + this.gI;
            this.value = (this.value << 8) + this.bI;
            this.updateComValue();
            return this.value;
        }

        private void updateGVal(String text) {
            int upVal = Mth.m_14045_((int)Integer.parseInt(text), (int)0, (int)255);
            if (this.gI != upVal) {
                this.gI = upVal;
                ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), this.finalizeAndGetValue(), this.doesRefresh);
            }
            this.g.setValue(String.valueOf(upVal));
        }

        private void updateBVal(String text) {
            int upVal = Mth.m_14045_((int)Integer.parseInt(text), (int)0, (int)255);
            if (this.bI != upVal) {
                this.bI = upVal;
                ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), this.finalizeAndGetValue(), this.doesRefresh);
            }
            this.b.setValue(String.valueOf(upVal));
        }

        private void updateComValue() {
            this.input.setValue(Integer.toHexString(this.value));
        }

        private void updateInputVal(int num) {
            if (this.value != num) {
                this.value = num;
                ConfigOptionsList.this.s.finalizeUpdate(this.getConfigName(), this.value, this.doesRefresh);
                this.updateIndValues();
            }
        }

        private void updateIndValues() {
            this.rI = ColorAPI.getRI(this.value);
            this.gI = ColorAPI.getGI(this.value);
            this.bI = ColorAPI.getBI(this.value);
            this.r.setValue(String.valueOf(this.rI));
            this.g.setValue(String.valueOf(this.gI));
            this.b.setValue(String.valueOf(this.bI));
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput p_193906_) {
                    p_193906_.m_169146_(NarratedElementType.TITLE, HexBoxEntry.this.name);
                }
            });
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.input), (Object)((Object)this.r), (Object)((Object)this.g), (Object)((Object)this.b));
        }

        @Override
        void toggle(boolean enabled) {
            this.input.f_93624_ = enabled;
            this.r.f_93624_ = enabled;
            this.g.f_93624_ = enabled;
            this.b.f_93624_ = enabled;
        }

        @Override
        void updateValues(int pTop, int pLeft, int pWidth, int pHeight) {
            if (HexBox.rgbMode) {
                this.input.f_93624_ = false;
                this.r.f_93624_ = true;
                this.g.f_93624_ = true;
                this.b.f_93624_ = true;
            } else {
                this.input.f_93624_ = true;
                this.r.f_93624_ = false;
                this.g.f_93624_ = false;
                this.b.f_93624_ = false;
            }
            int inWidth = Math.max(15, pWidth >> 3);
            this.r.m_93674_(inWidth);
            this.g.m_93674_(inWidth);
            this.b.m_93674_(inWidth);
            this.descTip = RenderUtils.splitTooltip(this.desc, pWidth / 5, false, false);
        }

        @Override
        void updateValues() {
        }

        @Override
        void updateData(Object data) {
            this.value = (Integer)data;
            this.updateIndValues();
            this.updateComValue();
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            if (this.isDirty) {
                this.updateValues(pTop, pLeft, pWidth, pHeight);
                this.isDirty = false;
            }
            if (pIsMouseOver) {
                // empty if block
            }
            int color = ConfigOptionsList.this.entryColor.getColor();
        }
    }

    public class SpaceEntry
    extends Entry {
        SpaceEntry() {
            this.name = Component.m_237113_((String)"");
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.NONE;
                }

                public void m_142291_(NarrationElementOutput p_193906_) {
                }
            });
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @Override
        void toggle(boolean enabled) {
        }

        @Override
        void updateValues(int pTop, int pLeft, int pWidth, int pHeight) {
        }

        @Override
        void updateValues() {
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
        }
    }
}

