/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.effects;

import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.PEffectsBoth;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.effects.ClientEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.effect.MobEffect;

public class EffectHolder {
    HashMap<Integer, ClientEffect> effects = new HashMap();
    public List<Integer> sortedEffectAll = new ArrayList<Integer>();
    public List<Integer> sortedEffectBene = new ArrayList<Integer>();
    public List<Integer> sortedEffectBad = new ArrayList<Integer>();

    public static void setValues(int buff, int debuff, boolean dFirst) {
        PEffectsBoth.bLim = buff;
        PEffectsBoth.dLim = debuff;
        PEffectsBoth.debuffFirst = dFirst;
    }

    public boolean getEffect(int maxSize, List<Integer> sortedEffects, int buffIndex, Consumer<ClientEffect> action) {
        if (buffIndex < sortedEffects.size()) {
            if (buffIndex == maxSize - 1) {
                if (sortedEffects.size() > maxSize) {
                    return true;
                }
                action.accept(this.effects.get(sortedEffects.get(buffIndex)));
            } else {
                action.accept(this.effects.get(sortedEffects.get(buffIndex)));
            }
        }
        return false;
    }

    public static RenderItem.SmallBound updatebLim(int data) {
        PEffectsBoth.bLim = data;
        PEffectsBoth.dLim = PEffectsBoth.maxAll - 1 - data;
        ClientPlayerData.markEffectsDirty();
        return null;
    }

    public static RenderItem.SmallBound updatedLim(int data) {
        PEffectsBoth.dLim = data;
        PEffectsBoth.bLim = PEffectsBoth.maxAll - 1 - data;
        ClientPlayerData.markEffectsDirty();
        return null;
    }

    public void forEachAll(Consumer<ClientEffect> action) {
        this.sortedEffectAll.forEach(integer -> action.accept(this.effects.get(integer)));
    }

    public void forEachAllLim(int max, Consumer<ClientEffect> action) {
        for (int i = 0; i < max - 1; ++i) {
            action.accept(this.effects.get(this.sortedEffectAll.get(i)));
        }
    }

    public void forEachBeneLim(int max, Consumer<ClientEffect> action) {
        for (int i = 0; i < max - 1; ++i) {
            action.accept(this.effects.get(this.sortedEffectBene.get(i)));
        }
    }

    public void forEachBadLim(int max, Consumer<ClientEffect> action) {
        for (int i = 0; i < max - 1; ++i) {
            action.accept(this.effects.get(this.sortedEffectBad.get(i)));
        }
    }

    public void forAllRemainder(int max, Consumer<ClientEffect> action) {
        for (int i = max - 1; i < this.sortedEffectAll.size(); ++i) {
            action.accept(this.effects.get(this.sortedEffectAll.get(i)));
        }
    }

    public void forBeneRemainder(int max, Consumer<ClientEffect> action) {
        for (int i = max - 1; i < this.sortedEffectBene.size(); ++i) {
            action.accept(this.effects.get(this.sortedEffectBene.get(i)));
        }
    }

    public void forBadRemainder(int max, Consumer<ClientEffect> action) {
        for (int i = max - 1; i < this.sortedEffectBad.size(); ++i) {
            action.accept(this.effects.get(this.sortedEffectBad.get(i)));
        }
    }

    public int sizeAll() {
        return this.sortedEffectAll.size();
    }

    public int sizeBene() {
        return this.sortedEffectBene.size();
    }

    public int sizeBad() {
        return this.sortedEffectBad.size();
    }

    public void forEachBene(Consumer<ClientEffect> action) {
        Objects.requireNonNull(action);
        this.sortedEffectBene.forEach(integer -> action.accept(this.effects.get(integer)));
    }

    public void forEachBad(Consumer<ClientEffect> action) {
        Objects.requireNonNull(action);
        this.sortedEffectBad.forEach(integer -> action.accept(this.effects.get(integer)));
    }

    public void set(int type, int duration, int amp) {
        if (this.effects.get(type) == null) {
            this.effects.put(type, new ClientEffect(type, duration, amp));
            this.addVal(type);
        } else {
            this.effects.get(type).setEffect(duration, amp);
            this.sort();
        }
    }

    public void setInfinite(int type, int amp) {
        this.set(type, 100, amp);
        this.effects.get(type).setInfinite();
    }

    public void refresh() {
        if (PEffectsBoth.prioDur) {
            this.sortAll();
        } else {
            this.sortRefresh();
        }
    }

    private void sortRefresh() {
        this.sortedEffectAll.clear();
        if (this.sortedEffectBad.size() + this.sortedEffectBene.size() > PEffectsBoth.maxAll) {
            if (PEffectsBoth.debuffFirst) {
                int i;
                int mx = Math.max(PEffectsBoth.dLim, PEffectsBoth.maxAll - this.sortedEffectBene.size() - 1);
                for (i = 0; i < mx && i < this.sortedEffectBad.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBad.get(i));
                }
                for (i = 0; i < PEffectsBoth.bLim && i < this.sortedEffectBene.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBene.get(i));
                }
                for (i = mx; i < this.sortedEffectBad.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBad.get(i));
                }
                for (i = PEffectsBoth.bLim; i < this.sortedEffectBene.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBene.get(i));
                }
            } else {
                int i;
                int mx = Math.max(PEffectsBoth.bLim, PEffectsBoth.maxAll - this.sortedEffectBad.size() - 1);
                for (i = 0; i < mx && i < this.sortedEffectBene.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBene.get(i));
                }
                for (i = 0; i < PEffectsBoth.dLim && i < this.sortedEffectBad.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBad.get(i));
                }
                for (i = mx; i < this.sortedEffectBene.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBene.get(i));
                }
                for (i = PEffectsBoth.dLim; i < this.sortedEffectBad.size(); ++i) {
                    this.sortedEffectAll.add(this.sortedEffectBad.get(i));
                }
            }
        } else if (PEffectsBoth.debuffFirst) {
            this.sortedEffectAll.addAll(this.sortedEffectBad);
            this.sortedEffectAll.addAll(this.sortedEffectBene);
        } else {
            this.sortedEffectAll.addAll(this.sortedEffectBene);
            this.sortedEffectAll.addAll(this.sortedEffectBad);
        }
    }

    private void sort() {
        this.sortBene();
        this.sortBad();
        this.refresh();
    }

    private void addVal(int type) {
        this.sortedEffectAll.add(type);
        if (Objects.requireNonNull(MobEffect.m_19453_((int)type)).m_19486_()) {
            this.sortedEffectBene.add(type);
        } else {
            this.sortedEffectBad.add(type);
        }
        this.sort();
    }

    private void sortBad() {
        this.sort(this.sortedEffectBad);
    }

    private void sortBene() {
        this.sort(this.sortedEffectBene);
    }

    private void sortAll() {
        this.sort(this.sortedEffectAll);
    }

    public void sort(List<Integer> array) {
        for (int i = 1; i < array.size(); ++i) {
            int j;
            Integer tmp = array.get(i);
            for (j = i; j > 0 && this.leftMoreThanRight(array.get(j - 1), tmp); --j) {
                array.set(j, array.get(j - 1));
            }
            array.set(j, tmp);
        }
    }

    public boolean leftMoreThanRight(int left, int right) {
        if (this.effects.get(left).isInstant() && !this.effects.get(right).isInstant()) {
            return false;
        }
        if (this.effects.get(right).isInstant() && !this.effects.get(left).isInstant()) {
            return true;
        }
        if (this.effects.get(right).isInstant() && this.effects.get(left).isInstant()) {
            return !this.effects.get(right).bene() && this.effects.get(left).bene();
        }
        if (this.effects.get((Object)Integer.valueOf((int)left)).cur.duration > this.effects.get((Object)Integer.valueOf((int)right)).cur.duration) {
            return true;
        }
        return this.effects.get((Object)Integer.valueOf((int)left)).cur.duration == this.effects.get((Object)Integer.valueOf((int)right)).cur.duration && !this.effects.get(right).bene() && this.effects.get(left).bene();
    }

    public boolean removeIf(Predicate<ClientEffect> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<ClientEffect> each = this.effects.values().iterator();
        while (each.hasNext()) {
            ClientEffect e = each.next();
            if (!filter.test(e)) continue;
            this.remove(e.bene(), e.getId());
            each.remove();
            removed = true;
        }
        if (removed) {
            this.sort();
        }
        return removed;
    }

    private void remove(boolean beneficial, Integer id) {
        this.sortedEffectAll.remove(id);
        if (beneficial) {
            this.sortedEffectBene.remove(id);
        } else {
            this.sortedEffectBad.remove(id);
        }
    }

    public void markForRemoval(int type) {
        if (this.effects.get(type) != null && !this.effects.get(type).isInstant()) {
            this.effects.get(type).markForRemoval();
        }
    }

    public void markForRemoval() {
        this.effects.values().forEach(ClientEffect::markForRemoval);
    }

    public boolean largerAll(int max) {
        return this.sortedEffectAll.size() > max;
    }

    public boolean largerBene(int max) {
        return this.sortedEffectBene.size() > max;
    }

    public boolean largerBad(int max) {
        return this.sortedEffectBad.size() > max;
    }
}

