/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.effects;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.data.config.ClientConfigData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public class ClientEffect {
    private final MobEffect type;
    private String display;
    private String roman;
    private String romanTrimmed;
    private int offset;
    boolean removal = false;
    boolean infinite = false;
    Effect cur;

    public void setEffect(int duration, int amp) {
        this.cur.duration = this.isInstant() ? 1 : duration;
        this.cur.amp = amp;
        this.roman = ClientEffect.roman(this.cur.amp);
        this.romanTrimmed = this.romanT(this.cur.amp);
        this.calculate();
        this.removal = false;
    }

    private String romanT(int amp) {
        if (amp == 0) {
            return "";
        }
        if (amp > 9) {
            return "\u2605";
        }
        return this.roman;
    }

    public boolean isInstant() {
        return this.type == MobEffects.f_19601_ || this.type == MobEffects.f_19602_;
    }

    public boolean bene() {
        return this.type.m_19486_();
    }

    public String getRomanTrimmed() {
        return this.romanTrimmed;
    }

    public boolean isDying() {
        return this.cur.duration < 10;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public String getRoman() {
        return this.roman;
    }

    public int getDur() {
        return this.cur.duration;
    }

    public void setInfinite() {
        this.infinite = true;
    }

    private int tick() {
        this.cur.internalTick();
        if (this.infinite) {
            return 1;
        }
        return this.cur.duration;
    }

    public ClientEffect(int type, int duration, int amp) {
        Parties.debug("Duration: " + duration, new Object[0]);
        this.type = MobEffect.m_19453_((int)type);
        this.cur = new Effect(duration, amp);
        this.roman = ClientEffect.roman(this.cur.amp);
        this.romanTrimmed = this.romanT(this.cur.amp);
        if (this.isInstant()) {
            this.cur.duration = 1;
            return;
        }
        this.cur.duration = duration;
        this.calculate();
    }

    private static String roman(int num) {
        ++num;
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] romanLetters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                num -= values[i];
                roman.append(romanLetters[i]);
            }
        }
        return roman.toString();
    }

    private void calculate() {
        if (this.isInstant()) {
            return;
        }
        if (this.infinite) {
            return;
        }
        if (this.cur.expired) {
            return;
        }
        if (this.cur.duration < 60) {
            this.updateVal(1, 's');
        } else if (this.cur.duration < 3600) {
            this.updateVal(60, 'm');
        } else if (this.cur.duration < 86400) {
            this.updateVal(3600, 'h');
        } else if (this.cur.duration < 604800) {
            this.updateVal(86400, 'd');
        } else if (this.cur.duration < 31536000) {
            this.updateVal(604800, 'w');
        } else {
            this.updateVal(31536000, 'y');
        }
    }

    public MobEffect getEffect() {
        return this.type;
    }

    public int getId() {
        return MobEffect.m_19459_((MobEffect)this.type);
    }

    private void updateVal(int divisor, char type) {
        this.display = String.valueOf(this.cur.duration / divisor) + type;
        this.offset = this.display.length() == 3 ? -3 : 0;
    }

    public String getDisplay() {
        return this.display;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean update() {
        if (this.tick() > 0) {
            this.calculate();
        } else {
            this.display = "";
            if (this.isInstant() || ((Boolean)ClientConfigData.endPotionEffects.get()).booleanValue()) {
                this.removal = true;
            }
        }
        return this.removal;
    }

    public void markForRemoval() {
        if (!this.isInstant()) {
            this.removal = true;
        }
    }

    class Effect {
        int duration;
        boolean expired = false;
        int amp;

        public Effect(int duration, int amp) {
            this.duration = duration;
            this.amp = amp;
        }

        private void internalTick() {
            if (this.expired) {
                return;
            }
            if (!ClientEffect.this.infinite) {
                --this.duration;
            }
            if (this.duration < 0) {
                this.duration = 0;
                this.expired = true;
            }
        }
    }
}

