/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.anim;

import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;

public class ManaIAnim
extends AnimBarHandler {
    public static int type;
    public float oldH;
    public float curH = 0.0f;
    public int oldCur = 0;
    public int oldMax = 100;
    public boolean hInc = true;

    public ManaIAnim(int length, boolean enabled) {
        super(length);
        this.updateText();
    }

    public static RenderItem.SmallBound setTextType(int d) {
        type = d;
        ClientPlayerData.playerList.values().forEach(c -> c.getManaI(AnimBarHandler::updateText));
        return null;
    }

    public static int getTextType() {
        return type;
    }

    @Override
    void activateValues(Object ... data) {
        float b2;
        float b1 = ManaIAnim.getPercent(this.oldCur, this.oldMax);
        this.hInc = b1 < (b2 = ManaIAnim.getPercent((Integer)data[0], (Integer)data[1]));
        this.oldH = b1;
        this.curH = b2;
        this.cur = ((Integer)data[0]).intValue();
        this.max = ((Integer)data[1]).intValue();
        this.updateText();
    }

    @Override
    int getType() {
        return type;
    }

    @Override
    public void activate(Object ... data) {
        this.activateValues(data);
        this.animTime = this.length;
        this.active = true;
        animTickers.add(this);
    }

    @Override
    boolean tickAnim() {
        if (super.tickAnim()) {
            this.curH = 0.0f;
            this.oldH = 0.0f;
            this.oldCur = (int)this.cur;
            this.oldMax = (int)this.max;
            return true;
        }
        return false;
    }

    public void reset(int pCur, int pMax) {
        this.curH = ManaIAnim.getPercent(pCur, pMax);
        if (this.hInc) {
            if (this.curH < this.oldH) {
                this.hInc = false;
                this.animTime = 10;
            }
        } else if (this.curH > this.oldH) {
            this.hInc = true;
            this.animTime = 10;
        }
        if (this.animTime < 11) {
            this.animTime = 10;
        }
    }

    public float getPercent() {
        return this.cur / Math.max(this.cur, this.max);
    }

    public static float getPercent(int cur, int max) {
        return (float)cur * 1.0f / (float)Math.max(cur, max);
    }

    public void checkHealth(int data) {
        if (data != (int)this.cur) {
            if (!this.active) {
                this.activate(data, (int)this.max);
                return;
            }
            this.reset(data, (int)this.max);
            this.cur = data;
            this.updateText();
        }
    }

    public void checkMax(int data) {
        if ((float)data != this.max) {
            if (!this.active) {
                this.activate((int)this.cur, data);
                return;
            }
            this.reset((int)this.cur, data);
            this.max = data;
            this.updateText();
        }
    }

    public void checkValues(int currentMana, int maxMana) {
        if ((float)currentMana != this.cur || (float)maxMana != this.max) {
            if (!this.active) {
                this.activate(currentMana, maxMana);
                return;
            }
            this.reset(currentMana, maxMana);
            this.max = maxMana;
            this.cur = currentMana;
            this.updateText();
        }
    }
}

