/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.anim;

import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;

public class ManaAnim
extends AnimBarHandler {
    public static int type;
    public float oldH;
    public float curH = 0.0f;
    public float oldCur = 0.0f;
    public int oldMax = 100;
    public boolean hInc = true;

    public ManaAnim(int length, boolean enabled) {
        super(length);
        this.updateText();
    }

    public static RenderItem.SmallBound setTextType(int d) {
        type = d;
        ClientPlayerData.playerList.values().forEach(c -> c.getMana(AnimBarHandler::updateText));
        return null;
    }

    public static int getTextType() {
        return type;
    }

    @Override
    void activateValues(Object ... data) {
        float b2;
        float b1 = ManaAnim.getPercent(this.oldCur, this.oldMax);
        this.hInc = b1 < (b2 = ManaAnim.getPercent(((Float)data[0]).floatValue(), (Integer)data[1]));
        this.oldH = b1;
        this.curH = b2;
        this.cur = ((Float)data[0]).floatValue();
        this.max = ((Integer)data[1]).intValue();
        this.updateText();
    }

    @Override
    int getType() {
        return type;
    }

    @Override
    public void activate(Object ... data) {
        this.activateValues(data);
        this.animTime = this.length;
        this.active = true;
        animTickers.add(this);
    }

    @Override
    boolean tickAnim() {
        if (super.tickAnim()) {
            this.curH = 0.0f;
            this.oldH = 0.0f;
            this.oldCur = this.cur;
            this.oldMax = (int)this.max;
            return true;
        }
        return false;
    }

    public void reset(float pCur, int pMax) {
        this.curH = ManaAnim.getPercent(pCur, pMax);
        if (this.hInc) {
            if (this.curH < this.oldH) {
                this.hInc = false;
                this.animTime = 10;
            }
        } else if (this.curH > this.oldH) {
            this.hInc = true;
            this.animTime = 10;
        }
        if (this.animTime < 11) {
            this.animTime = 10;
        }
    }

    public float getPercent() {
        return this.cur / Math.max(this.cur, this.max);
    }

    public static float getPercent(float cur, int max) {
        return cur / Math.max(cur, (float)max);
    }

    public void checkHealth(float data) {
        if (data != this.cur) {
            if (!this.active) {
                this.activate(Float.valueOf(data), (int)this.max);
                return;
            }
            this.reset(data, (int)this.max);
            this.cur = data;
            this.updateText();
        }
    }

    public void checkMax(int data) {
        if ((float)data != this.max) {
            if (!this.active) {
                this.activate(Float.valueOf(this.cur), data);
                return;
            }
            this.reset(this.cur, data);
            this.max = data;
            this.updateText();
        }
    }

    public void checkValues(float currentMana, int maxMana) {
        if (currentMana != this.cur || (float)maxMana != this.max) {
            if (!this.active) {
                this.activate(Float.valueOf(currentMana), maxMana);
                return;
            }
            this.reset(currentMana, maxMana);
            this.max = maxMana;
            this.cur = currentMana;
            this.updateText();
        }
    }
}

