/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.anim;

import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;

public class HungerAnim
extends AnimBarHandler {
    public static int type;
    public float oldH;
    public float curH;
    public float oldA;
    public float curA = 0.0f;
    public float oldCur = 0.0f;
    public float oldMax = 20.0f;
    public float oldAbsorb = 0.0f;
    public boolean hInc = true;
    public boolean aInc = true;

    public HungerAnim(int length, boolean enabled) {
        super(length);
        this.updateText();
    }

    public static RenderItem.SmallBound setTextType(int d) {
        type = d;
        ClientPlayerData.playerList.values().forEach(c -> c.getHunger(AnimBarHandler::updateText));
        return null;
    }

    public static int getTextType() {
        return type;
    }

    @Override
    void activateValues(Object ... data) {
        float b2;
        float b1 = HungerAnim.getPercent(this.oldCur, this.oldMax, this.oldAbsorb);
        this.hInc = b1 < (b2 = HungerAnim.getPercent(((Float)data[0]).floatValue(), ((Float)data[1]).floatValue(), ((Float)data[2]).floatValue()));
        this.oldH = b1;
        this.curH = b2;
        if (((Float)data[2]).floatValue() > 0.0f) {
            b1 = HungerAnim.getPercentE(this.oldCur, this.oldMax, this.oldAbsorb);
            this.aInc = b1 < (b2 = HungerAnim.getPercentE(((Float)data[0]).floatValue(), ((Float)data[1]).floatValue(), ((Float)data[2]).floatValue()));
            this.oldA = b1;
            this.curA = b2;
        } else {
            this.curA = 0.0f;
            this.oldA = 0.0f;
        }
        this.cur = ((Float)data[0]).floatValue();
        this.max = ((Float)data[1]).floatValue();
        this.absorb = ((Float)data[2]).floatValue();
        this.updateText();
    }

    @Override
    int getType() {
        return type;
    }

    @Override
    public void activate(Object ... data) {
        this.activateValues(data);
        this.animTime = this.length;
        this.active = true;
        animTickers.add(this);
    }

    @Override
    boolean tickAnim() {
        if (super.tickAnim()) {
            this.curH = 0.0f;
            this.oldH = 0.0f;
            this.oldCur = this.cur;
            this.oldMax = this.max;
            this.oldAbsorb = this.absorb;
            return true;
        }
        return false;
    }

    public void checkAnim(float pCur, float pMax, float pAbsorb) {
        if (pCur != this.cur || pMax != this.max || pAbsorb != this.absorb) {
            if (!this.active) {
                this.activate(Float.valueOf(pCur), Float.valueOf(pMax), Float.valueOf(pAbsorb));
                return;
            }
            this.reset(pCur, pMax, pAbsorb);
            this.cur = pCur;
            this.max = pMax;
            this.absorb = pAbsorb;
            this.updateText();
        }
    }

    public void reset(float pCur, float pMax, float pAbsorb) {
        this.curH = HungerAnim.getPercent(pCur, pMax, pAbsorb);
        if (this.hInc) {
            if (this.curH < this.oldH) {
                this.hInc = false;
                this.animTime = 10;
            }
        } else if (this.curH > this.oldH) {
            this.hInc = true;
            this.animTime = 10;
        }
        if (pAbsorb > 0.0f) {
            this.curA = HungerAnim.getPercentE(pCur, pMax, pAbsorb);
        } else if (this.curA == this.oldA) {
            this.oldAbsorb = pAbsorb;
        }
        if (this.animTime < 11) {
            this.animTime = 10;
        }
    }

    public float getPercent() {
        return this.cur / Math.max(this.absorb + this.cur, this.max);
    }

    public float getPercentE() {
        return (this.cur + this.absorb) / Math.max(this.absorb + this.cur, this.max);
    }

    public float getPercentA() {
        return this.absorb / Math.max(this.absorb + this.cur, this.max);
    }

    public static float getPercent(float cur, float max, float absorb) {
        return cur / Math.max(absorb + cur, max);
    }

    public static float getPercentE(float cur, float max, float absorb) {
        return (cur + absorb) / Math.max(absorb + cur, max);
    }

    public boolean effH() {
        return this.absorb + this.cur > this.max;
    }

    public boolean effHOld() {
        return this.oldAbsorb + this.oldCur > this.oldMax;
    }

    public void checkHealth(float data) {
        if (data != this.cur) {
            if (!this.active) {
                this.activate(Float.valueOf(data), Float.valueOf(this.max), Float.valueOf(this.absorb));
                return;
            }
            this.reset(data, this.max, this.absorb);
            this.cur = data;
            this.updateText();
        }
    }

    public void checkAbsorb(float data) {
        if (data != this.absorb) {
            if (!this.active) {
                this.activate(Float.valueOf(this.cur), Float.valueOf(this.max), Float.valueOf(data));
                return;
            }
            this.reset(this.cur, this.max, data);
            this.absorb = data;
            this.updateText();
        }
    }

    public void checkMax(float data) {
        if (data != this.max) {
            if (!this.active) {
                this.activate(Float.valueOf(this.cur), Float.valueOf(data), Float.valueOf(this.absorb));
                return;
            }
            this.reset(this.cur, data, this.absorb);
            this.max = data;
            this.updateText();
        }
    }

    public float getAbsorb() {
        return this.absorb;
    }
}

