/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.anim;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.client.config.DimConfig;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.anim.AnimHandlerBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DimAnim
extends AnimHandlerBase {
    public String oldDimension = "";
    public String dimension = "";
    public List<String> dimName = new ArrayList<String>();
    public String dimNorm = "";
    public static boolean animActive = true;
    protected ClientPlayerData player;
    private boolean oldFlag = false;

    public DimAnim(int length, ClientPlayerData player) {
        super(length);
        this.player = player;
        this.dimName.add("?");
        this.dimName.add("?");
    }

    @Override
    void activateValues(Object ... data) {
        this.setOld();
        this.setupDim((String)data[0]);
        if (((Boolean)data[1]).booleanValue() || this.oldDimension.equals("")) {
            this.setOld();
        }
    }

    @Override
    public void activate(Object ... data) {
        if (animActive) {
            super.activate(data);
            this.oldFlag = this.player.shouldRenderModel;
            this.player.shouldRenderModel = false;
        } else {
            this.setupDim((String)data[0]);
        }
    }

    void setOld() {
        this.oldDimension = this.dimension;
    }

    private void setupDim(String data) {
        DimConfig.checkDim(data);
        if (data.substring(0, data.indexOf(58)).equals("rftoolsdim")) {
            this.dimension = "rftoolsdim:dim";
            data = data.substring(data.indexOf(58) + 1);
            this.dimName = new ArrayList<String>();
            this.dimName.add("\u00a7oRFTools");
            this.dimName.add("\u00a7oDimension:");
            this.dimName.add("\u00a7o'" + data + "'");
            this.dimNorm = "RFTools Dim: " + data;
            return;
        }
        this.dimension = data;
        data = data.substring(data.indexOf(58) + 1).toLowerCase();
        String[] split = data.split("[-_ ]");
        List<String> dim = Arrays.asList(split);
        ArrayList<String> fString = new ArrayList<String>();
        if (!dim.contains("the")) {
            fString.add("\u00a7oThe");
        }
        dim.forEach(word -> fString.add("\u00a7o" + word.substring(0, 1).toUpperCase() + word.substring(1)));
        this.dimName = fString;
        this.dimNorm = String.join((CharSequence)" ", this.dimName).replace("\u00a7o", "");
        Parties.debug("DimAnim: " + this.dimName + " has been converted to " + this.dimNorm + ".", new Object[0]);
    }

    @Override
    boolean tickAnim() {
        --this.animTime;
        if (this.animTime <= 0) {
            this.animTime = 0;
            this.active = false;
            this.player.shouldRenderModel = this.oldFlag;
            return true;
        }
        return false;
    }
}

