/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.anim;

import io.sedu.mc.parties.api.mod.ironspellbooks.ISSCompatManager;
import io.sedu.mc.parties.api.mod.ironspellbooks.SpellHolder;
import io.sedu.mc.parties.client.overlay.anim.AnimHandlerBase;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CastAnim
extends AnimHandlerBase {
    public static final SpellHolder EMPTY = new SpellHolder(Component.m_237113_((String)""), new ResourceLocation(""), SpellHolder.CastType.NORMAL, 0xFFFFFF);
    SpellHolder spell = EMPTY;
    private boolean finished = false;

    public CastAnim(int length) {
        super(length);
    }

    @Override
    void activateValues(Object ... data) {
        this.setupSpell((String)data[0]);
        this.length = this.spell == EMPTY ? 0 : (Integer)data[1];
    }

    private void setupSpell(String type) {
        this.spell = ISSCompatManager.getHandler().getSpellInfo(type);
        this.finished = false;
        if (this.spell == null) {
            return;
        }
    }

    public void getSpell(float partialTicks, BiConsumer<SpellHolder, Float> action) {
        action.accept(this.spell, Float.valueOf(this.getCompletionPercent(partialTicks)));
    }

    private float getCompletionPercent(float partialTicks) {
        return Math.min(1.0f, (this.spell.type == SpellHolder.CastType.CHANNEL ? (float)this.animTime - partialTicks : (float)(this.length - this.animTime) + partialTicks) / (float)this.length);
    }

    public void markDone() {
        this.finished = true;
    }

    @Override
    boolean tickAnim() {
        if (this.finished) {
            this.active = false;
            this.animTime = 0;
            return true;
        }
        --this.animTime;
        if (this.animTime <= 0) {
            this.animTime = 0;
            if (this.spell.type != SpellHolder.CastType.HOLD) {
                this.active = false;
                return true;
            }
        }
        return false;
    }
}

