/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay.anim;

import io.sedu.mc.parties.client.overlay.anim.AnimHandlerBase;
import java.text.DecimalFormat;

public abstract class AnimBarHandler
extends AnimHandlerBase {
    public static final DecimalFormat DF = new DecimalFormat("##.#");
    public int id;
    public float cur = 0.0f;
    public float max = 20.0f;
    public float absorb = 0.0f;
    public String displayText = "";

    AnimBarHandler(int length) {
        super(length);
        this.animTime = 0;
    }

    abstract int getType();

    protected void updateText() {
        switch (this.getType()) {
            case 0: {
                this.displayText = DF.format(this.cur + this.absorb) + "/" + DF.format(this.max);
                break;
            }
            case 1: {
                if (this.absorb > 0.0f) {
                    this.displayText = DF.format(this.cur) + " (" + DF.format(this.absorb) + ")";
                    break;
                }
                this.displayText = DF.format(this.cur);
                break;
            }
            case 2: {
                this.displayText = DF.format((this.cur + this.absorb) / this.max * 100.0f) + "%";
                break;
            }
            case 3: {
                this.displayText = DF.format(this.cur) + (this.absorb > 0.0f ? "*" : "");
            }
        }
    }

    public static void tick() {
        animTickers.removeIf(AnimHandlerBase::tickAnim);
    }
}

