/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.mod.arsnoveau.ANCompatManager;
import io.sedu.mc.parties.api.mod.epicfight.EFCompatManager;
import io.sedu.mc.parties.api.mod.feathers.FCompatManager;
import io.sedu.mc.parties.api.mod.ironspellbooks.ISSCompatManager;
import io.sedu.mc.parties.api.mod.spellsandshields.SSCompatManager;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.BarBase;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.Frame;
import io.sedu.mc.parties.client.overlay.OverflowBarBase;
import io.sedu.mc.parties.client.overlay.PCastBar;
import io.sedu.mc.parties.client.overlay.PEffects;
import io.sedu.mc.parties.client.overlay.PEffectsBoth;
import io.sedu.mc.parties.client.overlay.PHead;
import io.sedu.mc.parties.client.overlay.PMana;
import io.sedu.mc.parties.client.overlay.PManaSS;
import io.sedu.mc.parties.client.overlay.PName;
import io.sedu.mc.parties.client.overlay.PStamina;
import io.sedu.mc.parties.client.overlay.RenderIconTextItem;
import io.sedu.mc.parties.client.overlay.anim.DimAnim;
import io.sedu.mc.parties.client.overlay.effects.EffectHolder;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.client.overlay.gui.TabButton;
import io.sedu.mc.parties.data.config.ClientConfigData;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;

public abstract class RenderItem {
    public static RenderItem clickArea;
    protected static ResourceLocation GUI_ICONS;
    public static ArrayList<String> parser;
    static final ResourceLocation partyPath;
    public static int framePosW;
    public static int framePosH;
    public static int frameEleH;
    public static int frameEleW;
    String name;
    public static int currentY;
    public static boolean renderSelfFrame;
    protected int xPos;
    protected int yPos;
    protected int width;
    protected int height;
    protected boolean elementEnabled = false;
    public static boolean isDirty;
    float scale = 1.0f;
    float scalePos = 0.0f;
    int zPos = 0;
    boolean textShadow = true;
    boolean textEnabled;
    boolean iconEnabled;
    private static ItemRender itemRender;

    public static void syncItems() {
        Frame.reset();
    }

    public static void enableRenderer() {
        Parties.debug("Enabling the renderer...", new Object[0]);
        switch ((ClientConfigData.RenderType)((Object)ClientConfigData.playerRender.get())) {
            case ON: {
                itemRender = (gui, guiGraphics, partialTicks) -> {
                    Frame.get(Frame.Type.PLAYER).selfRender(guiGraphics, partialTicks);
                    Frame.get(Frame.Type.PARTY).memberRender(guiGraphics, partialTicks);
                };
                break;
            }
            case PARTY: {
                itemRender = (gui, guiGraphics, partialTicks) -> {
                    Frame.get(Frame.Type.PLAYER).selfRenderParty(guiGraphics, partialTicks);
                    Frame.get(Frame.Type.PARTY).memberRender(guiGraphics, partialTicks);
                };
                break;
            }
            case OFF: {
                itemRender = (gui, guiGraphics, partialTicks) -> Frame.get(Frame.Type.PARTY).memberRender(guiGraphics, partialTicks);
            }
        }
    }

    public static void disableRenderer() {
        itemRender = (gui, guiGraphics, partialTicks) -> {};
    }

    protected static int barModsPresent() {
        int i = 0;
        if (EFCompatManager.active() || FCompatManager.active()) {
            ++i;
        }
        if (ANCompatManager.getHandler().exists()) {
            ++i;
        }
        if (SSCompatManager.active()) {
            ++i;
        }
        if (ISSCompatManager.active()) {
            ++i;
        }
        return i;
    }

    protected static int getBarIndex(RenderItem item) {
        int i = -1;
        if (EFCompatManager.active() || FCompatManager.active()) {
            ++i;
        }
        if (item instanceof PStamina) {
            return i;
        }
        if (ANCompatManager.getHandler().exists()) {
            ++i;
        }
        if (item instanceof PMana) {
            return i;
        }
        if (SSCompatManager.active()) {
            ++i;
        }
        if (item instanceof PManaSS) {
            return i;
        }
        if (ISSCompatManager.active()) {
            ++i;
        }
        return i;
    }

    public static void forEachToSave(Collection<RenderItem> items, Consumer<RenderItem> action) {
        items.forEach(item -> {
            if (item.isEnabled()) {
                action.accept((RenderItem)item);
            }
        });
    }

    public static void getItemById(Frame f, int id, Consumer<RenderItem> action) {
        f.getAllItems().computeIfPresent(RenderItem.convertId(id), (id2, item) -> {
            action.accept((RenderItem)item);
            return item;
        });
    }

    private static String convertId(int id) {
        return switch (id) {
            case 1 -> "bg1";
            case 2 -> "bgc";
            case 3 -> "head";
            case 4 -> "name";
            case 5 -> "leader";
            case 6 -> "dim";
            case 7 -> "armor";
            case 8 -> "offline";
            case 9 -> "dead";
            case 10 -> "effects";
            case 11 -> "effects_b";
            case 12 -> "effects_d";
            case 13 -> "lvlbar";
            case 14 -> "health";
            case 15 -> "hunger";
            case 16 -> "thirst";
            case 17 -> "stam";
            case 18 -> "mana";
            case 19 -> "mana_ss";
            case 20 -> "mana_i";
            case 21 -> "castbar";
            case 22 -> "temp";
            case 23 -> "origin";
            default -> "";
        };
    }

    public boolean isEnabled() {
        return this.elementEnabled;
    }

    boolean isInBound(int mouseX, int mouseY) {
        return mouseX > this.xPos - 2 && mouseY > this.yPos - 2 && (float)mouseX < (float)(this.xPos + 2) + (float)this.width * this.scale && (float)mouseY < (float)(this.yPos + 2) + (float)this.height * this.scale;
    }

    public SmallBound toggleIcon(boolean data) {
        this.iconEnabled = data;
        return null;
    }

    public SmallBound toggleText(boolean data) {
        this.textEnabled = data;
        return null;
    }

    public static void resetPos() {
        currentY = 0;
    }

    abstract void renderMember(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);

    protected void itemStart(GuiGraphics g) {
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
        g.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zPos);
    }

    protected void itemEnd(GuiGraphics g) {
        g.m_280168_().m_85849_();
    }

    public boolean isTabRendered() {
        return true;
    }

    public String translateName() {
        return "gui.sedparties.name." + this.name;
    }

    public RenderItem(String name) {
        this.name = name;
    }

    public static void register(RegisterGuiOverlaysEvent event) {
        IGuiOverlay overlay = (gui, poseStack, partialTicks, width, height) -> {
            if (ClientPlayerData.playerOrderedList.isEmpty()) {
                return;
            }
            if (isDirty) {
                RenderItem.syncItems();
                isDirty = false;
            }
            itemRender.render(gui, poseStack, partialTicks);
        };
        event.registerAboveAll("parties_hud", overlay);
    }

    public RenderItem setEnabled(boolean enabled) {
        this.elementEnabled = enabled;
        this.elementEnabled = this.isEnabled();
        return this;
    }

    static void setup(float alpha) {
        RenderItem.setup();
        RenderItem.setColor(1.0f, 1.0f, 1.0f, alpha);
    }

    static void setup() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    void blit(GuiGraphics p, ResourceLocation loc, int x, int y, int u, int v, int w, int h) {
        RenderSystem.enableDepthTest();
        p.m_280218_(loc, x, y, u, v, w, h);
    }

    void blit(GuiGraphics g, ResourceLocation r, int x, int y, int u, int v, int w, int h, int truew, int trueh) {
        RenderSystem.enableDepthTest();
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)r);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder wr = tessellator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = g.m_280168_().m_85850_().m_252922_();
        wr.m_252986_(matrix, (float)x, (float)(y + h), (float)this.zPos).m_7421_((float)u * 0.00390625f, (float)(v + trueh) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + w), (float)(y + h), (float)this.zPos).m_7421_((float)(u + truew) * 0.00390625f, (float)(v + trueh) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + w), (float)y, (float)this.zPos).m_7421_((float)(u + truew) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)x, (float)y, (float)this.zPos).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        tessellator.m_85914_();
    }

    static void setColor(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    static void setColor(int color) {
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
    }

    public void rect(int l, int t, int r, int b, PoseStack pose, int z, int offset, int startColor) {
        RenderUtils.rect(pose.m_85850_().m_252922_(), z, l + offset, t + offset, r - offset, b - offset, startColor);
    }

    public static void rectCO(PoseStack pose, int z, int offset, int l, int t, int r, int b, int startColor, int endColor) {
        RenderUtils.rectNoA(pose.m_85850_().m_252922_(), z, l + offset, t + offset, r - offset, b - offset, startColor, endColor);
    }

    void renderTypeText(PoseStack p, ForgeGui gui, Component type, int x, int y) {
    }

    void renderTab(PoseStack p, TabButton b) {
        RenderSystem.enableDepthTest();
        RenderUtils.sizeRect(p.m_85850_().m_252922_(), b.m_252754_(), b.m_252907_(), 0, b.m_5711_(), b.m_93694_(), this.getColor() | 0x64000000, (this.getColor() & 0xFEFEFE) >> 1 | 0xC8000000);
        RenderUtils.borderRect(p.m_85850_().m_252922_(), -1, 1, b.m_252754_(), b.m_252907_(), b.m_5711_(), b.m_93694_(), this.getColor() | 0x64000000, this.getColor() | 0x64000000);
    }

    void renderTabHover(PoseStack p, TabButton b) {
        RenderSystem.enableDepthTest();
        RenderUtils.sizeRect(p.m_85850_().m_252922_(), b.m_252754_(), b.m_252907_(), 0, b.m_5711_(), b.m_93694_(), (this.getColor() & 0xFEFEFE) >> 1 | 0xC8000000, this.getColor() | 0x64000000);
        RenderUtils.borderRect(p.m_85850_().m_252922_(), -1, 1, b.m_252754_(), b.m_252907_(), b.m_5711_(), b.m_93694_(), this.getColor() | 0xC8000000, this.getColor());
    }

    void renderTabClicked(PoseStack p, TabButton b) {
        RenderSystem.enableDepthTest();
        RenderUtils.sizeRectNoA(p.m_85850_().m_252922_(), b.m_252754_(), b.m_252907_(), 0, b.m_5711_(), b.m_93694_(), (this.getColor() & 0xFEFEFE) >> 1, this.getColor());
        p.m_252880_(0.0f, 0.0f, 5.0f);
        RenderUtils.borderRectNoA(p.m_85850_().m_252922_(), -1, 2, b.m_252754_(), b.m_252907_(), b.m_5711_(), b.m_93694_(), 0xFFFFFF);
        p.m_252880_(0.0f, 0.0f, -5.0f);
    }

    abstract int getColor();

    protected int getColor(int type) {
        return 0;
    }

    void text(int x, int y, GuiGraphics g, String s, int color) {
        this.text(x, y, g, s, color, this.textShadow);
    }

    void whiterText(int x, int y, GuiGraphics g, MutableComponent s, int color) {
        this.text(x, y, g, s, color, this.textShadow);
        this.text(x, y, g, s, -1713512995, this.textShadow);
    }

    void text(int x, int y, GuiGraphics g, String s, int color, boolean shadow) {
        g.m_280056_(RenderItem.getFont(), s, x, y, color, shadow);
    }

    void text(int x, int y, GuiGraphics g, MutableComponent s, int color, boolean shadow) {
        g.m_280614_(RenderItem.getFont(), (Component)s, x, y, color, shadow);
    }

    void text(int x, int y, GuiGraphics g, MutableComponent s, int color) {
        this.text(x, y, g, s, color, this.textShadow);
    }

    public static Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    protected static int guiTicks() {
        return Minecraft.m_91087_().f_91065_.m_93079_();
    }

    public static float ticks() {
        return (float)Minecraft.m_91087_().f_91065_.m_93079_() + Minecraft.m_91087_().getPartialTick();
    }

    void textCentered(int x, int y, GuiGraphics g, String text, int color) {
        int n = (int)((float)x - (float)RenderItem.getFont().m_92895_(text) / 2.0f);
        float f = y;
        Objects.requireNonNull(RenderItem.getFont());
        this.text(n, (int)(f - 9.0f / 2.0f), g, text, color);
    }

    public static void useAlpha(float alpha) {
        RenderItem.setColor(1.0f, 1.0f, 1.0f, alpha);
    }

    public static void resetColor() {
        RenderItem.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderTooltip(GuiGraphics g, int mouseX, int mouseY, int offsetX, int offsetY, MutableComponent text, int outStart, int outEnd, int inStart, int inEnd, int textColor) {
        PoseStack poseStack = g.m_280168_();
        int n = mouseX + RenderItem.getFont().m_92852_((FormattedText)text) + offsetX;
        Objects.requireNonNull(RenderItem.getFont());
        RenderItem.rectCO(poseStack, 0, -3, mouseX + offsetX, currentY + mouseY + offsetY, n, currentY + mouseY + 9 + offsetY, outStart, outEnd);
        PoseStack poseStack2 = g.m_280168_();
        int n2 = mouseX + RenderItem.getFont().m_92852_((FormattedText)text) + offsetX;
        Objects.requireNonNull(RenderItem.getFont());
        RenderItem.rectCO(poseStack2, 0, -2, mouseX + offsetX, currentY + mouseY + offsetY, n2, currentY + mouseY + 9 + offsetY, inStart, inEnd);
        this.text(mouseX + offsetX, currentY + mouseY + 1, g, text, textColor, true);
        Objects.requireNonNull(RenderItem.getFont());
        currentY += 9 + offsetY + 8;
    }

    protected void renderTooltip(GuiGraphics g, int mouseX, int mouseY, int offsetX, int offsetY, String text, int outStart, int outEnd, int inStart, int inEnd, int textColor) {
        this.renderTooltip(g, mouseX, mouseY, offsetX, offsetY, Component.m_237113_((String)text), outStart, outEnd, inStart, inEnd, textColor);
    }

    protected void renderTooltip(GuiGraphics g, int mouseX, int mouseY, int offsetX, int offsetY, String text, int outStart, int outEnd, int textColor) {
        this.renderTooltip(g, mouseX, mouseY, offsetX, offsetY, Component.m_237113_((String)text), outStart, outEnd, 1312020, 1312020, textColor);
    }

    protected void renderTooltip(GuiGraphics g, int mouseX, int mouseY, int offsetX, int offsetY, MutableComponent text, int outStart, int outEnd, int textColor) {
        this.renderTooltip(g, mouseX, mouseY, offsetX, offsetY, text, outStart, outEnd, 1312020, 1312020, textColor);
    }

    protected void renderGroupEffectTooltip(GuiGraphics g, int mouseX, int mouseY, int offsetX, int offsetY, List<ColorComponent> text, int outStart, int outEnd, int inStart, int inEnd) {
        g.m_280168_().m_85836_();
        int max = 0;
        int y = offsetY;
        g.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        for (ColorComponent c : text) {
            this.text(mouseX + offsetX, currentY + mouseY + 1 + y, g, c.c, c.color, true);
            max = Math.max(max, RenderItem.getFont().m_92852_((FormattedText)c.c));
            Objects.requireNonNull(RenderItem.getFont());
            y += 9 + 1;
        }
        RenderItem.rectCO(g.m_280168_(), -1, -3, mouseX + offsetX, currentY + mouseY + offsetY, mouseX + max + offsetX, currentY + mouseY + y + offsetY, outStart, outEnd);
        RenderItem.rectCO(g.m_280168_(), -1, -2, mouseX + offsetX, currentY + mouseY + offsetY, mouseX + max + offsetX, currentY + mouseY + y + offsetY, inStart, inEnd);
        g.m_280168_().m_85849_();
        currentY += y + 8;
    }

    protected void renderSingleEffectTooltip(GuiGraphics g, int mouseX, int mouseY, Component[] text, MobEffect effect) {
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)this.getScale(), 0.0f, 100.0f);
        int max = 0;
        int y = currentY + mouseY;
        max = Math.max(max, RenderItem.getFont().m_92852_((FormattedText)text[0]));
        for (int i = 1; i < 4; ++i) {
            max = Math.max(max, RenderItem.getFont().m_92852_((FormattedText)text[i]) / 2 + 24);
        }
        Component c = text[0];
        this.whiterText((int)((float)(mouseX + 10) + (float)(max - RenderItem.getFont().m_92852_((FormattedText)c)) / 2.0f), y + 1, g, (MutableComponent)c, effect.m_19484_());
        Objects.requireNonNull(RenderItem.getFont());
        int colorCut = (effect.m_19484_() & 0xFEFEFE) >> 1;
        colorCut = (colorCut & 0xFEFEFE) >> 1;
        colorCut = (colorCut & 0xFEFEFE) >> 1;
        RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), 0, mouseX + 10 + 2, (y += 9 + 4) - 2, (float)(mouseX + 10) + (float)max / 2.0f, y - 1, colorCut | 0xFF000000, effect.m_19484_() | 0xFF000000);
        RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), 0, (float)(mouseX + 10) + (float)max / 2.0f, y - 2, mouseX + 10 + max - 2, y - 1, effect.m_19484_() | 0xFF000000, colorCut | 0xFF000000);
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91306_().m_118732_(effect);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        RenderSystem.enableBlend();
        g.m_280159_(mouseX + 10, y + 4, 0, 18, 18, sprite);
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        g.m_280168_().m_252880_((float)(mouseX + 10 + 24), (float)((y + 2) * 2), 0.0f);
        c = text[1];
        int xCol = mouseX + 10 + 24;
        int ySnap = y + 9;
        this.text(xCol, 0, g, (MutableComponent)c, -1, true);
        c = text[3];
        this.text(xCol, 34, g, (MutableComponent)c, -1, true);
        g.m_280168_().m_85849_();
        c = text[2];
        this.text(xCol, ySnap, g, (MutableComponent)c, -1, true);
        RenderItem.rectCO(g.m_280168_(), -1, -4, mouseX + 10, currentY + mouseY, mouseX + max + 10, y += 22, (effect.m_19484_() & 0xFEFEFE) >> 1, effect.m_19484_());
        RenderItem.rectCO(g.m_280168_(), -1, -3, mouseX + 10, currentY + mouseY, mouseX + max + 10, currentY + mouseY + 11, colorCut, colorCut);
        RenderItem.rectCO(g.m_280168_(), -1, -3, mouseX + 10, currentY + mouseY + 11, mouseX + max + 10, y, colorCut, (effect.m_19484_() & 0xFEFEFE) >> 1);
        g.m_280168_().m_85849_();
        currentY = currentY - (y - mouseY) + 7;
    }

    protected void renderSingleEffectTooltipModded(GuiGraphics g, int mouseX, int mouseY, Component[] text, List<Component> desc, int descMax, MobEffect effect) {
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)this.getScale(), 0.0f, 100.0f);
        int max = descMax;
        int y = currentY + mouseY;
        max = Math.max(max, RenderItem.getFont().m_92852_((FormattedText)text[0]));
        for (int i = 1; i < 4; ++i) {
            max = Math.max(max, RenderItem.getFont().m_92852_((FormattedText)text[i]) / 2 + 24);
        }
        Component c = text[0];
        this.whiterText((int)((float)(mouseX + 10) + (float)(max - RenderItem.getFont().m_92852_((FormattedText)c)) / 2.0f), y + 1, g, (MutableComponent)c, effect.m_19484_());
        Objects.requireNonNull(RenderItem.getFont());
        int colorCut = (effect.m_19484_() & 0xFEFEFE) >> 1;
        colorCut = (colorCut & 0xFEFEFE) >> 1;
        colorCut = (colorCut & 0xFEFEFE) >> 1;
        RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), 0, mouseX + 10 + 2, (y += 9 + 4) - 2, (float)(mouseX + 10) + (float)max / 2.0f, y - 1, colorCut | 0xFF000000, effect.m_19484_() | 0xFF000000);
        RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), 0, (float)(mouseX + 10) + (float)max / 2.0f, y - 2, mouseX + 10 + max - 2, y - 1, effect.m_19484_() | 0xFF000000, colorCut | 0xFF000000);
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91306_().m_118732_(effect);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        RenderSystem.enableBlend();
        g.m_280159_(mouseX + 10, y + 4, 0, 18, 18, sprite);
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        g.m_280168_().m_252880_((float)(mouseX + 10 + 24), (float)((y + 2) * 2), 0.0f);
        c = text[1];
        int xCol = mouseX + 10 + 24;
        int ySnap = y + 9;
        this.text(xCol, 0, g, (MutableComponent)c, -1, true);
        c = text[3];
        this.text(xCol, 34, g, (MutableComponent)c, -1, true);
        g.m_280168_().m_252880_((float)(mouseX - 14), 8.0f, 0.0f);
        for (int i = 0; i < desc.size(); ++i) {
            this.text(0, 40 + i * 9, g, (MutableComponent)desc.get(i), effect.m_19484_(), true);
            this.text(0, 40 + i * 9, g, (MutableComponent)desc.get(i), -1713512995, true);
        }
        g.m_280168_().m_85849_();
        c = text[2];
        this.text(xCol, ySnap, g, (MutableComponent)c, -1, true);
        RenderItem.rectCO(g.m_280168_(), -1, -4, mouseX + 10, currentY + mouseY, mouseX + max + 10, y += 24 + desc.size() * 5, (effect.m_19484_() & 0xFEFEFE) >> 1, effect.m_19484_());
        RenderItem.rectCO(g.m_280168_(), -1, -3, mouseX + 10, currentY + mouseY, mouseX + max + 10, currentY + mouseY + 11, colorCut, colorCut);
        RenderItem.rectCO(g.m_280168_(), -1, -3, mouseX + 10, currentY + mouseY + 11, mouseX + max + 10, y, colorCut, (effect.m_19484_() & 0xFEFEFE) >> 1);
        g.m_280168_().m_85849_();
        currentY = currentY - (y - mouseY) + 7;
    }

    public int w() {
        return this.width;
    }

    public int h() {
        return this.height;
    }

    public TabButton.Action render(final ForgeGui gui) {
        return new TabButton.Action(){

            @Override
            public void onRender(PoseStack p, TabButton b) {
                RenderItem.this.renderTab(p, b);
                RenderItem.this.renderElement(p, gui, b);
            }

            @Override
            public void onHover(PoseStack p, TabButton b) {
                RenderItem.this.renderTabHover(p, b);
                RenderItem.this.renderElement(p, gui, b);
            }

            @Override
            public void onSelect(PoseStack p, TabButton b) {
                RenderItem.this.renderTabClicked(p, b);
                RenderItem.this.renderElement(p, gui, b);
            }

            @Override
            public ConfigOptionsList getOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h) {
                return RenderItem.this.getConfigOptions(s, minecraft, x, y, w, h, false);
            }

            @Override
            public ResourceLocation getInnerBackground() {
                return RenderItem.this.getItemBackground();
            }

            @Override
            public ItemBound getItemBound() {
                return RenderItem.this.getRenderItemBound();
            }
        };
    }

    public ItemBound getRenderItemBound() {
        return null;
    }

    protected ResourceLocation getItemBackground() {
        return new ResourceLocation("textures/block/deepslate_bricks.png");
    }

    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        return new ConfigOptionsList(this::getColor, s, minecraft, x, y, w, h, parse);
    }

    abstract void renderElement(PoseStack var1, ForgeGui var2, Button var3);

    abstract void updateDefaultPositionForMods(HashMap<String, Update> var1);

    public SmallBound changeVisibility(boolean data) {
        this.elementEnabled = data;
        this.elementEnabled = this.isEnabled();
        isDirty = true;
        return null;
    }

    public SmallBound setXPos(int data) {
        this.xPos = data;
        return null;
    }

    public SmallBound setYPos(int data) {
        this.yPos = data;
        return null;
    }

    public SmallBound setZPos(int data) {
        this.zPos = data;
        return null;
    }

    public SmallBound setScale(int data) {
        switch (data) {
            case 1: {
                this.scale = 0.5f;
                this.scalePos = 1.0f;
                break;
            }
            case 2: {
                this.scale = 1.0f;
                this.scalePos = 0.0f;
                break;
            }
            case 3: {
                this.scale = 2.0f;
                this.scalePos = -0.5f;
            }
        }
        return new SmallBound(2, (int)((float)this.width * this.scale)){

            @Override
            public void update(BiConsumer<Integer, Integer> action) {
                action.accept(this.type, this.value);
                action.accept(3, (int)((float)RenderItem.this.height * RenderItem.this.scale));
            }
        };
    }

    public int getScale() {
        if (this.scale == 0.5f) {
            return 1;
        }
        if (this.scale == 1.0f) {
            return 2;
        }
        if (this.scale == 2.0f) {
            return 3;
        }
        return -1;
    }

    public SmallBound setColor(int type, int data) {
        return null;
    }

    public SmallBound setTextShadow(boolean data) {
        this.textShadow = data;
        return null;
    }

    protected SmallBound setWidth(Integer d) {
        this.width = d;
        return new SmallBound(2, (int)((float)this.width * this.scale));
    }

    protected SmallBound setHeight(Integer d) {
        this.height = d;
        return new SmallBound(3, (int)((float)this.height * this.scale));
    }

    protected void updateValues() {
    }

    protected int maxX() {
        return Math.max(0, frameEleW - (int)((float)this.width * this.scale));
    }

    protected int maxY() {
        return Math.max(0, frameEleH - (int)((float)this.height * this.scale));
    }

    void addDisplaySettings(ConfigOptionsList c) {
        c.addTitleEntry("display");
        c.addBooleanEntry("display", this.isEnabled());
    }

    void addPositionalSettings(ConfigOptionsList c, boolean bStandardPos, boolean bZPos, boolean bScale) {
        c.addTitleEntry("position");
        if (bStandardPos) {
            c.addSliderEntry("xpos", 0, this::maxX, this.xPos);
            c.addSliderEntry("ypos", 0, this::maxY, this.yPos);
        }
        if (bZPos) {
            c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        }
        if (bScale) {
            c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        }
    }

    public static void initUpdater(HashMap<String, Update> updater) {
        updater.put("display", (n, d) -> n.changeVisibility((Boolean)d));
        updater.put("tshadow", (n, d) -> n.setTextShadow((Boolean)d));
        updater.put("idisplay", (n, d) -> n.toggleIcon((Boolean)d));
        updater.put("tdisplay", (n, d) -> n.toggleText((Boolean)d));
        updater.put("bgdisplay", (n, d) -> n.toggleIcon((Boolean)d));
        updater.put("tattached", (n, d) -> ((RenderIconTextItem)n).toggleTextAttach((Boolean)d));
        updater.put("xpos", (n, d) -> n.setXPos((Integer)d));
        updater.put("ypos", (n, d) -> n.setYPos((Integer)d));
        updater.put("scale", (n, d) -> n.setScale((Integer)d));
        updater.put("zpos", (n, d) -> n.setZPos((Integer)d));
        updater.put("xtpos", (n, d) -> ((RenderIconTextItem)n).setXTextPos((int)((Integer)d)));
        updater.put("ytpos", (n, d) -> ((RenderIconTextItem)n).setYTextPos((int)((Integer)d)));
        updater.put("tmax", (n, d) -> ((PName)n).setMaxTextSize((Integer)d));
        updater.put("width", (n, d) -> n.setWidth((int)((Integer)d)));
        updater.put("height", (n, d) -> n.setHeight((int)((Integer)d)));
        updater.put("ttype", (n, d) -> ((BarBase)n).setTextType((Integer)d));
        updater.put("tcolor", (n, d) -> n.setColor(0, (Integer)d));
        updater.put("barmode", (n, d) -> ((BarBase)n).toggleBarMode((Boolean)d));
        updater.put("bhue", (n, d) -> ((BarBase)n).setMainHue((Integer)d));
        updater.put("ohue", (n, d) -> ((OverflowBarBase)n).setOverflowHue((Integer)d));
        updater.put("bcit", (n, d) -> n.setColor(0, (Integer)d));
        updater.put("bcib", (n, d) -> n.setColor(1, (Integer)d));
        updater.put("bcdt", (n, d) -> n.setColor(2, (Integer)d));
        updater.put("bcdb", (n, d) -> n.setColor(3, (Integer)d));
        updater.put("buffg", (n, d) -> n.setColor(0, (Integer)d));
        updater.put("buffb", (n, d) -> n.setColor(1, (Integer)d));
        updater.put("flash", (n, d) -> n.setColor(2, (Integer)d));
        updater.put("blim", (n, d) -> EffectHolder.updatebLim((Integer)d));
        updater.put("dlim", (n, d) -> EffectHolder.updatedLim((Integer)d));
        updater.put("dfirst", (n, d) -> {
            PEffectsBoth.debuffFirst = (Boolean)d;
            ClientPlayerData.markEffectsDirty();
            return null;
        });
        updater.put("bsep", (n, d) -> {
            PEffectsBoth.prioDur = (Boolean)d;
            ClientPlayerData.markEffectsDirty();
            return null;
        });
        updater.put("spacex", (n, d) -> n.setWidth((int)((Integer)d)));
        updater.put("spacey", (n, d) -> n.setHeight((int)((Integer)d)));
        updater.put("bsize", (n, d) -> ((PEffects)n).setBorderSize((Integer)d));
        updater.put("rowmax", (n, d) -> ((PEffects)n).setMaxPerRow((Integer)d));
        updater.put("totalmax", (n, d) -> ((PEffects)n).setMaxSize((Integer)d));
        updater.put("danim", (n, d) -> {
            DimAnim.animActive = (Boolean)d;
            return null;
        });
        updater.put("gen_w", (n, d) -> {
            frameEleW = (Integer)d;
            return null;
        });
        updater.put("gen_h", (n, d) -> {
            frameEleH = (Integer)d;
            return null;
        });
        updater.put("gen_pw", (n, d) -> {
            framePosW = (Integer)d;
            return null;
        });
        updater.put("gen_ph", (n, d) -> {
            framePosH = (Integer)d;
            return null;
        });
        updater.put("genc_w", (n, d) -> n.setWidth((int)((Integer)d)));
        updater.put("genc_h", (n, d) -> n.setHeight((int)((Integer)d)));
        updater.put("genc_x", (n, d) -> n.setXPos((Integer)d));
        updater.put("genc_y", (n, d) -> n.setYPos((Integer)d));
        updater.put("htype", (n, d) -> {
            PHead.renderType = (Integer)d;
            return null;
        });
        updater.put("bleed", (n, d) -> {
            PHead.renderBleed = (Boolean)d;
            return null;
        });
        updater.put("thalfsize", (n, d) -> {
            ((PCastBar)n).textHalfSize = (Boolean)d;
            return null;
        });
    }

    public ConfigEntry getCurrentValues(HashMap<String, Getter> getter) {
        ConfigEntry defaults = this.getDefaults();
        ConfigEntry currents = new ConfigEntry();
        defaults.forEachEntry((entry, value) -> currents.addEntry((ConfigEntry.EntryObject)entry, ((Getter)getter.get(entry.getName())).getValue(this)));
        return currents;
    }

    public static void initGetter(HashMap<String, Getter> getter) {
        getter.put("display", n -> n.elementEnabled);
        getter.put("tshadow", n -> n.textShadow);
        getter.put("idisplay", n -> n.iconEnabled);
        getter.put("tdisplay", n -> n.textEnabled);
        getter.put("bgdisplay", n -> n.iconEnabled);
        getter.put("tattached", n -> ((RenderIconTextItem)n).textAttached);
        getter.put("xpos", n -> n.xPos);
        getter.put("ypos", n -> n.yPos);
        getter.put("scale", RenderItem::getScale);
        getter.put("zpos", n -> n.zPos);
        getter.put("xtpos", n -> ((RenderIconTextItem)n).textX);
        getter.put("ytpos", n -> ((RenderIconTextItem)n).textY);
        getter.put("tmax", n -> ((PName)n).length);
        getter.put("width", n -> n.width);
        getter.put("height", n -> n.height);
        getter.put("ttype", n -> ((BarBase)n).getTextType());
        getter.put("tcolor", n -> n.getColor(0));
        getter.put("barmode", n -> ((BarBase)n).isBarMode());
        getter.put("bhue", n -> ((BarBase)n).hue);
        getter.put("ohue", n -> ((OverflowBarBase)n).oHue);
        getter.put("bcit", n -> n.getColor(0));
        getter.put("bcib", n -> n.getColor(1));
        getter.put("bcdt", n -> n.getColor(2));
        getter.put("bcdb", n -> n.getColor(3));
        getter.put("buffg", n -> n.getColor(0));
        getter.put("buffb", n -> n.getColor(1));
        getter.put("flash", n -> n.getColor(2));
        getter.put("blim", n -> PEffectsBoth.bLim);
        getter.put("dlim", n -> PEffectsBoth.dLim);
        getter.put("dfirst", n -> PEffectsBoth.debuffFirst);
        getter.put("bsep", n -> PEffectsBoth.prioDur);
        getter.put("spacex", n -> n.width);
        getter.put("spacey", n -> n.height);
        getter.put("bsize", n -> ((PEffects)n).borderSize);
        getter.put("rowmax", n -> ((PEffects)n).maxPerRow);
        getter.put("totalmax", n -> ((PEffects)n).maxSize);
        getter.put("danim", n -> DimAnim.animActive);
        getter.put("gen_w", n -> frameEleW);
        getter.put("gen_h", n -> frameEleH);
        getter.put("gen_pw", n -> framePosW);
        getter.put("gen_ph", n -> framePosH);
        getter.put("genc_w", n -> RenderItem.clickArea.width);
        getter.put("genc_h", n -> RenderItem.clickArea.height);
        getter.put("genc_x", n -> RenderItem.clickArea.xPos);
        getter.put("genc_y", n -> RenderItem.clickArea.yPos);
        getter.put("htype", n -> PHead.renderType);
        getter.put("bleed", n -> PHead.renderBleed);
        getter.put("thalfsize", n -> ((PCastBar)n).textHalfSize);
    }

    public static void setElementDefaults(RenderItem item, HashMap<String, Update> updater) {
        item.getDefaults().forEachEntry((s, v) -> ((Update)updater.get(s.getName())).onUpdate(item, v));
        item.updateDefaultPositionForMods(updater);
    }

    public abstract ConfigEntry getDefaults();

    public static ConfigEntry getGeneralValues() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("gen_w", frameEleW, 12);
        e.addEntry("gen_h", frameEleH, 12);
        e.addEntry("gen_pw", framePosW, 12);
        e.addEntry("gen_ph", framePosH, 12);
        return e;
    }

    public static ConfigEntry getGeneralDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("gen_w", 256, 12);
        e.addEntry("gen_h", 64, 12);
        e.addEntry("gen_pw", 0, 12);
        e.addEntry("gen_ph", 63, 12);
        return e;
    }

    public abstract int getId();

    public boolean equals(Object obj) {
        if (obj instanceof RenderItem) {
            RenderItem r = (RenderItem)obj;
            return r.getId() == this.getId();
        }
        return false;
    }

    static {
        GUI_ICONS = new ResourceLocation("textures/gui/icons.png");
        parser = new ArrayList();
        partyPath = new ResourceLocation("sedparties", "textures/partyicons.png");
        framePosW = 0;
        framePosH = 0;
        frameEleH = 56;
        frameEleW = 0;
        currentY = 0;
        renderSelfFrame = true;
        isDirty = false;
    }

    private static interface ItemRender {
        public void render(ForgeGui var1, GuiGraphics var2, float var3);
    }

    public static class ColorComponent {
        static final ColorComponent EMPTY = new ColorComponent(Component.m_237113_((String)""), 0);
        MutableComponent c;
        int color;

        public ColorComponent(MutableComponent c, int color) {
            this.color = color;
            this.c = c;
        }
    }

    public static class SmallBound {
        int type;
        int value;

        public SmallBound(int type, int value) {
            this.type = type;
            this.value = value;
        }

        public void update(BiConsumer<Integer, Integer> action) {
            action.accept(this.type, this.value);
        }
    }

    public static interface Update {
        public SmallBound onUpdate(RenderItem var1, Object var2);
    }

    public static interface Getter {
        public Object getValue(RenderItem var1);
    }

    public static class ItemBound {
        int x;
        int y;
        int width;
        int height;

        public ItemBound(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

