/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.client.config.Config;
import io.sedu.mc.parties.client.overlay.Frame;
import java.util.List;

public class PresetEntry {
    String preset;
    int xPos;
    int yPos;
    double scale;
    Anchor anchor;

    public PresetEntry(String preset, int xPos, int yPos, double scale, Anchor a) {
        this.preset = preset;
        this.xPos = xPos;
        this.yPos = yPos;
        this.scale = scale;
        this.anchor = a;
    }

    public static boolean loadPreset(List<PresetEntry> entryList) {
        if (entryList == null) {
            return false;
        }
        if (entryList.size() != 2) {
            Parties.warn("Current preset doesn't provide a preset for every type.", new Object[0]);
            return false;
        }
        Frame.setEntries(entryList);
        return entryList.size() > 1;
    }

    public char[] getPresetString() {
        return this.preset.toCharArray();
    }

    public void updatePresetString(String presetString) {
        this.preset = presetString;
        Config.savePersistentPreset();
    }

    public static enum Anchor {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        LEFT,
        CENTER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

