/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.api.mod.homeostatic.HCompatManager;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderIconTextItem;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.TooltipItem;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PTemp
extends RenderIconTextItem
implements TooltipItem {
    private final MutableComponent tipName = Component.m_237115_((String)"ui.sedparties.tooltip.temp");
    private final MutableComponent tipName2 = Component.m_237115_((String)"ui.sedparties.tooltip.temp2");
    private final MutableComponent tipName3 = Component.m_237115_((String)"ui.sedparties.tooltip.temp3");
    private Renderer render;
    private TooltipRender tooltip;

    public PTemp(String name) {
        super(name);
        this.width = 9;
        this.height = 9;
        this.updateRendererForDefault();
    }

    @Override
    int getColor() {
        return 0xAAAAFF;
    }

    @Override
    void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
        PTemp.setup();
        RenderSystem.enableDepthTest();
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
        if (PTemp.barModsPresent() > 0) {
            updater.get("ypos").onUpdate(this, 17);
        }
        if (HCompatManager.getHandler().exists()) {
            updater.get("display").onUpdate(this, true);
        }
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (!id.isSpectator) {
            this.render.render(x, y, id, g, partialTicks);
        }
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isOnline && !id.isSpectator) {
            this.render.render(x, y, id, g, partialTicks);
        }
    }

    void renderTemp(int x, int y, GuiGraphics g, int worldTemp, int sev, float alpha, boolean extremeTemps) {
        if (this.iconEnabled) {
            PTemp.useAlpha(alpha);
            PTemp.setup();
            RenderSystem.enableDepthTest();
            this.blit(g, partyPath, x, y, (sev + 1) * 18, extremeTemps ? 36 : 18, 9, 9, 18, 18);
            PTemp.resetColor();
        }
        if (this.textEnabled) {
            this.text(x + this.tX(), y + this.tY(), g, worldTemp + "\u00b0", this.getSevColor(sev));
        }
    }

    void renderTANTemp(int x, int y, ClientPlayerData id, GuiGraphics g, float alpha) {
        if (this.iconEnabled) {
            PTemp.setup();
            PTemp.useAlpha(alpha);
            RenderSystem.enableDepthTest();
            this.blit(g, partyPath, x, y, id.getWorldTemp() * 18, 18, 9, 9, 18, 18);
            PTemp.resetColor();
        }
        if (this.textEnabled) {
            this.text(x + this.tX(), y + this.tY(), g, id.getTempType(), this.getTANColor(id.getWorldTemp()));
        }
    }

    void renderHTemp(int x, int y, GuiGraphics g, int worldTemp, int tempTex, float alpha) {
        if (this.iconEnabled) {
            PTemp.setup();
            PTemp.useAlpha(alpha);
            RenderSystem.enableDepthTest();
            this.blit(g, partyPath, x, y, tempTex * 18, 18, 9, 9, 18, 18);
            PTemp.resetColor();
        }
        if (this.textEnabled) {
            this.text(x + this.tX(), y + this.tY(), g, worldTemp + "\u00b0", this.getTANColor(tempTex));
        }
    }

    private int getSevColor(int sev) {
        switch (sev) {
            case 0: {
                return 4834303;
            }
            case 1: {
                return 13369312;
            }
        }
        return 16750704;
    }

    private int getTANColor(int temp) {
        switch (temp) {
            case 0: {
                return 3637429;
            }
            case 1: {
                return 4834303;
            }
            case 2: {
                return 13369312;
            }
            case 3: {
                return 16750704;
            }
        }
        return 13849152;
    }

    @Override
    protected int attachedX() {
        return 11;
    }

    @Override
    protected int attachedY() {
        return 1;
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = super.getConfigOptions(s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.elementEnabled);
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        return c;
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("scale", 2, 2);
        e.addEntry("zpos", 0, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 80, 12);
        e.addEntry("ypos", 19, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", true, 1);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        return e;
    }

    @Override
    public int getId() {
        return 22;
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData id, int mouseX, int mouseY) {
        this.tooltip.render(g, id, mouseX, mouseY);
    }

    public void updateRendererForTAN() {
    }

    @Override
    public boolean isEnabled() {
        if (HCompatManager.getHandler().exists()) {
            this.updateRendererForHomeostatic();
            return this.elementEnabled;
        }
        return false;
    }

    private void updateRendererForDefault() {
        this.render = (x, y, id, g, partialTicks) -> {
            if (Math.abs(id.getBodyTemp()) < 20) {
                this.renderTemp(x, y, g, id.getWorldTemp(), id.getSeverity(), id.alpha, false);
            } else if (Math.abs(id.getBodyTemp()) < 60) {
                this.renderTemp(x, y, g, id.getWorldTemp(), id.getSeverity(), id.alpha * (float)(0.75 + Math.sin(((float)PTemp.guiTicks() + partialTicks) / 8.0f) / 3.0), true);
            } else {
                this.renderTemp(x, y, g, id.getWorldTemp(), id.getSeverity(), id.alpha * (float)(0.75 + Math.sin(((float)PTemp.guiTicks() + partialTicks) / 3.0f) / 3.0), true);
            }
        };
        this.tooltip = (g, p, mouseX, mouseY) -> {
            if (p.isOnline && !p.isSpectator) {
                this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + p.getWorldTemp() + "\u00b0", 14084569, 8950666, this.getSevColor(p.getSeverity()));
                this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName2.getString() + p.getBodyTemp(), 14084569, 8950666, this.getSevColor(p.getSeverity()));
            }
        };
    }

    public void updateRendererForHomeostatic() {
        this.render = (x, y, id, gui, partialTicks) -> {
            int severe = id.getSeverity() & 0xF;
            int tempTex = id.getSeverity() >> 16 & 0xFFFF;
            this.renderHTemp(x, y, gui, id.getWorldTemp(), tempTex, severe == 1 ? id.alpha * (float)(0.75 + Math.sin(((float)PTemp.guiTicks() + partialTicks) / 8.0f) / 3.0) : id.alpha);
        };
        this.tooltip = (g, p, mouseX, mouseY) -> {
            if (p.isOnline && !p.isSpectator) {
                int tempTex = p.getSeverity() >> 16 & 0xFFFF;
                this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + p.getWorldTemp() + "\u00b0", 14084569, 8950666, this.getTANColor(tempTex));
                this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName3.getString() + p.getBodyTemp() + "\u00b0", 14084569, 8950666, this.getTANColor(tempTex));
            }
        };
    }

    private static interface Renderer {
        public void render(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);
    }

    private static interface TooltipRender {
        public void render(GuiGraphics var1, ClientPlayerData var2, int var3, int var4);
    }
}

