/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.api.mod.epicfight.EFCompatManager;
import io.sedu.mc.parties.api.mod.feathers.FCompatManager;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.OverflowBarBase;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;
import io.sedu.mc.parties.client.overlay.anim.StaminAnim;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.AnimUtils;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PStamina
extends OverflowBarBase {
    public PStamina(String name) {
        super(name, (Component)Component.m_237115_((String)"ui.sedparties.tooltip.stamina"));
    }

    @Override
    protected void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
        RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), b.m_252754_() + 7, b.m_252907_() + 5, 0, 14.0f, 7, this.bColorTop, this.bColorBot);
        RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), b.m_252754_() + 8, b.m_252907_() + 6, 0, 12.0f, 5, this.colorTop, this.colorBot);
        RenderSystem.enableDepthTest();
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
        if (EFCompatManager.active() || FCompatManager.active()) {
            int max = RenderItem.barModsPresent();
            if (max > 0) {
                int spacing = 240 / max;
                int index = RenderItem.getBarIndex(this);
                updater.get("xpos").onUpdate(this, 46 + spacing / 2 * index);
                updater.get("width").onUpdate(this, spacing);
            }
            updater.get("display").onUpdate(this, true);
        }
    }

    @Override
    protected void renderSelfBar(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getStaminaEF(staminAnim -> {
            if (id.isDead) {
                if (this.iconEnabled) {
                    RenderUtils.sizeRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorBot, this.bColorBot);
                    RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
                }
                return;
            }
            if (this.iconEnabled) {
                this.renderHealth(x, y, g.m_280168_(), (StaminAnim)staminAnim);
                if (staminAnim.active) {
                    this.renderHealthAnim(x, y, g.m_280168_(), (StaminAnim)staminAnim, partialTicks);
                }
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 255 - id.alphaI << 24);
            }
            if (this.textEnabled) {
                g.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zPos);
                if (staminAnim.absorb > 0.0f) {
                    this.textCentered(x + this.tX(), y + this.tY(), g, staminAnim.displayText, this.absorbColor);
                } else {
                    this.textCentered(x + this.tX(), y + this.tY(), g, staminAnim.displayText, this.color);
                }
            }
        });
    }

    @Override
    protected void renderSelfIcon(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getStaminaEF(staminAnim -> {
            if (this.iconEnabled) {
                PStamina.setup();
                this.blit(g, partyPath, x, y, 18, 0, 9, 9);
            }
            if (this.textEnabled) {
                g.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zPos);
                if (staminAnim.absorb > 0.0f) {
                    this.text(this.tXI(), this.tYI(), g, staminAnim.displayText, this.absorbColor);
                } else {
                    this.text(this.tXI(), this.tYI(), g, staminAnim.displayText, this.color);
                }
            }
        });
    }

    private void renderHealth(int x, int y, PoseStack poseStack, StaminAnim staminAnim) {
        float hB = staminAnim.getPercent();
        if (staminAnim.absorb > 0.0f) {
            RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bAColorTop, this.bAColorBot);
            RenderUtils.offRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
            float aB = hB + staminAnim.getPercentA();
            this.rectRNoA(poseStack, x, y, hB, this.colorTop, this.colorBot);
            this.rectB(poseStack, x, y, hB, aB, this.colorTopAbsorb, this.colorBotAbsorb);
        } else {
            RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorTop, this.bColorBot);
            RenderUtils.offRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
            this.rectRNoA(poseStack, x, y, hB, this.colorTop, this.colorBot);
        }
    }

    private void renderHealthAnim(int x, int y, PoseStack poseStack, StaminAnim staminAnim, float partialTicks) {
        if ((float)staminAnim.animTime - partialTicks < 10.0f) {
            staminAnim.oldH += (staminAnim.curH - staminAnim.oldH) * AnimUtils.animPos(10 - staminAnim.animTime, partialTicks, true, 10, 1.0f);
            staminAnim.oldA += (staminAnim.curA - staminAnim.oldA) * AnimUtils.animPos(10 - staminAnim.animTime, partialTicks, true, 10, 1.0f);
        }
        if (staminAnim.hInc) {
            if (staminAnim.effHOld()) {
                this.rectAnim(poseStack, x, y, staminAnim.oldH, staminAnim.curH, this.colorAbsTop, this.colorAbsBot);
            } else {
                this.rectAnim(poseStack, x, y, staminAnim.oldH, staminAnim.curH, this.colorIncTop, this.colorIncBot);
            }
        } else if (staminAnim.effH()) {
            this.rectAnim(poseStack, x, y, staminAnim.curH, staminAnim.oldH, this.colorAbsTop, this.colorAbsBot);
        } else {
            this.rectAnim(poseStack, x, y, staminAnim.curH, staminAnim.oldH, this.colorDecTop, this.colorDecBot);
        }
        if (staminAnim.aInc) {
            this.rectAnim(poseStack, x, y, staminAnim.oldA, staminAnim.curA, this.colorAbsTop, this.colorAbsBot);
        } else {
            this.rectAnim(poseStack, x, y, staminAnim.curA, staminAnim.oldA, this.colorAbsTop, this.colorAbsBot);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData p, int mouseX, int mouseY) {
        p.getStaminaEF(h -> this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + AnimBarHandler.DF.format(h.cur + h.absorb) + "/" + AnimBarHandler.DF.format(h.max), 6733738, 21845, 5629132));
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", false, 1);
        e.addEntry("barmode", true, 1);
        e.addEntry("scale", 1, 2);
        e.addEntry("zpos", 1, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 46, 12);
        e.addEntry("ypos", 35, 12);
        e.addEntry("width", 240, 12);
        e.addEntry("height", 10, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", true, 1);
        e.addEntry("ttype", 0, 4);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        e.addEntry("bhue", 45, 7);
        e.addEntry("ohue", 62, 7);
        e.addEntry("bcit", 11531990, 24);
        e.addEntry("bcib", 5563812, 24);
        e.addEntry("bcdt", 6737567, 24);
        e.addEntry("bcdb", 4038002, 24);
        return e;
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = new ConfigOptionsList(this::getColor, s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.elementEnabled);
        c.addBooleanEntry("barmode", this.isBarMode());
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos, true);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos, true);
        c.addSliderEntry("width", 1, this::maxW, this.width, true);
        c.addSliderEntry("height", 1, this::maxH, this.height, true);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        c.addSliderEntry("ttype", 0, () -> 3, StaminAnim.type);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        c.addSpaceEntry();
        c.addTitleEntry("bhue");
        c.addSliderEntry("bhue", 0, () -> 100, this.hue, false);
        c.addTitleEntry("ohue");
        c.addSliderEntry("ohue", 0, () -> 100, this.oHue, false);
        c.addTitleEntry("bai");
        c.addColorEntry("bcit", this.colorIncTop);
        c.addColorEntry("bcib", this.colorIncBot);
        c.addTitleEntry("bad");
        c.addColorEntry("bcdt", this.colorDecTop);
        c.addColorEntry("bcdb", this.colorDecBot);
        return c;
    }

    @Override
    public RenderItem.SmallBound setTextType(int d) {
        return StaminAnim.setTextType(d);
    }

    @Override
    public int getTextType() {
        return StaminAnim.getTextType();
    }

    @Override
    public boolean isEnabled() {
        return this.elementEnabled && (EFCompatManager.active() || FCompatManager.active());
    }
}

