/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.api.mod.arsnoveau.ANCompatManager;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.BarBase;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;
import io.sedu.mc.parties.client.overlay.anim.ManaAnim;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.AnimUtils;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.fml.ModList;

public class PMana
extends BarBase {
    public PMana(String name) {
        super(name, (Component)Component.m_237115_((String)"ui.sedparties.tooltip.mana"));
    }

    @Override
    protected void renderElement(PoseStack g, ForgeGui gui, Button b) {
        RenderSystem.enableDepthTest();
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
        if (ANCompatManager.getHandler().exists()) {
            int max = RenderItem.barModsPresent();
            if (max > 0) {
                int spacing = 240 / max;
                int index = RenderItem.getBarIndex(this);
                updater.get("xpos").onUpdate(this, 46 + spacing / 2 * index);
                updater.get("width").onUpdate(this, spacing);
            }
            updater.get("display").onUpdate(this, true);
        }
    }

    @Override
    protected void renderSelfBar(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getMana(mana -> {
            if (id.isDead) {
                if (this.iconEnabled) {
                    RenderUtils.sizeRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorBot, this.bColorBot);
                    RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
                }
                return;
            }
            if (this.iconEnabled) {
                this.renderMana(x, y, g, (ManaAnim)mana);
                if (mana.active) {
                    this.renderManaAnim(x, y, g, (ManaAnim)mana, partialTicks);
                }
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 255 - id.alphaI << 24);
            }
            if (this.textEnabled) {
                g.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zPos);
                this.textCentered(x + this.tX(), y + this.tY(), g, mana.displayText, this.color);
            }
        });
    }

    @Override
    protected void renderSelfIcon(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getMana(mana -> {
            if (this.iconEnabled) {
                PMana.setup();
                this.blit(g, partyPath, this.xPos, this.yPos, 9, 0, 9, 9);
            }
            if (this.textEnabled) {
                this.text(x + this.tXI(), y + this.tYI(), g, mana.displayText, this.color);
            }
        });
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData p, int mouseX, int mouseY) {
        if (p.isOnline && !p.isSpectator) {
            p.getMana(h -> this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + AnimBarHandler.DF.format(h.cur) + "/" + AnimBarHandler.DF.format(h.max), 10321148, 3215181, 16769415));
        }
    }

    private void renderMana(int x, int y, GuiGraphics g, ManaAnim mana) {
        float hB = mana.getPercent();
        RenderUtils.sizeRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorTop, this.bColorBot);
        RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
        this.rectRNoA(g.m_280168_(), x, y, hB, this.colorTop, this.colorBot);
    }

    private void renderManaAnim(int x, int y, GuiGraphics g, ManaAnim mana, float partialTicks) {
        if ((float)mana.animTime - partialTicks < 10.0f) {
            mana.oldH += (mana.curH - mana.oldH) * AnimUtils.animPos(10 - mana.animTime, partialTicks, true, 10, 1.0f);
        }
        if (mana.hInc) {
            this.rectAnim(g.m_280168_(), x, y, mana.oldH, mana.curH, this.colorIncTop, this.colorIncBot);
        } else {
            this.rectAnim(g.m_280168_(), x, y, mana.curH, mana.oldH, this.colorDecTop, this.colorDecBot);
        }
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = new ConfigOptionsList(this::getColor, s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.elementEnabled);
        c.addBooleanEntry("barmode", this.isBarMode());
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos, true);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos, true);
        c.addSliderEntry("width", 1, this::maxW, this.width, true);
        c.addSliderEntry("height", 1, this::maxH, this.height, true);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        c.addSliderEntry("ttype", 0, () -> 2, ManaAnim.type);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        c.addSpaceEntry();
        c.addTitleEntry("bhue");
        c.addSliderEntry("bhue", 0, () -> 100, this.hue, false);
        c.addTitleEntry("bai");
        c.addColorEntry("bcit", this.colorIncTop);
        c.addColorEntry("bcib", this.colorIncBot);
        c.addTitleEntry("bad");
        c.addColorEntry("bcdt", this.colorDecTop);
        c.addColorEntry("bcdb", this.colorDecBot);
        return c;
    }

    @Override
    public RenderItem.SmallBound setTextType(int d) {
        return ManaAnim.setTextType(d);
    }

    @Override
    public int getTextType() {
        return ManaAnim.getTextType();
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", false, 1);
        e.addEntry("barmode", true, 1);
        e.addEntry("scale", 1, 2);
        e.addEntry("zpos", 1, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 46, 12);
        e.addEntry("ypos", 35, 12);
        e.addEntry("width", 240, 12);
        e.addEntry("height", 10, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", true, 1);
        e.addEntry("ttype", 0, 4);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        e.addEntry("bhue", 62, 7);
        e.addEntry("bcit", 10275583, 24);
        e.addEntry("bcib", 7123199, 24);
        e.addEntry("bcdt", 6787286, 24);
        e.addEntry("bcdb", 1915756, 24);
        return e;
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    public boolean isEnabled() {
        return this.elementEnabled && ModList.get().isLoaded("ars_nouveau");
    }
}

