/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderIconTextItem;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.TooltipItem;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PLevelBar
extends RenderIconTextItem
implements TooltipItem {
    public PLevelBar(String name) {
        super(name);
        this.height = 5;
    }

    @Override
    int getColor() {
        return 8322080;
    }

    @Override
    void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        float bar = Minecraft.m_91087_().f_91074_.f_36080_;
        PLevelBar.setup();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS);
        RenderSystem.enableDepthTest();
        int w = (int)(20.0f * bar);
        if (w > 10) {
            // empty if block
        }
        if (w > 10) {
            // empty if block
        }
        String level = String.valueOf(Minecraft.m_91087_().f_91074_.f_36078_);
        int x = b.m_252754_() + 12 - (gui.m_93082_().m_92895_(level) >> 1);
        int y = b.m_252907_() + 5;
        poseStack.m_252880_(0.0f, 0.0f, (float)this.zPos);
        poseStack.m_252880_(0.0f, 0.0f, (float)(-this.zPos));
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isOnline && !id.isSpectator) {
            this.renderBar(x, y, g, id.getXpBar(), id.getXpLevel());
        }
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isSpectator) {
            return;
        }
        this.renderBar(x, y, g, id.getXpBarForced(), id.getLevelForced());
    }

    void renderBar(int x, int y, GuiGraphics g, float bar, int level) {
        if (this.iconEnabled) {
            PLevelBar.setup();
            RenderSystem.enableDepthTest();
            this.blit(g, GUI_ICONS, x, y, 0, 64, this.width >> 1, this.height);
            this.blit(g, GUI_ICONS, x + (this.width >> 1), y, 182 - (this.width >> 1), 64, this.width >> 1, this.height);
            int w = (int)((float)this.width * bar);
            if (w > this.width >> 1) {
                this.blit(g, GUI_ICONS, x, y, 0, 69, this.width >> 1, this.height);
                this.blit(g, GUI_ICONS, x + (this.width >> 1), y, 182 - (this.width >> 1), 69, w - (this.width >> 1), this.height);
            } else {
                this.blit(g, GUI_ICONS, x, y, 0, 69, w, this.height);
            }
        }
        if (this.textEnabled) {
            this.renderText(g, String.valueOf(level), x + this.tX() - (PLevelBar.getFont().m_92895_(String.valueOf(level)) >> 1), y + this.tY(), bar);
        }
    }

    private void renderText(GuiGraphics g, String s, int x, int y, float level) {
        g.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zPos);
        if (this.textShadow) {
            this.text(x + 1, y, g, s, 0, false);
            this.text(x - 1, y, g, s, 0, false);
            this.text(x, y + 1, g, s, 0, false);
            this.text(x, y - 1, g, s, 0, false);
        }
        this.text(x, y, g, s, 8453920, false);
        g.m_280168_().m_252880_(0.0f, 0.0f, (float)(-this.zPos));
    }

    protected void renderXpTooltip(GuiGraphics g, int mouseX, int mouseY, int offsetX, int offsetY, float bar, int level) {
        int left = mouseX + offsetX;
        int top = currentY + mouseY + offsetY;
        PLevelBar.rectCO(g.m_280168_(), 0, -3, mouseX + offsetX, currentY + mouseY + offsetY, mouseX + offsetX + 182, currentY + mouseY + 5 + offsetY, 9355877, 3694106);
        PLevelBar.rectCO(g.m_280168_(), 0, -2, mouseX + offsetX, currentY + mouseY + offsetY, mouseX + offsetX + 182, currentY + mouseY + 5 + offsetY, 1312020, 1312020);
        PLevelBar.setup();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS);
        this.blit(g, GUI_ICONS, mouseX + offsetX, currentY + mouseY + offsetY, 0, 64, 182, 5);
        this.blit(g, GUI_ICONS, mouseX + offsetX, currentY + mouseY + offsetY, 0, 69, (int)(182.0f * bar), 5);
        String s = "" + level;
        int i1 = left + 91 - PLevelBar.getFont().m_92895_(s) / 2;
        int j1 = top - 1;
        g.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zPos);
        this.text(i1, j1, g, s, 8453920, true);
        Objects.requireNonNull(PLevelBar.getFont());
        currentY += 9 + offsetY + 4;
        g.m_280168_().m_252880_(0.0f, 0.0f, (float)(-this.zPos));
    }

    @Override
    protected int attachedX() {
        return this.width >> 1;
    }

    @Override
    protected int attachedY() {
        return -1;
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = super.getConfigOptions(s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.isEnabled());
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, () -> Math.max(0, frameEleW - (int)((float)this.width * this.scale)), this.xPos, true);
        c.addSliderEntry("ypos", 0, () -> Math.max(0, frameEleH - (int)((float)this.height * this.scale)), this.yPos, true);
        c.addSliderEntry("width", 1, this::maxW, this.width, true);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        c.addColorEntry("tcolor", this.color);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        return c;
    }

    protected int maxW() {
        return (int)Math.min(Math.ceil((float)frameEleW / this.scale), 364.0);
    }

    @Override
    protected void updateValues() {
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("scale", 2, 2);
        e.addEntry("zpos", 0, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 4, 12);
        e.addEntry("ypos", 44, 12);
        e.addEntry("width", 40, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", true, 1);
        e.addEntry("tcolor", 8454027, 24);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        return e;
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData p, int mouseX, int mouseY) {
        this.renderXpTooltip(g, mouseX, mouseY, 10, 0, p.getXpBarForced(), p.getLevelForced());
    }
}

