/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.OverflowBarBase;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;
import io.sedu.mc.parties.client.overlay.anim.HungerAnim;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.AnimUtils;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PHunger
extends OverflowBarBase {
    public PHunger(String name) {
        super(name, (Component)Component.m_237115_((String)"ui.sedparties.tooltip.hunger"));
    }

    @Override
    protected void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
        RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), b.m_252754_() + 7, b.m_252907_() + 5, 0, 14.0f, 7, this.bColorTop, this.bColorBot);
        RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), b.m_252754_() + 8, b.m_252907_() + 6, 0, 12.0f, 5, this.colorTop, this.colorBot);
        PHunger.setup();
        RenderSystem.enableDepthTest();
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
        if (PHunger.barModsPresent() > 0) {
            updater.get("ypos").onUpdate(this, 17);
        }
    }

    @Override
    protected void renderSelfBar(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getHunger(hunger -> {
            if (id.isDead) {
                if (this.iconEnabled) {
                    RenderUtils.sizeRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorBot, this.bColorBot);
                    RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
                }
                return;
            }
            if (this.iconEnabled) {
                this.renderHunger(x, y, g.m_280168_(), (HungerAnim)hunger);
                if (hunger.active) {
                    this.renderHungerAnim(x, y, g.m_280168_(), (HungerAnim)hunger, partialTicks);
                }
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 255 - id.alphaI << 24);
            }
            if (this.textEnabled) {
                if (hunger.absorb > 0.0f) {
                    this.textCentered(x + this.tX(), y + this.tY(), g, hunger.displayText, this.absorbColor);
                } else {
                    this.textCentered(x + this.tX(), y + this.tY(), g, hunger.displayText, this.color);
                }
            }
        });
    }

    private void renderHungerAnim(int x, int y, PoseStack poseStack, HungerAnim hunger, float partialTicks) {
        if ((float)hunger.animTime - partialTicks < 10.0f) {
            hunger.oldH += (hunger.curH - hunger.oldH) * AnimUtils.animPos(10 - hunger.animTime, partialTicks, true, 10, 1.0f);
            hunger.oldA += (hunger.curA - hunger.oldA) * AnimUtils.animPos(10 - hunger.animTime, partialTicks, true, 10, 1.0f);
        }
        if (hunger.hInc) {
            if (hunger.effHOld()) {
                this.rectAnim(poseStack, x, y, hunger.oldH, hunger.curH, this.colorAbsTop, this.colorAbsBot);
            } else {
                this.rectAnim(poseStack, x, y, hunger.oldH, hunger.curH, this.colorIncTop, this.colorIncBot);
            }
        } else if (hunger.effH()) {
            this.rectAnim(poseStack, x, y, hunger.curH, hunger.oldH, this.colorAbsTop, this.colorAbsBot);
        } else {
            this.rectAnim(poseStack, x, y, hunger.curH, hunger.oldH, this.colorDecTop, this.colorDecBot);
        }
        if (hunger.aInc) {
            this.rectAnim(poseStack, x, y, hunger.oldA, hunger.curA, this.colorAbsTop, this.colorAbsBot);
        } else {
            this.rectAnim(poseStack, x, y, hunger.curA, hunger.oldA, this.colorAbsTop, this.colorAbsBot);
        }
    }

    private void renderHunger(int x, int y, PoseStack poseStack, HungerAnim hunger) {
        float hB = hunger.getPercent();
        if (hunger.absorb > 0.0f) {
            RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bAColorTop, this.bAColorBot);
            RenderUtils.offRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
            float aB = hB + hunger.getPercentA();
            this.rectRNoA(poseStack, x, y, hB, this.colorTop, this.colorBot);
            this.rectB(poseStack, x, y, hB, aB, this.colorTopAbsorb, this.colorBotAbsorb);
        } else {
            RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorTop, this.bColorBot);
            RenderUtils.offRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
            this.rectRNoA(poseStack, x, y, hB, this.colorTop, this.colorBot);
        }
    }

    @Override
    protected void renderSelfIcon(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getHunger(hunger -> {
            if (this.iconEnabled) {
                PHunger.useAlpha(id.alpha);
                PHunger.setup();
                RenderSystem.enableDepthTest();
                if (hunger.cur > 16.0f) {
                    this.blit(g, GUI_ICONS, x, y, 16, 27, 9, 9);
                    this.blit(g, GUI_ICONS, x, y, 52, 27, 9, 9);
                } else if (hunger.cur > 12.0f) {
                    this.blit(g, GUI_ICONS, x, y, 16, 27, 9, 9);
                    this.blit(g, GUI_ICONS, x, y, 61 - (PHunger.guiTicks() >> 4 & 1) * 9, 27, 9, 9);
                } else if (hunger.cur > 4.0f) {
                    this.blit(g, GUI_ICONS, x, y, 16, 27, 9, 9);
                    if ((PHunger.guiTicks() >> 4 & 1) == 0) {
                        this.blit(g, GUI_ICONS, x, y, 61, 27, 9, 9);
                    }
                } else {
                    this.blit(g, GUI_ICONS, x, y, 16 + (PHunger.guiTicks() >> 3 & 1) * 9, 27, 9, 9);
                }
                PHunger.resetColor();
            }
            if (this.textEnabled) {
                if (hunger.absorb > 0.0f) {
                    this.text(x + this.tXI(), y + this.tYI(), g, hunger.displayText, this.absorbColor);
                } else {
                    this.text(x + this.tXI(), y + this.tYI(), g, hunger.displayText, this.color);
                }
            }
        });
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData p, int mouseX, int mouseY) {
        if (p.isOnline && !p.isSpectator) {
            p.getHunger(hunger -> this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + AnimBarHandler.DF.format(hunger.cur + hunger.absorb) + "/" + AnimBarHandler.DF.format(hunger.max), 12092504, 6372379, 16766384));
        }
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("barmode", false, 1);
        e.addEntry("scale", 2, 2);
        e.addEntry("zpos", 0, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 143, 12);
        e.addEntry("ypos", 19, 12);
        e.addEntry("width", 23, 12);
        e.addEntry("height", 10, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", false, 1);
        e.addEntry("ttype", 3, 4);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        e.addEntry("bhue", 9, 7);
        e.addEntry("ohue", 11, 7);
        e.addEntry("bcit", 16764547, 24);
        e.addEntry("bcib", 12354866, 24);
        e.addEntry("bcdt", 10182144, 24);
        e.addEntry("bcdb", 8276992, 24);
        return e;
    }

    @Override
    public int getId() {
        return 15;
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = new ConfigOptionsList(this::getColor, s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.elementEnabled);
        c.addBooleanEntry("barmode", this.isBarMode());
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos, true);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos, true);
        c.addSliderEntry("width", 1, this::maxW, this.width, true);
        c.addSliderEntry("height", 1, this::maxH, this.height, true);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        c.addSliderEntry("ttype", 0, () -> 3, HungerAnim.type);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        c.addSpaceEntry();
        c.addTitleEntry("bhue");
        c.addSliderEntry("bhue", 0, () -> 100, this.hue, false);
        c.addTitleEntry("bai");
        c.addColorEntry("bcit", this.colorIncTop);
        c.addColorEntry("bcib", this.colorIncBot);
        c.addTitleEntry("bad");
        c.addColorEntry("bcdt", this.colorDecTop);
        c.addColorEntry("bcdb", this.colorDecBot);
        return c;
    }

    @Override
    public RenderItem.SmallBound setTextType(int d) {
        return HungerAnim.setTextType(d);
    }

    @Override
    public int getTextType() {
        return HungerAnim.getTextType();
    }
}

