/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.OverflowBarBase;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.AnimBarHandler;
import io.sedu.mc.parties.client.overlay.anim.HealthAnim;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.AnimUtils;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PHealth
extends OverflowBarBase {
    private TooltipRenderer renderer = (g, p, mouseX, mouseY) -> {
        if (p.isOnline && !p.isSpectator) {
            HealthAnim h = p.getHealth();
            this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + AnimBarHandler.DF.format(h.cur + h.absorb) + "/" + AnimBarHandler.DF.format(h.max), 16547964, 5050639, 0xFFBFBD);
        }
    };

    public PHealth(String name) {
        super(name, (Component)Component.m_237115_((String)"ui.sedparties.tooltip.health"));
    }

    @Override
    protected void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
        if (PHealth.barModsPresent() > 0) {
            updater.get("ypos").onUpdate(this, 26);
        }
    }

    public void updateTooltipForTFC() {
        this.renderer = (g, p, mouseX, mouseY) -> {
            if (p.isOnline && !p.isSpectator) {
                HealthAnim h = p.getHealth();
                this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + Math.round((h.cur + h.absorb) * h.multiplier * 50.0f) + "/" + Math.round(h.max * h.multiplier * 50.0f), 16547964, 5050639, 0xFFBFBD);
            }
        };
    }

    @Override
    protected void renderSelfBar(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        HealthAnim hA = id.getHealth();
        if (id.isDead) {
            if (this.iconEnabled) {
                RenderUtils.sizeRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorBot, this.bColorBot);
                RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
            }
            this.textCentered(x + this.tX(), y + this.tY(), g, "Dead", this.deadColor);
            return;
        }
        if (this.iconEnabled) {
            this.renderHealth(x, y, g.m_280168_(), hA);
            if (hA.active) {
                this.renderHealthAnim(x, y, g.m_280168_(), hA, partialTicks);
            }
            RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 255 - id.alphaI << 24);
        }
        if (this.textEnabled) {
            if (hA.absorb > 0.0f) {
                this.textCentered(x + this.tX(), y + this.tY(), g, hA.displayText, this.absorbColor);
            } else {
                this.textCentered(x + this.tX(), y + this.tY(), g, hA.displayText, this.color);
            }
        }
    }

    @Override
    protected void renderSelfIcon(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        HealthAnim hA = id.getHealth();
        if (this.iconEnabled) {
            PHealth.setup();
            float percent = hA.getPercentE();
            if (hA.absorb > 0.0f) {
                this.blit(g, GUI_ICONS, x, y, 16, 0, 9, 9);
                this.blit(g, GUI_ICONS, x, y, 160, 0, 9, 9);
            } else if (percent > 0.8f) {
                this.blit(g, GUI_ICONS, x, y, 16, 0, 9, 9);
                this.blit(g, GUI_ICONS, x, y, 52, 0, 9, 9);
            } else if (percent > 0.6f) {
                this.blit(g, GUI_ICONS, x, y, 16, 0, 9, 9);
                this.blit(g, GUI_ICONS, x, y, 61 - (PHealth.guiTicks() >> 4 & 1) * 9, 0, 9, 9);
            } else if (percent > 0.2f) {
                this.blit(g, GUI_ICONS, x, y, 16, 0, 9, 9);
                if ((PHealth.guiTicks() >> 4 & 1) == 0) {
                    this.blit(g, GUI_ICONS, x, y, 61, 0, 9, 9);
                }
            } else {
                this.blit(g, GUI_ICONS, x, y, 16 + (PHealth.guiTicks() >> 3 & 1) * 9, 0, 9, 9);
            }
        }
        if (this.textEnabled) {
            if (hA.absorb > 0.0f) {
                this.text(this.tXI(), this.tYI(), g, hA.displayText, this.absorbColor);
            } else {
                this.text(this.tXI(), this.tYI(), g, hA.displayText, this.color);
            }
        }
    }

    private void renderHealth(int x, int y, PoseStack poseStack, HealthAnim health) {
        float hB = health.getPercent();
        if (health.absorb > 0.0f) {
            RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bAColorTop, this.bAColorBot);
            RenderUtils.offRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
            float aB = hB + health.getPercentA();
            this.rectRNoA(poseStack, x, y, hB, this.colorTop, this.colorBot);
            this.rectB(poseStack, x, y, hB, aB, this.colorTopAbsorb, this.colorBotAbsorb);
        } else {
            RenderUtils.sizeRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, this.bColorTop, this.bColorBot);
            RenderUtils.offRectNoA(poseStack.m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, this.colorTopMissing, this.colorBotMissing);
            this.rectRNoA(poseStack, x, y, hB, this.colorTop, this.colorBot);
        }
    }

    private void renderHealthAnim(int x, int y, PoseStack poseStack, HealthAnim health, float partialTicks) {
        if ((float)health.animTime - partialTicks < 10.0f) {
            health.oldH += (health.curH - health.oldH) * AnimUtils.animPos(10 - health.animTime, partialTicks, true, 10, 1.0f);
            health.oldA += (health.curA - health.oldA) * AnimUtils.animPos(10 - health.animTime, partialTicks, true, 10, 1.0f);
        }
        if (health.hInc) {
            if (health.effHOld()) {
                this.rectAnim(poseStack, x, y, health.oldH, health.curH, this.colorAbsTop, this.colorAbsBot);
            } else {
                this.rectAnim(poseStack, x, y, health.oldH, health.curH, this.colorIncTop, this.colorIncBot);
            }
        } else if (health.effH()) {
            this.rectAnim(poseStack, x, y, health.curH, health.oldH, this.colorAbsTop, this.colorAbsBot);
        } else {
            this.rectAnim(poseStack, x, y, health.curH, health.oldH, this.colorDecTop, this.colorDecBot);
        }
        if (health.aInc) {
            this.rectAnim(poseStack, x, y, health.oldA, health.curA, this.colorAbsTop, this.colorAbsBot);
        } else {
            this.rectAnim(poseStack, x, y, health.curA, health.oldA, this.colorAbsTop, this.colorAbsBot);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData id, int mouseX, int mouseY) {
        this.renderer.render(g, id, mouseX, mouseY);
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("barmode", true, 1);
        e.addEntry("scale", 2, 2);
        e.addEntry("zpos", 0, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 46, 12);
        e.addEntry("ypos", 29, 12);
        e.addEntry("width", 120, 12);
        e.addEntry("height", 10, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", true, 1);
        e.addEntry("ttype", 0, 4);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        e.addEntry("bhue", 0, 7);
        e.addEntry("ohue", 11, 7);
        e.addEntry("bcit", 0xC5FFC5, 24);
        e.addEntry("bcib", 0x6CFF6C, 24);
        e.addEntry("bcdt", 0xFFC5C5, 24);
        e.addEntry("bcdb", 0xFF6C6C, 24);
        return e;
    }

    @Override
    public int getId() {
        return 14;
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = new ConfigOptionsList(this::getColor, s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.elementEnabled);
        c.addBooleanEntry("barmode", this.isBarMode());
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos, true);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos, true);
        c.addSliderEntry("width", 1, this::maxW, this.width, true);
        c.addSliderEntry("height", 1, this::maxH, this.height, true);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        c.addSliderEntry("ttype", 0, () -> 3, HealthAnim.type);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        c.addSpaceEntry();
        c.addTitleEntry("bhue");
        c.addSliderEntry("bhue", 0, () -> 100, this.hue, false);
        c.addTitleEntry("ohue");
        c.addSliderEntry("ohue", 0, () -> 100, this.oHue, false);
        c.addTitleEntry("bai");
        c.addColorEntry("bcit", this.colorIncTop);
        c.addColorEntry("bcib", this.colorIncBot);
        c.addTitleEntry("bad");
        c.addColorEntry("bcdt", this.colorDecTop);
        c.addColorEntry("bcdb", this.colorDecBot);
        return c;
    }

    @Override
    public RenderItem.SmallBound setTextType(int d) {
        return HealthAnim.setTextType(d);
    }

    @Override
    public int getTextType() {
        return HealthAnim.getTextType();
    }

    private static interface TooltipRenderer {
        public void render(GuiGraphics var1, ClientPlayerData var2, int var3, int var4);
    }
}

