/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.RenderSelfItem;
import io.sedu.mc.parties.client.overlay.ScaleItem;
import io.sedu.mc.parties.client.overlay.TooltipItem;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.GUIRenderer;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.data.config.ClientConfigData;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class PHead
extends RenderSelfItem
implements TooltipItem,
ScaleItem {
    public static ItemStack icon = null;
    protected static int renderType = 0;
    private Renderer renderSelf;
    private Renderer renderMember;
    public static ModelRender modelRender;
    private static int modelOffset;
    protected static boolean renderBleed;

    public PHead(String name) {
        super(name);
        this.width = 32;
        this.height = 32;
        this.renderSelf = (x, y, id, g, partialTicks) -> {
            if (renderType != 0 && id.clientPlayer != null && !id.getDim().active) {
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 0x33FFFFFF);
                RenderUtils.renderEntityInInventory((int)((float)(x + 16) * this.scale), (int)((float)y * this.scale), this.scale, (int)(15.0f * this.scale), (LivingEntity)id.clientPlayer, partialTicks, g);
                return;
            }
            RenderSystem.enableDepthTest();
            if (id.isDead) {
                PHead.setColor(1.0f, 0.5f, 0.5f, 0.5f);
            } else {
                PHead.setColor(1.0f, 1.0f, 1.0f, id.alpha);
            }
            RenderUtils.grayRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, this.height, 0.05f, id.alpha, 0.5f, id.alpha);
            PHead.setup();
            this.blit(g, id.getHead(), x, y, 32, 32, 32, 32);
            this.blit(g, id.getHead(), x, y, 160, 32, 32, 32);
            PHead.resetColor();
        };
        this.renderMember = (x, y, id, g, partialTicks) -> {
            if (renderType == 2 && id.shouldRenderModel) {
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 0x33FFFFFF);
                RenderUtils.renderEntityInInventory((int)((float)(x + 16) * this.scale), (int)((float)y * this.scale), this.scale, (int)(15.0f * this.scale), (LivingEntity)id.clientPlayer, partialTicks, g);
                PHead.resetColor();
                return;
            }
            RenderSystem.enableDepthTest();
            if (id.isDead) {
                PHead.setColor(1.0f, 0.5f, 0.5f, 0.5f);
            } else {
                PHead.setColor(1.0f, 1.0f, 1.0f, id.alpha);
            }
            RenderUtils.grayRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, this.height, 0.05f, id.alpha, 0.5f, id.alpha);
            PHead.setup();
            this.blit(g, id.getHead(), x, y, 32, 32, 32, 32);
            this.blit(g, id.getHead(), x, y, 160, 32, 32, 32);
            PHead.resetColor();
        };
    }

    public static void updateModelRenderer() {
        modelOffset = (Integer)ClientConfigData.rotationOffset.get();
        if (((Boolean)ClientConfigData.forceModelRotation.get()).booleanValue()) {
            Parties.debug("Forcing model rotation off...", new Object[0]);
            modelRender = (pPosX, pPosY, g, pScale, pLivingEntity, partialTicks) -> {
                g.m_280168_().m_85836_();
                g.m_280168_().m_85837_((double)pPosX, (double)pPosY, 50.0);
                g.m_280168_().m_252931_(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
                Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
                g.m_280168_().m_252781_(quaternion);
                if (pLivingEntity instanceof Player) {
                    Player p = (Player)pLivingEntity;
                    ((GUIRenderer)p).setRenderMode(true);
                }
                Lighting.m_166384_();
                EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
                entityrenderdispatcher.m_114468_(false);
                RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)pLivingEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, g.m_280168_(), (MultiBufferSource)g.m_280091_(), 0xF000F0));
                g.m_280262_();
                entityrenderdispatcher.m_114468_(true);
                if (pLivingEntity instanceof Player) {
                    Player p = (Player)pLivingEntity;
                    ((GUIRenderer)p).setRenderMode(false);
                }
                g.m_280168_().m_85849_();
                Lighting.m_84931_();
            };
        } else {
            Parties.debug("Forcing model rotation off...", new Object[0]);
            modelRender = (pPosX, pPosY, g, pScale, pLivingEntity, partialTicks) -> {
                g.m_280168_().m_85836_();
                g.m_280168_().m_85837_((double)pPosX, (double)pPosY, 50.0);
                g.m_280168_().m_252931_(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
                Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
                g.m_280168_().m_252781_(quaternion);
                if (pLivingEntity instanceof Player) {
                    Player p = (Player)pLivingEntity;
                    ((GUIRenderer)p).setRenderMode(true);
                }
                Lighting.m_166384_();
                EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
                entityrenderdispatcher.m_114468_(false);
                RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)pLivingEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, g.m_280168_(), (MultiBufferSource)g.m_280091_(), 0xF000F0));
                g.m_280262_();
                entityrenderdispatcher.m_114468_(true);
                if (pLivingEntity instanceof Player) {
                    Player p = (Player)pLivingEntity;
                    ((GUIRenderer)p).setRenderMode(false);
                }
                g.m_280168_().m_85849_();
                Lighting.m_84931_();
            };
        }
    }

    @Override
    int getColor() {
        return 0xAACCAA;
    }

    public void updateRendererForMods() {
        this.renderSelf = (x, y, id, g, partialTicks) -> {
            if (this.renderBleedAnim(id, g, x, y, partialTicks)) {
                return;
            }
            if (renderType != 0 && id.clientPlayer != null && !id.getDim().active) {
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 0x33FFFFFF);
                RenderUtils.renderEntityInInventory((int)((float)(x + 16) * this.scale), (int)((float)y * this.scale), this.scale, (int)(15.0f * this.scale), (LivingEntity)id.clientPlayer, partialTicks, g);
                return;
            }
            RenderSystem.enableDepthTest();
            if (id.isDead) {
                PHead.setColor(1.0f, 0.5f, 0.5f, 0.5f);
            } else {
                PHead.setColor(1.0f, 1.0f, 1.0f, id.alpha);
            }
            RenderUtils.grayRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, this.height, 0.05f, id.alpha, 0.5f, id.alpha);
            PHead.setup();
            this.blit(g, id.getHead(), x, y, 32, 32, 32, 32);
            this.blit(g, id.getHead(), x, y, 160, 32, 32, 32);
            PHead.resetColor();
        };
        this.renderMember = (x, y, id, g, partialTicks) -> {
            if (this.renderBleedAnim(id, g, x, y, partialTicks)) {
                return;
            }
            if (renderType == 2 && id.shouldRenderModel) {
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, this.width, this.height, 0x33FFFFFF);
                PHead.setColor(0.0f, 0.0f, 0.0f, 0.0f);
                RenderUtils.renderEntityInInventory((int)((float)(x + 16) * this.scale), (int)((float)y * this.scale), this.scale, (int)(15.0f * this.scale), (LivingEntity)id.clientPlayer, 1.0f, g);
                PHead.resetColor();
                return;
            }
            RenderSystem.enableDepthTest();
            if (id.isDead) {
                PHead.setColor(1.0f, 0.5f, 0.5f, 0.5f);
            } else {
                PHead.setColor(1.0f, 1.0f, 1.0f, id.alpha);
            }
            RenderUtils.grayRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, this.height, 0.05f, id.alpha, 0.5f, id.alpha);
            PHead.setup();
            this.blit(g, id.getHead(), x, y, 32, 32, 32, 32);
            this.blit(g, id.getHead(), x, y, 160, 32, 32, 32);
            PHead.resetColor();
        };
    }

    private boolean renderBleedAnim(ClientPlayerData id, GuiGraphics g, int x, int y, float partialTicks) {
        if (id.isBleeding()) {
            PHead.resetColor();
            RenderUtils.grayRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, this.height, 0.05f, 1.0f, 0.5f, 1.0f);
            PHead.setup();
            this.blit(g, id.getHead(), x, y, 32, 32, 32, 32);
            this.blit(g, id.getHead(), x, y, 160, 32, 32, 32);
            float heightProgress = (float)this.height * (1.0f - id.getReviveProgress());
            float alpha = (float)(0.75 + Math.sin(((float)PHead.guiTicks() + partialTicks) / 8.0f) / 10.0);
            RenderUtils.grayRectForHead(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, heightProgress, 0.1f, alpha);
            PHead.useAlpha((float)(0.75 + Math.sin(((float)PHead.guiTicks() + partialTicks) / 2.0f) / 4.0));
            if (heightProgress != 32.0f) {
                RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), this.zPos, x - 4, (float)y + heightProgress, x + (this.width >> 1), (float)y + heightProgress + 1.0f, 0xFFFFFF, -1);
                RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), this.zPos, x + (this.width >> 1), (float)y + heightProgress, x + this.width + 4, (float)y + heightProgress + 1.0f, -1, 0xFFFFFF);
            }
            if (!renderBleed) {
                return true;
            }
            g.m_280168_().m_85836_();
            g.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            PHead.resetColor();
            this.text((x + 4) * 2, y * 2, g, "\u00a7lBleeding", 10572370);
            g.m_280168_().m_85849_();
            return true;
        }
        if (id.isDowned()) {
            PHead.resetColor();
            RenderUtils.grayRect(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, this.height, 0.05f, 1.0f, 0.5f, 1.0f);
            PHead.setup();
            this.blit(g, id.getHead(), x, y, 32, 32, 32, 32);
            this.blit(g, id.getHead(), x, y, 160, 32, 32, 32);
            float heightProgress = (float)this.height * (1.0f - id.getReviveProgress());
            float alpha = (float)(0.75 + Math.sin(((float)PHead.guiTicks() + partialTicks) / 8.0f) / 10.0);
            RenderUtils.grayRectForHead(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, -1, this.width, heightProgress, 0.1f, alpha);
            PHead.useAlpha((float)(0.75 + Math.sin(((float)PHead.guiTicks() + partialTicks) / 2.0f) / 4.0));
            if (heightProgress != 32.0f) {
                RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), this.zPos, x - 4, (float)y + heightProgress, x + (this.width >> 1), (float)y + heightProgress + 1.0f, 0xFFFFFF, -1);
                RenderUtils.horizRect(g.m_280168_().m_85850_().m_252922_(), this.zPos, x + (this.width >> 1), (float)y + heightProgress, x + this.width + 4, (float)y + heightProgress + 1.0f, -1, 0xFFFFFF);
            }
            if (!renderBleed) {
                return true;
            }
            g.m_280168_().m_85836_();
            g.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            PHead.resetColor();
            this.text((x + 10) * 2, y * 2, g, "\u00a7lK.O'd", 10572370);
            g.m_280168_().m_85849_();
            return true;
        }
        return false;
    }

    @Override
    void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("htype", 1, 2);
        e.addEntry("xpos", 8, 12);
        e.addEntry("ypos", 8, 12);
        e.addEntry("zpos", 0, 4);
        e.addEntry("scale", 2, 2);
        e.addEntry("bleed", true, 1);
        return e;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        this.renderMember.render(x, y, id, g, partialTicks);
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        this.renderSelf.render(x, y, id, g, partialTicks);
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = super.getConfigOptions(s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("display");
        c.addBooleanEntry("display", this.isEnabled());
        c.addSliderEntry("htype", 0, () -> 2, renderType);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addBooleanEntry("bleed", renderBleed);
        return c;
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData p, int mouseX, int mouseY) {
        this.renderTooltip(g, mouseX, mouseY, 10, 0, p.getName(), 0xDDDDDD, 0xAAAAAA, 0xFFFFFF);
    }

    @Override
    public void setGlobalScale(float scale) {
    }

    static {
        modelOffset = 0;
        renderBleed = false;
    }

    private static interface Renderer {
        public void render(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);
    }

    public static interface ModelRender {
        public void renderModel(float var1, float var2, GuiGraphics var3, int var4, LivingEntity var5, float var6);
    }
}

